/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class RecordState
implements IMocksControlState,
Serializable {
    private static final long serialVersionUID = -5418279681566430252L;
    private ExpectedInvocation lastInvocation = null;
    private boolean lastInvocationUsed = true;
    private Result lastResult;
    private final IMocksBehavior behavior;
    private static final Map<Class<?>, Object> emptyReturnValues = new HashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveToWrapperType;

    public RecordState(IMocksBehavior iMocksBehavior) {
        this.behavior = iMocksBehavior;
    }

    @Override
    public void assertRecordState() {
    }

    @Override
    public Object invoke(Invocation invocation) {
        this.closeMethod();
        List<IArgumentMatcher> list = LastControl.pullMatchers();
        this.lastInvocation = new ExpectedInvocation(invocation, list);
        this.lastInvocationUsed = false;
        return RecordState.emptyReturnValueFor(invocation.getMethod().getReturnType());
    }

    @Override
    public void replay() {
        this.closeMethod();
        if (LastControl.pullMatchers() != null) {
            throw new IllegalStateException("matcher calls were used outside expectations");
        }
    }

    @Override
    public void verify() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    @Override
    public void andReturn(Object object) {
        this.requireMethodCall("return value");
        object = this.convertNumberClassIfNeccessary(object);
        this.requireAssignable(object);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createReturnResult(object);
    }

    @Override
    public void andThrow(Throwable throwable) {
        this.requireMethodCall("Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createThrowResult(throwable);
    }

    @Override
    public void andAnswer(IAnswer<?> iAnswer) {
        this.requireMethodCall("answer");
        this.requireValidAnswer(iAnswer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createAnswerResult(iAnswer);
    }

    @Override
    public void andDelegateTo(Object object) {
        this.requireMethodCall("delegate");
        this.requireValidDelegation(object);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createDelegatingResult(object);
    }

    @Override
    public void andVoid() {
        this.requireMethodCall("void");
        this.requireVoidMethod();
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createReturnResult(null);
    }

    @Override
    public void andStubReturn(Object object) {
        this.requireMethodCall("stub return value");
        object = this.convertNumberClassIfNeccessary(object);
        this.requireAssignable(object);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(object));
        this.lastInvocationUsed = true;
    }

    @Override
    public void asStub() {
        this.requireMethodCall("stub behavior");
        this.requireVoidMethod();
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(null));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        this.requireMethodCall("stub Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createThrowResult(throwable));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubAnswer(IAnswer<?> iAnswer) {
        this.requireMethodCall("stub answer");
        this.requireValidAnswer(iAnswer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createAnswerResult(iAnswer));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubDelegateTo(Object object) {
        this.requireMethodCall("stub delegate");
        this.requireValidDelegation(object);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createDelegatingResult(object));
        this.lastInvocationUsed = true;
    }

    @Override
    public void times(Range range) {
        this.requireMethodCall("times");
        this.requireLastResultOrVoidMethod();
        this.behavior.addExpected(this.lastInvocation, this.lastResult != null ? this.lastResult : Result.createReturnResult(null), range);
        this.lastInvocationUsed = true;
        this.lastResult = null;
    }

    private Object createNumberObject(Object object, Class<?> clazz) {
        if (!(object instanceof Number)) {
            return object;
        }
        Number number = (Number)object;
        if (clazz.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (clazz.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (clazz.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (clazz.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        return number;
    }

    private Object convertNumberClassIfNeccessary(Object object) {
        Class<?> clazz = this.lastInvocation.getMethod().getReturnType();
        return this.createNumberObject(object, clazz);
    }

    private void closeMethod() {
        if (this.lastInvocationUsed && this.lastResult == null) {
            return;
        }
        if (!this.isLastResultOrVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("missing behavior definition for the preceding method call:\n" + this.lastInvocation.toString() + "\nUsage is: expect(a.foo()).andXXX()"));
        }
        this.times(MocksControl.ONCE);
    }

    public static Object emptyReturnValueFor(Class<?> clazz) {
        return clazz.isPrimitive() ? emptyReturnValues.get(clazz) : null;
    }

    private void requireMethodCall(String string) {
        if (this.lastInvocation == null) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("method call on the mock needed before setting " + string));
        }
    }

    private void requireAssignable(Object object) {
        if (this.lastMethodIsVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("void method cannot return a value"));
        }
        if (object == null) {
            Class<?> clazz = this.lastInvocation.getMethod().getReturnType();
            if (clazz.isPrimitive()) {
                throw new RuntimeExceptionWrapper(new IllegalStateException("can't return null for a method returning a primitive type"));
            }
            return;
        }
        Class<?> clazz = this.lastInvocation.getMethod().getReturnType();
        if (clazz.isPrimitive()) {
            clazz = primitiveToWrapperType.get(clazz);
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
        }
    }

    private void requireValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("null cannot be thrown"));
        }
        if (this.isValidThrowable(throwable)) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalArgumentException("last method called on mock cannot throw " + throwable.getClass().getName()));
    }

    private void requireValidAnswer(IAnswer<?> iAnswer) {
        if (iAnswer == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("answer object must not be null"));
        }
    }

    private void requireValidDelegation(Object object) {
        if (object == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("delegated to object must not be null"));
        }
    }

    private void requireLastResultOrVoidMethod() {
        if (this.isLastResultOrVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private void requireVoidMethod() {
        if (this.lastMethodIsVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private boolean isLastResultOrVoidMethod() {
        return this.lastResult != null || this.lastMethodIsVoidMethod();
    }

    private boolean lastMethodIsVoidMethod() {
        Class<?> clazz = this.lastInvocation.getMethod().getReturnType();
        return clazz.equals(Void.TYPE);
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] classArray = this.lastInvocation.getMethod().getExceptionTypes();
        Class<?> clazz = throwable.getClass();
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkOrder(boolean bl) {
        this.closeMethod();
        this.behavior.checkOrder(bl);
    }

    @Override
    public void makeThreadSafe(boolean bl) {
        this.behavior.makeThreadSafe(bl);
    }

    @Override
    public void checkIsUsedInOneThread(boolean bl) {
        this.behavior.shouldBeUsedInOneThread(bl);
    }

    static {
        emptyReturnValues.put(Void.TYPE, null);
        emptyReturnValues.put(Boolean.TYPE, Boolean.FALSE);
        emptyReturnValues.put(Byte.TYPE, (byte)0);
        emptyReturnValues.put(Short.TYPE, (short)0);
        emptyReturnValues.put(Character.TYPE, Character.valueOf('\u0000'));
        emptyReturnValues.put(Integer.TYPE, 0);
        emptyReturnValues.put(Long.TYPE, 0L);
        emptyReturnValues.put(Float.TYPE, Float.valueOf(0.0f));
        emptyReturnValues.put(Double.TYPE, 0.0);
        primitiveToWrapperType = new HashMap(8);
        primitiveToWrapperType.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperType.put(Byte.TYPE, Byte.class);
        primitiveToWrapperType.put(Short.TYPE, Short.class);
        primitiveToWrapperType.put(Character.TYPE, Character.class);
        primitiveToWrapperType.put(Integer.TYPE, Integer.class);
        primitiveToWrapperType.put(Long.TYPE, Long.class);
        primitiveToWrapperType.put(Float.TYPE, Float.class);
        primitiveToWrapperType.put(Double.TYPE, Double.class);
    }
}

