/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.util.Comparator;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.LogicalOperator;
import org.easymock.MockType;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockBuilder;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.Any;
import org.easymock.internal.matchers.ArrayEquals;
import org.easymock.internal.matchers.Captures;
import org.easymock.internal.matchers.Compare;
import org.easymock.internal.matchers.CompareEqual;
import org.easymock.internal.matchers.Contains;
import org.easymock.internal.matchers.EndsWith;
import org.easymock.internal.matchers.Equals;
import org.easymock.internal.matchers.EqualsWithDelta;
import org.easymock.internal.matchers.Find;
import org.easymock.internal.matchers.GreaterOrEqual;
import org.easymock.internal.matchers.GreaterThan;
import org.easymock.internal.matchers.InstanceOf;
import org.easymock.internal.matchers.LessOrEqual;
import org.easymock.internal.matchers.LessThan;
import org.easymock.internal.matchers.Matches;
import org.easymock.internal.matchers.NotNull;
import org.easymock.internal.matchers.Null;
import org.easymock.internal.matchers.Same;
import org.easymock.internal.matchers.StartsWith;

public class EasyMock {
    public static final String ENABLE_THREAD_SAFETY_CHECK_BY_DEFAULT = "easymock.enableThreadSafetyCheckByDefault";
    public static final String NOT_THREAD_SAFE_BY_DEFAULT = "easymock.notThreadSafeByDefault";
    public static final String DISABLE_CLASS_MOCKING = "easymock.disableClassMocking";

    public static <T> T mock(Class<T> clazz) {
        return EasyMock.createControl().createMock(clazz);
    }

    public static <T> T mock(String string, Class<T> clazz) {
        return EasyMock.createControl().createMock(string, clazz);
    }

    public static <T> T mock(MockType mockType, Class<T> clazz) {
        return EasyMock.createControl(mockType).createMock(clazz);
    }

    public static <T> T mock(String string, MockType mockType, Class<T> clazz) {
        return EasyMock.createControl(mockType).createMock(string, clazz);
    }

    public static <T> T strictMock(Class<T> clazz) {
        return EasyMock.createStrictControl().createMock(clazz);
    }

    public static <T> T strictMock(String string, Class<T> clazz) {
        return EasyMock.createStrictControl().createMock(string, clazz);
    }

    public static <T> T niceMock(Class<T> clazz) {
        return EasyMock.createNiceControl().createMock(clazz);
    }

    public static <T> T niceMock(String string, Class<T> clazz) {
        return EasyMock.createNiceControl().createMock(string, clazz);
    }

    public static <T> IMockBuilder<T> partialMockBuilder(Class<T> clazz) {
        return new MockBuilder<T>(clazz);
    }

    public static <T> T createMock(MockType mockType, Class<T> clazz) {
        return EasyMock.mock(mockType, clazz);
    }

    public static <T> T createMock(String string, MockType mockType, Class<T> clazz) {
        return EasyMock.mock(string, mockType, clazz);
    }

    public static <T> T createStrictMock(Class<T> clazz) {
        return EasyMock.strictMock(clazz);
    }

    public static <T> T createStrictMock(String string, Class<T> clazz) {
        return EasyMock.strictMock(string, clazz);
    }

    public static <T> T createMock(Class<T> clazz) {
        return EasyMock.mock(clazz);
    }

    public static <T> T createMock(String string, Class<T> clazz) {
        return EasyMock.mock(string, clazz);
    }

    public static <T> T createNiceMock(Class<T> clazz) {
        return EasyMock.niceMock(clazz);
    }

    public static <T> T createNiceMock(String string, Class<T> clazz) {
        return EasyMock.niceMock(string, clazz);
    }

    public static <T> IMockBuilder<T> createMockBuilder(Class<T> clazz) {
        return EasyMock.partialMockBuilder(clazz);
    }

    public static IMocksControl createControl(MockType mockType) {
        return new MocksControl(mockType);
    }

    public static IMocksControl createStrictControl() {
        return EasyMock.createControl(MockType.STRICT);
    }

    public static IMocksControl createControl() {
        return EasyMock.createControl(MockType.DEFAULT);
    }

    public static IMocksControl createNiceControl() {
        return EasyMock.createControl(MockType.NICE);
    }

    public static <T> IExpectationSetters<T> expect(T t) {
        return EasyMock.getControlForLastCall();
    }

    public static <T> IExpectationSetters<T> expectLastCall() {
        return EasyMock.getControlForLastCall();
    }

    private static <T> IExpectationSetters<T> getControlForLastCall() {
        MocksControl mocksControl = LastControl.lastControl();
        if (mocksControl == null) {
            LastControl.pullMatchers();
            throw new IllegalStateException("no last call on a mock available");
        }
        return mocksControl;
    }

    public static boolean anyBoolean() {
        EasyMock.reportMatcher(Any.ANY);
        return false;
    }

    public static byte anyByte() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static char anyChar() {
        EasyMock.reportMatcher(Any.ANY);
        return '\u0000';
    }

    public static int anyInt() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static long anyLong() {
        EasyMock.reportMatcher(Any.ANY);
        return 0L;
    }

    public static float anyFloat() {
        EasyMock.reportMatcher(Any.ANY);
        return 0.0f;
    }

    public static double anyDouble() {
        EasyMock.reportMatcher(Any.ANY);
        return 0.0;
    }

    public static short anyShort() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static <T> T anyObject() {
        EasyMock.reportMatcher(Any.ANY);
        return null;
    }

    public static <T> T anyObject(Class<T> clazz) {
        EasyMock.reportMatcher(Any.ANY);
        return null;
    }

    public static String anyString() {
        return (String)EasyMock.anyObject();
    }

    public static <T extends Comparable<T>> T geq(Comparable<T> comparable) {
        EasyMock.reportMatcher(new GreaterOrEqual<T>(comparable));
        return null;
    }

    public static byte geq(byte by) {
        EasyMock.reportMatcher(new GreaterOrEqual<Byte>(Byte.valueOf(by)));
        return 0;
    }

    public static double geq(double d) {
        EasyMock.reportMatcher(new GreaterOrEqual<Double>(Double.valueOf(d)));
        return 0.0;
    }

    public static float geq(float f) {
        EasyMock.reportMatcher(new GreaterOrEqual<Float>(Float.valueOf(f)));
        return 0.0f;
    }

    public static int geq(int n) {
        EasyMock.reportMatcher(new GreaterOrEqual<Integer>(Integer.valueOf(n)));
        return 0;
    }

    public static long geq(long l) {
        EasyMock.reportMatcher(new GreaterOrEqual<Long>(Long.valueOf(l)));
        return 0L;
    }

    public static short geq(short s) {
        EasyMock.reportMatcher(new GreaterOrEqual<Short>(Short.valueOf(s)));
        return 0;
    }

    public static <T extends Comparable<T>> T leq(Comparable<T> comparable) {
        EasyMock.reportMatcher(new LessOrEqual<T>(comparable));
        return null;
    }

    public static byte leq(byte by) {
        EasyMock.reportMatcher(new LessOrEqual<Byte>(Byte.valueOf(by)));
        return 0;
    }

    public static double leq(double d) {
        EasyMock.reportMatcher(new LessOrEqual<Double>(Double.valueOf(d)));
        return 0.0;
    }

    public static float leq(float f) {
        EasyMock.reportMatcher(new LessOrEqual<Float>(Float.valueOf(f)));
        return 0.0f;
    }

    public static int leq(int n) {
        EasyMock.reportMatcher(new LessOrEqual<Integer>(Integer.valueOf(n)));
        return 0;
    }

    public static long leq(long l) {
        EasyMock.reportMatcher(new LessOrEqual<Long>(Long.valueOf(l)));
        return 0L;
    }

    public static short leq(short s) {
        EasyMock.reportMatcher(new LessOrEqual<Short>(Short.valueOf(s)));
        return 0;
    }

    public static <T extends Comparable<T>> T gt(Comparable<T> comparable) {
        EasyMock.reportMatcher(new GreaterThan<T>(comparable));
        return null;
    }

    public static byte gt(byte by) {
        EasyMock.reportMatcher(new GreaterThan<Byte>(Byte.valueOf(by)));
        return 0;
    }

    public static double gt(double d) {
        EasyMock.reportMatcher(new GreaterThan<Double>(Double.valueOf(d)));
        return 0.0;
    }

    public static float gt(float f) {
        EasyMock.reportMatcher(new GreaterThan<Float>(Float.valueOf(f)));
        return 0.0f;
    }

    public static int gt(int n) {
        EasyMock.reportMatcher(new GreaterThan<Integer>(Integer.valueOf(n)));
        return 0;
    }

    public static long gt(long l) {
        EasyMock.reportMatcher(new GreaterThan<Long>(Long.valueOf(l)));
        return 0L;
    }

    public static short gt(short s) {
        EasyMock.reportMatcher(new GreaterThan<Short>(Short.valueOf(s)));
        return 0;
    }

    public static <T extends Comparable<T>> T lt(Comparable<T> comparable) {
        EasyMock.reportMatcher(new LessThan<T>(comparable));
        return null;
    }

    public static byte lt(byte by) {
        EasyMock.reportMatcher(new LessThan<Byte>(Byte.valueOf(by)));
        return 0;
    }

    public static double lt(double d) {
        EasyMock.reportMatcher(new LessThan<Double>(Double.valueOf(d)));
        return 0.0;
    }

    public static float lt(float f) {
        EasyMock.reportMatcher(new LessThan<Float>(Float.valueOf(f)));
        return 0.0f;
    }

    public static int lt(int n) {
        EasyMock.reportMatcher(new LessThan<Integer>(Integer.valueOf(n)));
        return 0;
    }

    public static long lt(long l) {
        EasyMock.reportMatcher(new LessThan<Long>(Long.valueOf(l)));
        return 0L;
    }

    public static short lt(short s) {
        EasyMock.reportMatcher(new LessThan<Short>(Short.valueOf(s)));
        return 0;
    }

    public static <T> T isA(Class<T> clazz) {
        EasyMock.reportMatcher(new InstanceOf(clazz));
        return null;
    }

    public static String contains(String string) {
        EasyMock.reportMatcher(new Contains(string));
        return null;
    }

    public static boolean and(boolean bl, boolean bl2) {
        LastControl.reportAnd(2);
        return false;
    }

    public static byte and(byte by, byte by2) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static char and(char c, char c2) {
        LastControl.reportAnd(2);
        return '\u0000';
    }

    public static double and(double d, double d2) {
        LastControl.reportAnd(2);
        return 0.0;
    }

    public static float and(float f, float f2) {
        LastControl.reportAnd(2);
        return 0.0f;
    }

    public static int and(int n, int n2) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static long and(long l, long l2) {
        LastControl.reportAnd(2);
        return 0L;
    }

    public static short and(short s, short s2) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static <T> T and(T t, T t2) {
        LastControl.reportAnd(2);
        return null;
    }

    public static boolean or(boolean bl, boolean bl2) {
        LastControl.reportOr(2);
        return false;
    }

    public static byte or(byte by, byte by2) {
        LastControl.reportOr(2);
        return 0;
    }

    public static char or(char c, char c2) {
        LastControl.reportOr(2);
        return '\u0000';
    }

    public static double or(double d, double d2) {
        LastControl.reportOr(2);
        return 0.0;
    }

    public static float or(float f, float f2) {
        LastControl.reportOr(2);
        return 0.0f;
    }

    public static int or(int n, int n2) {
        LastControl.reportOr(2);
        return n;
    }

    public static long or(long l, long l2) {
        LastControl.reportOr(2);
        return 0L;
    }

    public static short or(short s, short s2) {
        LastControl.reportOr(2);
        return 0;
    }

    public static <T> T or(T t, T t2) {
        LastControl.reportOr(2);
        return null;
    }

    public static boolean not(boolean bl) {
        LastControl.reportNot();
        return false;
    }

    public static byte not(byte by) {
        LastControl.reportNot();
        return 0;
    }

    public static char not(char c) {
        LastControl.reportNot();
        return '\u0000';
    }

    public static double not(double d) {
        LastControl.reportNot();
        return 0.0;
    }

    public static float not(float f) {
        LastControl.reportNot();
        return f;
    }

    public static int not(int n) {
        LastControl.reportNot();
        return 0;
    }

    public static long not(long l) {
        LastControl.reportNot();
        return 0L;
    }

    public static short not(short s) {
        LastControl.reportNot();
        return 0;
    }

    public static <T> T not(T t) {
        LastControl.reportNot();
        return null;
    }

    public static boolean eq(boolean bl) {
        EasyMock.reportMatcher(new Equals(bl));
        return false;
    }

    public static byte eq(byte by) {
        EasyMock.reportMatcher(new Equals(by));
        return 0;
    }

    public static char eq(char c) {
        EasyMock.reportMatcher(new Equals(Character.valueOf(c)));
        return '\u0000';
    }

    public static double eq(double d) {
        EasyMock.reportMatcher(new Equals(d));
        return 0.0;
    }

    public static float eq(float f) {
        EasyMock.reportMatcher(new Equals(Float.valueOf(f)));
        return 0.0f;
    }

    public static int eq(int n) {
        EasyMock.reportMatcher(new Equals(n));
        return 0;
    }

    public static long eq(long l) {
        EasyMock.reportMatcher(new Equals(l));
        return 0L;
    }

    public static short eq(short s) {
        EasyMock.reportMatcher(new Equals(s));
        return 0;
    }

    public static <T> T eq(T t) {
        EasyMock.reportMatcher(new Equals(t));
        return null;
    }

    public static boolean[] aryEq(boolean[] blArray) {
        EasyMock.reportMatcher(new ArrayEquals(blArray));
        return null;
    }

    public static byte[] aryEq(byte[] byArray) {
        EasyMock.reportMatcher(new ArrayEquals(byArray));
        return null;
    }

    public static char[] aryEq(char[] cArray) {
        EasyMock.reportMatcher(new ArrayEquals(cArray));
        return null;
    }

    public static double[] aryEq(double[] dArray) {
        EasyMock.reportMatcher(new ArrayEquals(dArray));
        return null;
    }

    public static float[] aryEq(float[] fArray) {
        EasyMock.reportMatcher(new ArrayEquals(fArray));
        return null;
    }

    public static int[] aryEq(int[] nArray) {
        EasyMock.reportMatcher(new ArrayEquals(nArray));
        return null;
    }

    public static long[] aryEq(long[] lArray) {
        EasyMock.reportMatcher(new ArrayEquals(lArray));
        return null;
    }

    public static short[] aryEq(short[] sArray) {
        EasyMock.reportMatcher(new ArrayEquals(sArray));
        return null;
    }

    public static <T> T[] aryEq(T[] TArray) {
        EasyMock.reportMatcher(new ArrayEquals(TArray));
        return null;
    }

    public static <T> T isNull() {
        EasyMock.reportMatcher(Null.NULL);
        return null;
    }

    public static <T> T isNull(Class<T> clazz) {
        EasyMock.reportMatcher(Null.NULL);
        return null;
    }

    public static <T> T notNull() {
        EasyMock.reportMatcher(NotNull.NOT_NULL);
        return null;
    }

    public static <T> T notNull(Class<T> clazz) {
        EasyMock.reportMatcher(NotNull.NOT_NULL);
        return null;
    }

    public static String find(String string) {
        EasyMock.reportMatcher(new Find(string));
        return null;
    }

    public static String matches(String string) {
        EasyMock.reportMatcher(new Matches(string));
        return null;
    }

    public static String startsWith(String string) {
        EasyMock.reportMatcher(new StartsWith(string));
        return null;
    }

    public static String endsWith(String string) {
        EasyMock.reportMatcher(new EndsWith(string));
        return null;
    }

    public static double eq(double d, double d2) {
        EasyMock.reportMatcher(new EqualsWithDelta(d, d2));
        return 0.0;
    }

    public static float eq(float f, float f2) {
        EasyMock.reportMatcher(new EqualsWithDelta(Float.valueOf(f), Float.valueOf(f2)));
        return 0.0f;
    }

    public static <T> T same(T t) {
        EasyMock.reportMatcher(new Same(t));
        return null;
    }

    public static <T extends Comparable<T>> T cmpEq(Comparable<T> comparable) {
        EasyMock.reportMatcher(new CompareEqual<T>(comparable));
        return null;
    }

    public static <T> T cmp(T t, Comparator<? super T> comparator, LogicalOperator logicalOperator) {
        EasyMock.reportMatcher(new Compare<T>(t, comparator, logicalOperator));
        return null;
    }

    public static <T> Capture<T> newCapture() {
        return Capture.newInstance();
    }

    public static <T> Capture<T> newCapture(CaptureType captureType) {
        return Capture.newInstance(captureType);
    }

    public static <T> T capture(Capture<T> capture) {
        EasyMock.reportMatcher(new Captures<T>(capture));
        return null;
    }

    public static boolean captureBoolean(Capture<Boolean> capture) {
        EasyMock.reportMatcher(new Captures<Boolean>(capture));
        return false;
    }

    public static int captureInt(Capture<Integer> capture) {
        EasyMock.reportMatcher(new Captures<Integer>(capture));
        return 0;
    }

    public static long captureLong(Capture<Long> capture) {
        EasyMock.reportMatcher(new Captures<Long>(capture));
        return 0L;
    }

    public static float captureFloat(Capture<Float> capture) {
        EasyMock.reportMatcher(new Captures<Float>(capture));
        return 0.0f;
    }

    public static double captureDouble(Capture<Double> capture) {
        EasyMock.reportMatcher(new Captures<Double>(capture));
        return 0.0;
    }

    public static byte captureByte(Capture<Byte> capture) {
        EasyMock.reportMatcher(new Captures<Byte>(capture));
        return 0;
    }

    public static char captureChar(Capture<Character> capture) {
        EasyMock.reportMatcher(new Captures<Character>(capture));
        return '\u0000';
    }

    public static void replay(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).replay();
        }
    }

    public static void reset(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).reset();
        }
    }

    public static void resetToNice(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).resetToNice();
        }
    }

    public static void resetToDefault(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).resetToDefault();
        }
    }

    public static void resetToStrict(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).resetToStrict();
        }
    }

    public static void verify(Object ... objectArray) {
        for (Object object : objectArray) {
            EasyMock.getControl(object).verify();
        }
    }

    public static void checkOrder(Object object, boolean bl) {
        EasyMock.getControl(object).checkOrder(bl);
    }

    public static void reportMatcher(IArgumentMatcher iArgumentMatcher) {
        LastControl.reportMatcher(iArgumentMatcher);
    }

    private static MocksControl getControl(Object object) {
        return MocksControl.getControl(object);
    }

    public static Object[] getCurrentArguments() {
        Invocation invocation = LastControl.getCurrentInvocation();
        if (invocation == null) {
            throw new IllegalStateException("current arguments are only available when executing callback methods");
        }
        return invocation.getArguments();
    }

    public static void makeThreadSafe(Object object, boolean bl) {
        EasyMock.getControl(object).makeThreadSafe(bl);
    }

    public static void checkIsUsedInOneThread(Object object, boolean bl) {
        EasyMock.getControl(object).checkIsUsedInOneThread(bl);
    }

    public static String getEasyMockProperty(String string) {
        return EasyMockProperties.getInstance().getProperty(string);
    }

    public static String setEasyMockProperty(String string, String string2) {
        return EasyMockProperties.getInstance().setProperty(string, string2);
    }

    protected EasyMock() {
    }
}

