/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.python.editor.lexer.PythonStringLexer;
import org.netbeans.modules.python.editor.lexer.PythonTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum PythonStringTokenId implements TokenId
{
    STRING_TEXT("string"),
    STRING_ESCAPE("string-escape"),
    STRING_INVALID("string-escape-invalid"),
    URL("url"),
    EMBEDDED_PYTHON("string");

    private final String primaryCategory;
    public static final Language<PythonStringTokenId> language;

    private PythonStringTokenId() {
        this(null);
    }

    private PythonStringTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<PythonStringTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<PythonStringTokenId>(){

            protected Collection<PythonStringTokenId> createTokenIds() {
                return EnumSet.allOf(PythonStringTokenId.class);
            }

            protected Map<String, Collection<PythonStringTokenId>> createTokenCategories() {
                return null;
            }

            protected Lexer<PythonStringTokenId> createLexer(LexerRestartInfo<PythonStringTokenId> info) {
                return new PythonStringLexer(info, true);
            }

            protected LanguageEmbedding<?> embedding(Token<PythonStringTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                PythonStringTokenId id = (PythonStringTokenId)token.id();
                if (id == EMBEDDED_PYTHON && token.text() != null) {
                    return LanguageEmbedding.create(PythonTokenId.language(), (int)3, (int)0);
                }
                return null;
            }

            public String mimeType() {
                return "text/x-python-string";
            }
        }.language();
    }
}

