/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.python.editor.lexer.PythonTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public final class PythonLexer
implements Lexer<PythonTokenId> {
    public static final String COMMENT_CAT = "comment";
    public static final String KEYWORD_CAT = "keyword";
    public static final String STRING_CAT = "string";
    public static final String WHITESPACE_CAT = "whitespace";
    public static final String OPERATOR_CAT = "operator";
    public static final String SEPARATOR_CAT = "separator";
    public static final String ERROR_CAT = "error";
    public static final String NUMBER_CAT = "number";
    public static final String IDENTIFIER_CAT = "identifier";
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<PythonTokenId> tokenFactory;
    private State state;

    public PythonLexer(LexerRestartInfo<PythonTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.state = (State)((Object)info.state());
        if (this.state == null) {
            this.state = State.INIT;
        }
    }

    public Object state() {
        return this.state;
    }

    private Token<PythonTokenId> createToken(PythonTokenId id, int tokenLength) {
        String fixedText = id.fixedText();
        return fixedText != null ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : this.tokenFactory.createToken((TokenId)id, tokenLength);
    }

    public Token<PythonTokenId> nextToken() {
        switch (this.state) {
            case INIT: {
                int ch = this.input.read();
                switch (ch) {
                    case -1: {
                        return null;
                    }
                    case 10: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.NEWLINE, 1);
                    }
                    case 9: 
                    case 32: {
                        while (ch != -1 && (ch == 32 || ch == 9)) {
                            ch = this.input.read();
                        }
                        this.input.backup(1);
                        return this.createToken(PythonTokenId.WHITESPACE, this.input.readLength());
                    }
                    case 35: {
                        ch = this.input.read();
                        while (ch != -1 && ch != 10) {
                            ch = this.input.read();
                        }
                        this.input.backup(1);
                        return this.createToken(PythonTokenId.COMMENT, this.input.readLength());
                    }
                    case 46: {
                        assert (this.input.readLength() == 1);
                        int peek = this.input.read();
                        this.input.backup(1);
                        if (!Character.isDigit(peek)) {
                            return this.createToken(PythonTokenId.DOT, 1);
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int peek;
                        if (ch == 48) {
                            peek = this.input.read();
                            if (peek == 120 || peek == 88) {
                                ch = this.input.read();
                                while (ch != -1 && (Character.isDigit(ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70)) {
                                    ch = this.input.read();
                                }
                                if (ch != 108 && ch != 76) {
                                    this.input.backup(1);
                                }
                                return this.createToken(PythonTokenId.INT_LITERAL, this.input.readLength());
                            }
                            this.input.backup(1);
                        }
                        boolean isFloat = false;
                        block51: while (ch != -1) {
                            switch (ch) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break;
                                }
                                case 46: {
                                    isFloat = true;
                                    break;
                                }
                                case 69: 
                                case 101: {
                                    int peek2 = this.input.read();
                                    if (peek2 != 43 && peek2 != 45) {
                                        this.input.backup(1);
                                    }
                                    ch = this.input.read();
                                    while (ch != -1 && Character.isDigit(ch)) {
                                        ch = this.input.read();
                                    }
                                    if (ch != 106 && ch != 74) {
                                        this.input.backup(1);
                                    }
                                    return this.createToken(PythonTokenId.FLOAT_LITERAL, this.input.readLength());
                                }
                                case 74: 
                                case 106: {
                                    isFloat = true;
                                    break block51;
                                }
                                case 76: 
                                case 108: {
                                    break block51;
                                }
                                default: {
                                    this.input.backup(1);
                                    break block51;
                                }
                            }
                            ch = this.input.read();
                        }
                        return this.createToken(isFloat ? PythonTokenId.FLOAT_LITERAL : PythonTokenId.INT_LITERAL, this.input.readLength());
                    }
                    case 43: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 45: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 42: {
                        int peek = this.input.read();
                        if (peek != 61) {
                            if (peek == 42) {
                                peek = this.input.read();
                                if (peek != 61) {
                                    this.input.backup(1);
                                }
                            } else {
                                this.input.backup(1);
                            }
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 47: {
                        int peek = this.input.read();
                        if (peek != 61) {
                            if (peek == 47) {
                                peek = this.input.read();
                                if (peek != 61) {
                                    this.input.backup(1);
                                }
                            } else {
                                this.input.backup(1);
                            }
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 37: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 60: {
                        int peek = this.input.read();
                        if (peek != 61) {
                            if (peek == 60) {
                                peek = this.input.read();
                                if (peek != 61) {
                                    this.input.backup(1);
                                }
                            } else if (peek != 62) {
                                this.input.backup(1);
                            }
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 62: {
                        int peek = this.input.read();
                        if (peek != 61) {
                            if (peek == 62) {
                                peek = this.input.read();
                                if (peek != 61) {
                                    this.input.backup(1);
                                }
                            } else {
                                this.input.backup(1);
                            }
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 38: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 124: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 94: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 61: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 33: {
                        if (this.input.read() != 61) {
                            this.input.backup(1);
                        }
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 59: 
                    case 96: 
                    case 126: {
                        return this.createToken(PythonTokenId.ANY_OPERATOR, this.input.readLength());
                    }
                    case 58: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.COLON, 1);
                    }
                    case 40: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.LPAREN, 1);
                    }
                    case 41: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.RPAREN, 1);
                    }
                    case 91: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.LBRACKET, 1);
                    }
                    case 93: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.RBRACKET, 1);
                    }
                    case 123: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.LBRACE, 1);
                    }
                    case 125: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.RBRACE, 1);
                    }
                    case 44: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.COMMA, 1);
                    }
                    case 92: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.ESC, 1);
                    }
                    case 36: 
                    case 63: {
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.ERROR, 1);
                    }
                    case 34: 
                    case 39: {
                        int peek = this.input.read();
                        if (peek != ch) {
                            this.input.backup(1);
                            assert (this.input.readLength() == 1);
                            this.state = ch == 34 ? State.BEGIN_SHORTSTRING_DOUBLE : State.BEGIN_SHORTSTRING_SINGLE;
                            return this.createToken(PythonTokenId.STRING_BEGIN, 1);
                        }
                        int peek2 = this.input.read();
                        if (peek2 == peek) {
                            assert (this.input.readLength() == 3);
                            this.state = ch == 34 ? State.BEGIN_LONGSTRING_DOUBLE : State.BEGIN_LONGSTRING_SINGLE;
                            return this.createToken(PythonTokenId.STRING_BEGIN, 3);
                        }
                        this.input.backup(2);
                        assert (this.input.readLength() == 1);
                        this.state = ch == 34 ? State.BEGIN_SHORTSTRING_DOUBLE : State.BEGIN_SHORTSTRING_SINGLE;
                        return this.createToken(PythonTokenId.STRING_BEGIN, 1);
                    }
                    case 64: {
                        ch = this.input.read();
                        if (Character.isJavaIdentifierStart(ch)) {
                            while (ch != -1 && Character.isJavaIdentifierPart(ch) && ch != 36) {
                                ch = this.input.read();
                            }
                            this.input.backup(1);
                            return this.createToken(PythonTokenId.DECORATOR, this.input.readLength());
                        }
                        this.input.backup(1);
                        assert (this.input.readLength() == 1);
                        return this.createToken(PythonTokenId.DECORATOR, 1);
                    }
                    case 82: 
                    case 85: 
                    case 114: 
                    case 117: {
                        int peek2;
                        boolean isStringPrefix = false;
                        int peek = this.input.read();
                        if (ch == 114 || ch == 82) {
                            if (peek == 39 || peek == 34) {
                                isStringPrefix = true;
                            }
                            this.input.backup(1);
                        } else {
                            assert (ch == 117 || ch == 85);
                            if (peek == 114 || peek == 82) {
                                peek2 = this.input.read();
                                if (peek2 == 39 || peek2 == 34) {
                                    isStringPrefix = true;
                                }
                                this.input.backup(1);
                            } else if (peek == 39 || peek == 34) {
                                isStringPrefix = true;
                                this.input.backup(1);
                            }
                            if (!isStringPrefix) {
                                this.input.backup(1);
                            }
                        }
                        if (!isStringPrefix) break;
                        ch = this.input.read();
                        assert (ch == 39 || ch == 34);
                        peek = this.input.read();
                        if (peek != ch) {
                            this.input.backup(1);
                            this.state = ch == 34 ? State.BEGIN_SHORTSTRING_DOUBLE : State.BEGIN_SHORTSTRING_SINGLE;
                            return this.createToken(PythonTokenId.STRING_BEGIN, this.input.readLength());
                        }
                        peek2 = this.input.read();
                        if (peek2 == peek) {
                            this.state = ch == 34 ? State.BEGIN_LONGSTRING_DOUBLE : State.BEGIN_LONGSTRING_SINGLE;
                            return this.createToken(PythonTokenId.STRING_BEGIN, this.input.readLength());
                        }
                        this.input.backup(2);
                        this.state = ch == 34 ? State.BEGIN_SHORTSTRING_DOUBLE : State.BEGIN_SHORTSTRING_SINGLE;
                        return this.createToken(PythonTokenId.STRING_BEGIN, this.input.readLength());
                    }
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    while (ch != -1 && Character.isJavaIdentifierPart(ch) && ch != 36) {
                        ch = this.input.read();
                    }
                    this.input.backup(1);
                    PythonTokenId pid = this.getKeywordToken(this.input.readText());
                    if (pid != null) {
                        return this.createToken(pid, this.input.readLength());
                    }
                    return this.createToken(PythonTokenId.IDENTIFIER, this.input.readLength());
                }
                assert (this.input.readLength() == 1);
                return this.createToken(PythonTokenId.ANY_OPERATOR, 1);
            }
            case BEGIN_LONGSTRING_SINGLE: 
            case BEGIN_LONGSTRING_DOUBLE: {
                int term;
                int ch = this.input.read();
                if (ch == -1) {
                    return null;
                }
                int n = term = this.state == State.BEGIN_LONGSTRING_DOUBLE ? 34 : 39;
                while (ch != -1) {
                    if (ch == 92) {
                        this.input.read();
                    } else if (ch == term) {
                        int peek = this.input.read();
                        if (peek == term) {
                            int peek2 = this.input.read();
                            if (peek2 == term) {
                                if (this.input.readLength() == 3) {
                                    this.state = State.INIT;
                                    return this.createToken(PythonTokenId.STRING_END, this.input.readLength());
                                }
                                this.input.backup(3);
                                if (this.state == State.BEGIN_LONGSTRING_DOUBLE) {
                                    this.state = State.END_LONGSTRING_DOUBLE;
                                } else {
                                    assert (this.state == State.BEGIN_LONGSTRING_SINGLE);
                                    this.state = State.END_LONGSTRING_SINGLE;
                                }
                                return this.createToken(PythonTokenId.STRING_LITERAL, this.input.readLength());
                            }
                            this.input.backup(1);
                        }
                        this.input.backup(1);
                    }
                    ch = this.input.read();
                }
                this.state = State.INIT;
                return this.createToken(PythonTokenId.ERROR, this.input.readLength());
            }
            case BEGIN_SHORTSTRING_SINGLE: 
            case BEGIN_SHORTSTRING_DOUBLE: {
                int term;
                int ch = this.input.read();
                if (ch == -1) {
                    return null;
                }
                int n = term = this.state == State.BEGIN_SHORTSTRING_DOUBLE ? 34 : 39;
                while (ch != -1) {
                    if (ch == 92) {
                        this.input.read();
                    } else {
                        if (ch == 10) {
                            this.state = State.INIT;
                            return this.createToken(PythonTokenId.ERROR, this.input.readLength());
                        }
                        if (ch == term) {
                            if (this.input.readLength() == 1) {
                                this.state = State.INIT;
                                return this.createToken(PythonTokenId.STRING_END, this.input.readLength());
                            }
                            this.input.backup(1);
                            if (this.state == State.BEGIN_SHORTSTRING_DOUBLE) {
                                this.state = State.END_SHORTSTRING_DOUBLE;
                            } else {
                                assert (this.state == State.BEGIN_SHORTSTRING_SINGLE);
                                this.state = State.END_SHORTSTRING_SINGLE;
                            }
                            return this.createToken(PythonTokenId.STRING_LITERAL, this.input.readLength());
                        }
                    }
                    ch = this.input.read();
                }
                this.state = State.INIT;
                return this.createToken(PythonTokenId.ERROR, this.input.readLength());
            }
            case END_LONGSTRING_SINGLE: 
            case END_LONGSTRING_DOUBLE: {
                int term;
                int ch = this.input.read();
                if (ch == -1) {
                    return null;
                }
                int n = term = this.state == State.END_LONGSTRING_DOUBLE ? 34 : 39;
                while (ch != -1) {
                    if (ch == term) {
                        int peek = this.input.read();
                        if (peek == term) {
                            int peek2 = this.input.read();
                            if (peek2 == term) {
                                this.state = State.INIT;
                                return this.createToken(PythonTokenId.STRING_END, this.input.readLength());
                            }
                            this.input.backup(1);
                        }
                        this.input.backup(1);
                    }
                    ch = this.input.read();
                }
                this.state = State.INIT;
                return this.createToken(PythonTokenId.ERROR, this.input.readLength());
            }
            case END_SHORTSTRING_SINGLE: 
            case END_SHORTSTRING_DOUBLE: {
                int term;
                int ch = this.input.read();
                if (ch == -1) {
                    return null;
                }
                int n = term = this.state == State.END_SHORTSTRING_DOUBLE ? 34 : 39;
                if (ch == term) {
                    this.state = State.INIT;
                    return this.createToken(PythonTokenId.STRING_END, this.input.readLength());
                }
                this.state = State.INIT;
                return this.createToken(PythonTokenId.ERROR, this.input.readLength());
            }
        }
        assert (false) : this.state;
        return null;
    }

    public void release() {
    }

    private PythonTokenId getKeywordToken(CharSequence s) {
        int length = s.length();
        if (length < 2) {
            return null;
        }
        char c1 = s.charAt(0);
        char c2 = s.charAt(1);
        switch (c1) {
            case 'a': {
                switch (c2) {
                    case 'n': {
                        if (!TokenUtilities.textEquals((CharSequence)s, (CharSequence)"and")) break;
                        return PythonTokenId.ANY_KEYWORD;
                    }
                    case 's': {
                        if (length == 2) {
                            return PythonTokenId.ANY_KEYWORD;
                        }
                        if (length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"assert")) break;
                        return PythonTokenId.ANY_KEYWORD;
                    }
                }
                break;
            }
            case 'b': {
                if (length != 5 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"break")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'c': {
                switch (c2) {
                    case 'l': {
                        if (length != 5 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"class")) break;
                        return PythonTokenId.CLASS;
                    }
                    case 'o': {
                        if (length != 8 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"continue")) break;
                        return PythonTokenId.ANY_KEYWORD;
                    }
                }
                break;
            }
            case 'd': {
                if (c2 != 'e' || length != 3) break;
                char c3 = s.charAt(2);
                if (c3 == 'f') {
                    return PythonTokenId.DEF;
                }
                if (c3 != 'l') break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'e': {
                switch (c2) {
                    case 'l': {
                        if (length != 4) break;
                        if (TokenUtilities.textEquals((CharSequence)s, (CharSequence)"elif")) {
                            return PythonTokenId.ELIF;
                        }
                        if (!TokenUtilities.textEquals((CharSequence)s, (CharSequence)"else")) break;
                        return PythonTokenId.ELSE;
                    }
                    case 'x': {
                        if (length == 4 && TokenUtilities.textEquals((CharSequence)s, (CharSequence)"exec")) {
                            return PythonTokenId.ANY_KEYWORD;
                        }
                        if (length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"except")) break;
                        return PythonTokenId.EXCEPT;
                    }
                }
                break;
            }
            case 'f': {
                switch (c2) {
                    case 'i': {
                        if (length != 7 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"finally")) break;
                        return PythonTokenId.FINALLY;
                    }
                    case 'o': {
                        if (length != 3 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"for")) break;
                        return PythonTokenId.ANY_KEYWORD;
                    }
                    case 'r': {
                        if (length != 4 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"from")) break;
                        return PythonTokenId.FROM;
                    }
                }
                break;
            }
            case 'g': {
                if (length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"global")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'i': {
                if (length == 2) {
                    switch (c2) {
                        case 'f': {
                            return PythonTokenId.IF;
                        }
                        case 'n': {
                            return PythonTokenId.ANY_KEYWORD;
                        }
                        case 's': {
                            return PythonTokenId.ANY_KEYWORD;
                        }
                    }
                    break;
                }
                if (c2 != 'm' || length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"import")) break;
                return PythonTokenId.IMPORT;
            }
            case 'l': {
                if (length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"lambda")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'n': {
                if (length != 3 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"not")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'o': {
                if (length != 2 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"or")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'p': {
                if (c2 == 'a') {
                    if (length != 4 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"pass")) break;
                    return PythonTokenId.PASS;
                }
                if (c2 != 'r' || length != 5 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"print")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'r': {
                if (c2 == 'a') {
                    if (length != 5 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"raise")) break;
                    return PythonTokenId.RAISE;
                }
                if (c2 != 'e' || length != 6 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"return")) break;
                return PythonTokenId.RETURN;
            }
            case 't': {
                if (length != 3 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"try")) break;
                return PythonTokenId.TRY;
            }
            case 'w': {
                if (!(c2 == 'h' ? length == 5 && TokenUtilities.textEquals((CharSequence)s, (CharSequence)"while") : c2 == 'i' && length == 4 && TokenUtilities.textEquals((CharSequence)s, (CharSequence)"with"))) break;
                return PythonTokenId.ANY_KEYWORD;
            }
            case 'y': {
                if (length != 5 || !TokenUtilities.textEquals((CharSequence)s, (CharSequence)"yield")) break;
                return PythonTokenId.ANY_KEYWORD;
            }
        }
        return null;
    }

    private static enum State {
        INIT,
        BEGIN_SHORTSTRING_DOUBLE,
        BEGIN_SHORTSTRING_SINGLE,
        BEGIN_LONGSTRING_DOUBLE,
        BEGIN_LONGSTRING_SINGLE,
        END_SHORTSTRING_DOUBLE,
        END_SHORTSTRING_SINGLE,
        END_LONGSTRING_DOUBLE,
        END_LONGSTRING_SINGLE;

    }
}

