/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.ui;

import blue.score.TimeState;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.patterns.core.PatternData;
import blue.score.layers.patterns.core.PatternLayer;
import blue.score.layers.patterns.core.PatternsLayerGroup;
import blue.score.layers.patterns.ui.PatternsLayerPanelMouseListener;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.layers.SelectionMarquee;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JPanel;

public class PatternsLayerPanel
extends JPanel
implements LayerGroupListener,
PropertyChangeListener,
LayerGroupPanel<PatternsLayerGroup> {
    private static final Color PATTERN_COLOR = new Color(198, 226, 255);
    private PatternsLayerGroup layerGroup;
    private final TimeState timeState;

    public PatternsLayerPanel(PatternsLayerGroup layerGroup, TimeState timeState) {
        this.layerGroup = layerGroup;
        this.timeState = timeState;
        layerGroup.addLayerGroupListener((LayerGroupListener)this);
        timeState.addPropertyChangeListener((PropertyChangeListener)this);
        Dimension d = this.checkSize();
        this.setSize(d);
        this.setBackground(Color.BLACK);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                mwe.getComponent().getParent().dispatchEvent(mwe);
            }
        });
        PatternsLayerPanelMouseListener listener = new PatternsLayerPanelMouseListener(this, layerGroup, timeState);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.layerGroup.removeLayerGroupListener((LayerGroupListener)this);
        this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        this.checkSize();
        this.repaint();
    }

    protected Dimension checkSize() {
        int w = (this.layerGroup.getMaxPattern() + 16) * this.layerGroup.getPatternBeatsLength() * this.timeState.getPixelSecond();
        int h = this.layerGroup.size() * 22;
        Dimension d = new Dimension(w, h);
        this.setPreferredSize(d);
        return d;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.timeState && evt.getPropertyName().equals("pixelSecond")) {
            this.checkSize();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int y;
        int i;
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            bounds = this.getBounds();
        }
        g.setColor(Color.BLACK);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        int width = this.getWidth();
        int height = this.getHeight();
        int bottom = height - 1;
        int maxX = (int)bounds.getMaxX();
        int maxY = (int)bounds.getMaxY();
        int x = 0;
        int pixelSecond = this.timeState.getPixelSecond();
        int patternBeatsLength = this.layerGroup.getPatternBeatsLength();
        int patternWidth = patternBeatsLength * pixelSecond;
        int startLayerIndex = bounds.y / 22;
        int startPatternIndex = (int)((float)bounds.x / (float)(patternBeatsLength * pixelSecond));
        g.setColor(Color.DARK_GRAY);
        for (i = startLayerIndex; i < this.layerGroup.size() && (y = i * 22) <= maxY; ++i) {
            PatternLayer layer = (PatternLayer)this.layerGroup.get(i);
            PatternData data = layer.getPatternData();
            g.setColor(PATTERN_COLOR);
            x = startPatternIndex * patternBeatsLength * pixelSecond;
            int j = startPatternIndex;
            while (x < maxX) {
                x = j * patternBeatsLength * pixelSecond;
                if (data.isPatternSet(j)) {
                    g.fillRect(x, y, patternWidth, 22);
                }
                ++j;
            }
            g.setColor(Color.DARK_GRAY);
            g.drawLine(bounds.x, y, maxX, y);
        }
        g.setColor(Color.DARK_GRAY);
        if (bottom < maxY) {
            g.drawLine(bounds.x, bottom, maxX, bottom);
        }
        x = startPatternIndex * patternBeatsLength * pixelSecond;
        i = startPatternIndex;
        while (x < maxX) {
            x = i * patternBeatsLength * pixelSecond;
            g.drawLine(x, bounds.y, x, maxY);
            ++i;
        }
    }

    public void marqueeSelectionPerformed(SelectionMarquee marquee) {
    }

    public void paintNavigatorView(Graphics2D g2d) {
        int pixelSecond = this.timeState.getPixelSecond();
        int patternBeatsLength = this.layerGroup.getPatternBeatsLength();
        int patternWidth = patternBeatsLength * pixelSecond;
        for (int i = 0; i < this.layerGroup.size(); ++i) {
            int y = i * 22;
            int x = 0;
            PatternLayer layer = (PatternLayer)this.layerGroup.get(i);
            PatternData data = layer.getPatternData();
            g2d.setColor(PATTERN_COLOR);
            int j = 0;
            while ((double)x < this.getBounds().getMaxX()) {
                x = j * patternBeatsLength * pixelSecond;
                if (data.isPatternSet(j)) {
                    g2d.fillRect(x, y, patternWidth, 22);
                }
                ++j;
            }
        }
    }

    public ScoreObjectView getScoreObjectViewAtPoint(Point p) {
        return null;
    }

    public Action[] getLayerActions() {
        throw new UnsupportedOperationException("Error: getLayerActions should not be called for PatternsLayerPanel");
    }

    public PatternsLayerGroup getLayerGroup() {
        return this.layerGroup;
    }
}

