/*
 * Decompiled with CFR 0.152.
 */
package skt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public class SwingUtil {
    public static void installActions(JComponent comp, Action[] actions, int condition) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(condition);
        for (int i = 0; i < actions.length; ++i) {
            String name = (String)actions[i].getValue("Name");
            actionMap.put(name, actions[i]);
            inputMap.put((KeyStroke)actions[i].getValue("AcceleratorKey"), name);
        }
    }

    public static void installActions(JComponent comp, Action[] actions) {
        SwingUtil.installActions(comp, actions, 0);
    }

    public static boolean canHScroll(JViewport viewport) {
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        Rectangle availR = scrollPane.getBounds();
        Component view = viewport.getView();
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = viewport.toViewCoordinates(availR.getSize());
        boolean canHScroll = true;
        if (view instanceof Scrollable) {
            boolean bl = canHScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
        }
        if (canHScroll && viewPrefSize.width <= extentSize.width) {
            canHScroll = false;
        }
        return canHScroll;
    }

    public static boolean canVScroll(JViewport viewport) {
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        Rectangle availR = scrollPane.getBounds();
        Component view = viewport.getView();
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = viewport.toViewCoordinates(availR.getSize());
        boolean canVScroll = true;
        if (view instanceof Scrollable) {
            boolean bl = canVScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
        }
        if (canVScroll && viewPrefSize.height <= extentSize.height) {
            canVScroll = false;
        }
        return canVScroll;
    }

    public static boolean canScroll(JViewport viewport) {
        return SwingUtil.canHScroll(viewport) || SwingUtil.canVScroll(viewport);
    }
}

