/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.gui.DragManager;
import blue.udo.UDOCategory;
import blue.udo.UDOLibrary;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.TransferableUDO;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class UDOTreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    JTree sourceTree;
    TransferableUDO transferable;
    Object oldNode;

    public UDOTreeDragSource(JTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        if (path.getLastPathComponent() instanceof UserDefinedOpcode || path.getLastPathComponent() instanceof UDOCategory) {
            this.oldNode = path.getLastPathComponent();
            Object cloneNode = this.oldNode instanceof UserDefinedOpcode ? new UserDefinedOpcode((UserDefinedOpcode)this.oldNode) : new UDOCategory((UDOCategory)this.oldNode);
            this.transferable = new TransferableUDO(cloneNode);
            this.source.startDrag(dge, null, this.transferable, this);
            DragManager.setDragSource(this.sourceTree);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2) {
            if (this.oldNode instanceof UserDefinedOpcode) {
                ((UDOLibrary)this.sourceTree.getModel()).removeUDO((UserDefinedOpcode)this.oldNode);
            } else if (this.oldNode instanceof UDOCategory) {
                ((UDOLibrary)this.sourceTree.getModel()).removeCategory((UDOCategory)this.oldNode);
            }
        }
        this.oldNode = null;
        DragManager.setDragSource(null);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }
}

