/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundFile;

import blue.BlueSystem;
import blue.ui.utilities.FileChooserManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javafx.stage.FileChooser;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class AudioFilePlayer
extends JPanel {
    File soundFile = null;
    SoundFilePlayerRunnable audioFilePlayer = null;
    float timeDivisor = -1.0f;
    String duration = "00:00:00";
    String currentTime = "00:00:00";
    private JProgressBar durationSlider;
    private JLabel fileNameLabel;
    private JTextField fileNameText;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JButton playStopButton;
    private JButton selectFileButton;
    private JComboBox soundOutOptions;
    private JLabel timeDisplay;

    public AudioFilePlayer() {
        this.initComponents();
        this.setSoundFile(null);
    }

    public void setSoundFile(File soundFile) {
        File oldSoundFile = this.soundFile;
        this.soundFile = soundFile;
        boolean isAudioFile = true;
        AudioFileFormat aFormat = null;
        AudioFormat format = null;
        try {
            aFormat = AudioSystem.getAudioFileFormat(soundFile);
            format = aFormat.getFormat();
        }
        catch (IOException | NullPointerException | UnsupportedAudioFileException e) {
            isAudioFile = false;
            this.timeDivisor = -1.0f;
        }
        this.stop();
        if (this.soundFile == null || !isAudioFile) {
            this.fileNameText.setText("");
            this.playStopButton.setEnabled(false);
            this.playStopButton.setText(BlueSystem.getString((String)"soundfile.player.noFileSelected"));
        } else {
            this.fileNameText.setText(soundFile.getAbsolutePath());
            this.playStopButton.setEnabled(true);
            this.playStopButton.setText(BlueSystem.getString((String)"soundfile.player.playStop"));
            this.timeDivisor = format.getSampleRate() * (float)(format.getSampleSizeInBits() / 8) * (float)format.getChannels();
            this.currentTime = "00:00:00";
            this.duration = this.getTimeString(aFormat.getByteLength());
            this.timeDisplay.setText(this.currentTime + "/" + this.duration);
        }
        this.firePropertyChange("soundFile", oldSoundFile, this.soundFile);
    }

    public void stop() {
        if (this.audioFilePlayer != null && this.audioFilePlayer.isAlive()) {
            this.audioFilePlayer.interrupt();
            this.audioFilePlayer.stopPlaying();
            this.audioFilePlayer = null;
        }
    }

    public void forcePlay() {
        if (this.soundFile != null) {
            if (this.audioFilePlayer == null) {
                this.audioFilePlayer = new SoundFilePlayerRunnable(this.soundFile, (Mixer.Info)this.soundOutOptions.getSelectedItem(), this.durationSlider);
                this.audioFilePlayer.start();
            } else if (this.audioFilePlayer.isAlive()) {
                this.audioFilePlayer.interrupt();
                this.audioFilePlayer.stopPlaying();
                this.audioFilePlayer = new SoundFilePlayerRunnable(this.soundFile, (Mixer.Info)this.soundOutOptions.getSelectedItem(), this.durationSlider);
                this.audioFilePlayer.start();
            } else {
                this.audioFilePlayer = new SoundFilePlayerRunnable(this.soundFile, (Mixer.Info)this.soundOutOptions.getSelectedItem(), this.durationSlider);
                this.audioFilePlayer.start();
            }
        }
    }

    protected void updateCurrentTime(int byteLength) {
        String t = this.getTimeString(byteLength);
        this.timeDisplay.setText(t + "/" + this.duration);
    }

    private String getTimeString(int byteLength) {
        if (this.timeDivisor <= 0.0f) {
            return "00:00:00";
        }
        float duration = (float)byteLength / this.timeDivisor;
        int hours = (int)duration / 3600;
        int minutes = (int)(duration -= (float)(hours * 3600)) / 60;
        String h = Integer.toString(hours);
        String m = Integer.toString(minutes);
        String s = Float.toString(duration -= (float)(minutes * 60));
        if (hours < 10) {
            h = "0" + h;
        }
        if (minutes < 10) {
            m = "0" + m;
        }
        if (duration < 10.0f) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s.substring(0, 2);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.playStopButton = new JButton();
        this.timeDisplay = new JLabel();
        this.durationSlider = new JProgressBar();
        this.fileNameLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.soundOutOptions = new JComboBox();
        this.fileNameText = new JTextField();
        this.selectFileButton = new JButton();
        this.jLabel3.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.jLabel3.text"));
        this.playStopButton.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.playStopButton.text"));
        this.playStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioFilePlayer.this.playStopButtonActionPerformed(evt);
            }
        });
        this.timeDisplay.setHorizontalAlignment(11);
        this.timeDisplay.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.timeDisplay.text"));
        this.fileNameLabel.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.fileNameLabel.text"));
        this.jLabel1.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.jLabel1.text"));
        this.soundOutOptions.setModel(new DefaultComboBoxModel<Mixer.Info>(AudioSystem.getMixerInfo()));
        this.fileNameText.setEditable(false);
        this.fileNameText.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.fileNameText.text"));
        this.selectFileButton.setText(NbBundle.getMessage(AudioFilePlayer.class, (String)"AudioFilePlayer.selectFileButton.text"));
        this.selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioFilePlayer.this.selectFileButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeDisplay, GroupLayout.Alignment.TRAILING, -1, 353, Short.MAX_VALUE).addComponent(this.durationSlider, GroupLayout.Alignment.TRAILING, -1, 353, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fileNameText, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectFileButton)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.soundOutOptions, 0, 354, Short.MAX_VALUE).addComponent(this.playStopButton, -1, 354, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.fileNameLabel, -1, 415, Short.MAX_VALUE).addContainerGap())));
        layout.linkSize(0, this.jLabel1, this.jLabel3);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fileNameText, -2, -1, -2).addComponent(this.selectFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.durationSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeDisplay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.soundOutOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playStopButton).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(97, 97, 97).addComponent(this.fileNameLabel).addContainerGap(91, Short.MAX_VALUE))));
    }

    private void playStopButtonActionPerformed(ActionEvent evt) {
        if (this.soundFile != null) {
            if (this.audioFilePlayer == null) {
                this.audioFilePlayer = new SoundFilePlayerRunnable(this.soundFile, (Mixer.Info)this.soundOutOptions.getSelectedItem(), this.durationSlider);
                this.audioFilePlayer.start();
            } else if (this.audioFilePlayer.isAlive()) {
                this.audioFilePlayer.interrupt();
                this.audioFilePlayer.stopPlaying();
                this.audioFilePlayer = null;
            } else {
                this.audioFilePlayer = new SoundFilePlayerRunnable(this.soundFile, (Mixer.Info)this.soundOutOptions.getSelectedItem(), this.durationSlider);
                this.audioFilePlayer.start();
            }
        }
    }

    private void selectFileButtonActionPerformed(ActionEvent evt) {
        List rValue = FileChooserManager.getDefault().showOpenDialog(this.getClass(), null);
        if (!rValue.isEmpty()) {
            File f = (File)rValue.get(0);
            this.setSoundFile(f);
        }
    }

    static {
        FileChooserManager.getDefault().addFilter(AudioFilePlayer.class, new FileChooser.ExtensionFilter("AIFF file (.aif, aiff)", new String[]{"*.aif", "*.aiff"}));
        FileChooserManager.getDefault().addFilter(AudioFilePlayer.class, new FileChooser.ExtensionFilter("WAV file (.wav)", new String[]{"*.wav"}));
    }

    class SoundFilePlayerRunnable
    extends Thread {
        File soundFile;
        Mixer.Info mixer;
        JProgressBar slider;
        boolean stopPlaying;

        public SoundFilePlayerRunnable(File soundFile, Mixer.Info mixer, JProgressBar slider) {
            this.soundFile = soundFile;
            this.mixer = mixer;
            this.slider = slider;
        }

        public void stopPlaying() {
            this.stopPlaying = true;
        }

        @Override
        public void run() {
            this.playAudioFile(this.soundFile);
        }

        public void playAudioFile(File soundFile) {
            int bufferSize = 40960;
            try {
                AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
                AudioInputStream ain = AudioSystem.getAudioInputStream(soundFile);
                AudioFormat format = aFormat.getFormat();
                DataLine.Info targetInfo = new DataLine.Info(SourceDataLine.class, format, 40960);
                if (!AudioSystem.isLineSupported(targetInfo)) {
                    JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.player.error.lineUnsupported"));
                    return;
                }
                try (SourceDataLine b = (SourceDataLine)AudioSystem.getLine(targetInfo);){
                    int read;
                    byte[] buffer = new byte[bufferSize];
                    b.open(format, bufferSize);
                    b.start();
                    this.slider.setMinimum(0);
                    this.slider.setMaximum(aFormat.getByteLength());
                    this.slider.setValue(0);
                    while ((read = ain.read(buffer)) != -1 && !this.stopPlaying) {
                        b.write(buffer, 0, read);
                        int bytesRead = this.slider.getValue() + read;
                        this.slider.setValue(bytesRead);
                        AudioFilePlayer.this.updateCurrentTime(bytesRead);
                    }
                    if (!this.stopPlaying) {
                        b.drain();
                    }
                    b.stop();
                }
            }
            catch (IllegalArgumentException | LineUnavailableException iae) {
                JOptionPane.showMessageDialog(null, iae.getLocalizedMessage());
            }
            catch (FileNotFoundException fe) {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"message.file.notFound"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.slider.setValue(0);
        }
    }
}

