/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public final class DuplicateScoreObjectsAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<? extends ScoreObject> scoreObjects = ScoreController.getInstance().getSelectedScoreObjects();
        if (!scoreObjects.isEmpty()) {
            ScorePath path = ScoreController.getInstance().getScorePath();
            AddScoreObjectEdit top = null;
            for (ScoreObject scoreObject : scoreObjects) {
                ScoreObject clone = (ScoreObject)scoreObject.deepCopy();
                clone.setStartTime(clone.getStartTime() + clone.getSubjectiveDuration());
                ScoreObjectLayer layer = (ScoreObjectLayer)path.getLayerForScoreObject(scoreObject);
                if (layer == null) {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not find Layer for ScoreObject", "Error", 0);
                    return;
                }
                layer.add((Object)clone);
                AddScoreObjectEdit edit = new AddScoreObjectEdit(layer, clone);
                if (top == null) {
                    top = edit;
                    continue;
                }
                top.addSubEdit(edit);
            }
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit(top);
        }
    }
}

