/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.ui.core.score.noteProcessorChain.NoteProcessorChainTable;
import blue.ui.core.score.noteProcessorChain.NoteProcessorChainTableModel;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import blue.ui.utilities.UiUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.util.Exceptions;

public class NoteProcessorChainEditor
extends JComponent {
    private NoteProcessorPopup noteProcPopup = new NoteProcessorPopup(this);
    private EditPopup editPopup = new EditPopup(this);
    NoteProcessorChain npc;
    protected NoteProcessorChainTableModel npcModel;
    NoteProcessorChainTable npcTable;
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton pushUpButton = new JButton();
    JButton pushDownButton = new JButton();
    JPanel topPanel;
    JPanel noteProcessorEditPanel = new JPanel();
    CardLayout noteProcessorCardLayout = new CardLayout();
    private static NoteProcessor buffer;

    public NoteProcessorChainEditor() {
        this.setPreferredSize(new Dimension(300, 300));
        this.setLayout(new BorderLayout());
        Border border1 = BorderFactory.createLineBorder(Color.darkGray, 1);
        TitledBorder titledBorder1 = new TitledBorder(border1, " " + BlueSystem.getString((String)"soundObjectProperties.noteProcessors.title") + " ");
        CompoundBorder border2 = BorderFactory.createCompoundBorder(titledBorder1, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBorder(border2);
        this.topPanel = new JPanel();
        this.topPanel.add(this.addButton);
        this.topPanel.add(this.removeButton);
        this.topPanel.add(this.pushUpButton);
        this.topPanel.add(this.pushDownButton);
        JScrollPane jsp = new JScrollPane();
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BorderLayout());
        editPanel.add((Component)this.topPanel, "North");
        editPanel.add((Component)jsp, "Center");
        this.npcModel = new NoteProcessorChainTableModel();
        this.npcTable = new NoteProcessorChainTable(this.npcModel);
        jsp.setViewportView(this.npcTable);
        this.npcTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                NoteProcessorChainEditor.this.npcModel.setCurrentNoteProcessor(NoteProcessorChainEditor.this.npcTable.getSelectedRow());
                NoteProcessorChainEditor.this.updateHilightRows();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    NoteProcessorChainEditor.this.editPopup.show(NoteProcessorChainEditor.this.npcTable, e.getX(), e.getY());
                }
            }
        });
        this.addButton.setToolTipText(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.add"));
        this.addButton.setText("+");
        this.addButton.addActionListener(this::showNoteProcessorPopup);
        this.removeButton.setToolTipText(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.remove"));
        this.removeButton.setText("-");
        this.removeButton.addActionListener(e -> this.removeCurrentNoteProcessor());
        this.pushUpButton.setToolTipText(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.pushUp"));
        this.pushUpButton.setText("^");
        this.pushUpButton.addActionListener(this::pushUpNoteProcessor);
        this.pushDownButton.setToolTipText(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.pushDown"));
        this.pushDownButton.setText("V");
        this.pushDownButton.addActionListener(this::pushDownNoteProcessor);
        this.noteProcessorEditPanel.setLayout(this.noteProcessorCardLayout);
        this.noteProcessorEditPanel.add((Component)editPanel, "edit");
        this.noteProcessorEditPanel.add((Component)new JLabel(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.notSupported")), "unsupported");
        this.noteProcessorCardLayout.show(this.noteProcessorEditPanel, "unsupported");
        this.add((Component)this.noteProcessorEditPanel, "Center");
    }

    private void updateHilightRows() {
        int[] hilightRows = this.npcModel.getHilightRows();
        this.npcTable.setHilightRows(hilightRows);
    }

    public void setNoteProcessorChainMap(NoteProcessorChainMap npcMap) {
        this.noteProcPopup.setNoteProcessorChainMap(npcMap);
    }

    public void setNoteProcessorChain(NoteProcessorChain npc) {
        if (this.npcTable.isEditing()) {
            this.npcTable.getCellEditor().stopCellEditing();
        }
        this.npc = npc;
        this.npcModel.setNoteProcessorChain(npc);
        if (npc == null) {
            this.noteProcessorCardLayout.show(this.noteProcessorEditPanel, "unsupported");
        } else {
            this.noteProcessorCardLayout.show(this.noteProcessorEditPanel, "edit");
        }
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    void showNoteProcessorPopup(ActionEvent e) {
        if (this.npc == null) {
            return;
        }
        this.noteProcPopup.show(this.topPanel, this.addButton.getX(), this.addButton.getY() + this.addButton.getHeight());
    }

    protected void cutCurrentNoteProcessor() {
        if (this.npc == null) {
            return;
        }
        buffer = this.npcModel.getCurrentNoteProcessor();
        this.npcModel.removeNoteProcessor();
    }

    protected void pasteCurrentNoteProcessor() {
        if (this.npc == null || buffer == null) {
            return;
        }
        NoteProcessor clone = (NoteProcessor)buffer.deepCopy();
        this.npcModel.addNoteProcessor(clone);
    }

    protected void copyCurrentNoteProcessor() {
        if (this.npc == null) {
            return;
        }
        buffer = this.npcModel.getCurrentNoteProcessor();
    }

    void removeCurrentNoteProcessor() {
        if (this.npc == null) {
            return;
        }
        this.npcModel.removeNoteProcessor();
        this.updateHilightRows();
    }

    void pushUpNoteProcessor(ActionEvent e) {
        if (this.npc == null) {
            return;
        }
        this.npcModel.pushUpNoteProcessor();
        this.updateHilightRows();
    }

    void pushDownNoteProcessor(ActionEvent e) {
        if (this.npc == null) {
            return;
        }
        this.npcModel.pushDownNoteProcessor();
        this.updateHilightRows();
    }

    public void addNoteProcessor(NoteProcessor np) {
        this.npcModel.addNoteProcessor(np);
        this.updateHilightRows();
    }

    static class EditPopup
    extends JPopupMenu {
        private NoteProcessorChainEditor npcEditor;
        private JMenuItem removeProcessor = new JMenuItem();
        private JMenuItem cutProcessor = new JMenuItem();
        private JMenuItem copyProcessor = new JMenuItem();
        private JMenuItem pasteProcessor = new JMenuItem();

        public EditPopup(NoteProcessorChainEditor npcEditor) {
            this.npcEditor = npcEditor;
            this.cutProcessor.setText("Cut");
            this.cutProcessor.addActionListener(e -> npcEditor.cutCurrentNoteProcessor());
            this.copyProcessor.setText("Copy");
            this.copyProcessor.addActionListener(e -> npcEditor.copyCurrentNoteProcessor());
            this.pasteProcessor.setText("Paste");
            this.pasteProcessor.addActionListener(e -> npcEditor.pasteCurrentNoteProcessor());
            this.removeProcessor.setText(BlueSystem.getString((String)"soundObjectProperties.noteProcessors.remove"));
            this.removeProcessor.addActionListener(e -> npcEditor.removeCurrentNoteProcessor());
            this.add(this.cutProcessor);
            this.add(this.copyProcessor);
            this.add(this.pasteProcessor);
            this.addSeparator();
            this.add(this.removeProcessor);
            this.pack();
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.pasteProcessor.setEnabled(buffer != null);
            NoteProcessor currentNoteProcessor = this.npcEditor.npcModel.getCurrentNoteProcessor();
            this.pasteProcessor.setEnabled(buffer != null);
            this.cutProcessor.setEnabled(currentNoteProcessor != null);
            this.copyProcessor.setEnabled(currentNoteProcessor != null);
            this.removeProcessor.setEnabled(currentNoteProcessor != null);
            super.show(invoker, x, y);
        }
    }

    static class NoteProcessorPopup
    extends JPopupMenu
    implements ActionListener {
        NoteProcessorChainMap npcMap;
        NoteProcessorChainEditor npcEditor;
        ActionListener insertChainListener;
        HashMap<String, Class> npNameClassMap = new HashMap();
        private JMenuItem saveChain;
        private JMenu insertChain = new JMenu("Insert");
        private JMenuItem removeChain;

        public NoteProcessorPopup(NoteProcessorChainEditor npcEditor) {
            this.npcEditor = npcEditor;
            List plugins = LazyPluginFactory.loadPlugins((String)"blue/noteProcessors", NoteProcessor.class);
            JMenu insertNoteProcessor = new JMenu("Insert Note Processor");
            for (LazyPlugin plugin : plugins) {
                JMenuItem temp = new JMenuItem();
                temp.setText(plugin.getDisplayName());
                temp.putClientProperty("plugin", plugin);
                temp.addActionListener(this);
                insertNoteProcessor.add(temp);
            }
            this.insertChainListener = e -> this.insertChain(e.getActionCommand());
            this.saveChain = new JMenuItem("Save");
            this.saveChain.addActionListener(e -> this.saveChain());
            this.removeChain = new JMenuItem("Remove");
            this.removeChain.addActionListener(e -> this.removeChain());
            JMenu npcMapMenu = new JMenu("Note Processor Chains");
            npcMapMenu.add(this.saveChain);
            npcMapMenu.add(this.insertChain);
            npcMapMenu.add(this.removeChain);
            this.add(insertNoteProcessor);
            this.add(npcMapMenu);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.updateNoteProcessorChainMenuStatus();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }

        protected void insertChain(String npcName) {
            if (this.npcMap == null) {
                return;
            }
            NoteProcessorChain npc = this.npcMap.getNoteProcessorChain((Object)npcName);
            if (npc == null) {
                return;
            }
            npc = new NoteProcessorChain(npc);
            for (NoteProcessor np : npc) {
                this.npcEditor.addNoteProcessor(np);
            }
        }

        public void setNoteProcessorChainMap(NoteProcessorChainMap npcMap) {
            this.npcMap = npcMap;
            this.updateNPCMapMenu();
        }

        private void updateNPCMapMenu() {
            if (this.npcMap == null) {
                return;
            }
            this.insertChain.removeAll();
            for (String name : this.npcMap.keySet()) {
                JMenuItem item = new JMenuItem();
                item.setText(name);
                item.setActionCommand(name);
                item.addActionListener(this.insertChainListener);
                this.insertChain.add(item);
            }
        }

        protected void saveChain() {
            if (this.npcMap == null || this.npcEditor.getNoteProcessorChain().size() == 0) {
                return;
            }
            String retVal = JOptionPane.showInputDialog(null, (Object)"Name of Note Processor Chain");
            if (retVal == null) {
                return;
            }
            String name = retVal;
            NoteProcessorChain npc = this.npcEditor.getNoteProcessorChain();
            if (npc != null) {
                this.npcMap.put((Object)name, (Object)npc);
                this.updateNPCMapMenu();
            }
        }

        protected void removeChain() {
            if (this.npcMap == null || this.npcMap.size() == 0) {
                return;
            }
            Object[] names = this.npcMap.keySet().toArray();
            Object retVal = JOptionPane.showInputDialog(null, "Select Chain to Remove", "Remove Chain", 1, null, names, names[0]);
            if (retVal == null) {
                return;
            }
            String name = (String)retVal;
            this.npcMap.remove((Object)name);
            this.updateNPCMapMenu();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LazyPlugin plugin = (LazyPlugin)((JMenuItem)ae.getSource()).getClientProperty("plugin");
            NoteProcessor npTemplate = (NoteProcessor)plugin.getInstance();
            try {
                NoteProcessor np = (NoteProcessor)npTemplate.getClass().newInstance();
                this.npcEditor.addNoteProcessor(np);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void updateNoteProcessorChainMenuStatus() {
            if (this.npcMap == null) {
                this.saveChain.setEnabled(false);
                this.insertChain.setEnabled(false);
                this.removeChain.setEnabled(false);
                return;
            }
            boolean canSave = this.npcEditor.getNoteProcessorChain().size() != 0;
            this.saveChain.setEnabled(canSave);
            boolean hasChains = this.npcMap.size() != 0;
            this.insertChain.setEnabled(hasChains);
            this.removeChain.setEnabled(hasChains);
        }
    }
}

