/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.BlueSystem;
import blue.mixer.Effect;
import blue.orchestra.editor.blueSynthBuilder.BSBCompletionProvider;
import blue.orchestra.editor.blueSynthBuilder.BSBInterfaceEditor;
import blue.ui.core.mixer.EffectsObjectRegistry;
import blue.ui.core.udo.EmbeddedOpcodeListPanel;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.undo.TabWatchingUndoableEditGenerator;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class EffectEditor
extends JPanel
implements PropertyChangeListener {
    BSBInterfaceEditor interfaceEditor = new BSBInterfaceEditor(EffectsObjectRegistry.getBSBObjects(), true);
    BSBCompletionProvider completionProvider = new BSBCompletionProvider();
    MimeTypeEditorComponent code1 = new MimeTypeEditorComponent("text/x-blue-synth-builder");
    MimeTypeEditorComponent commentsText = new MimeTypeEditorComponent("text/plain");
    JLabel xInLabel = new JLabel();
    JLabel xOutLabel = new JLabel();
    EmbeddedOpcodeListPanel udoPanel = new EmbeddedOpcodeListPanel();
    private Effect effect = null;
    UndoManager undo = new UndoRedo.Manager();
    private JSpinner inSpinner;
    private JLabel inputLabel;
    private JSpinner outSpinner;
    private JLabel outputLabel;
    private JTabbedPane tabs;

    public EffectEditor() {
        this.initComponents();
        this.tabs.add("Interface", this.interfaceEditor);
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.add((Component)this.xInLabel, "North");
        codePanel.add((Component)this.code1, "Center");
        codePanel.add((Component)this.xOutLabel, "South");
        this.inSpinner.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.inSpinner.addChangeListener(e -> {
            if (this.effect != null) {
                Integer val = (Integer)this.inSpinner.getValue();
                this.effect.setNumIns(val.intValue());
            }
        });
        this.outSpinner.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.outSpinner.addChangeListener(e -> {
            if (this.effect != null) {
                Integer val = (Integer)this.outSpinner.getValue();
                this.effect.setNumOuts(val.intValue());
            }
        });
        this.tabs.add("Code", codePanel);
        this.commentsText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (EffectEditor.this.effect != null) {
                    EffectEditor.this.effect.setComments(EffectEditor.this.commentsText.getText());
                }
            }
        });
        this.tabs.add(BlueSystem.getString((String)"instrument.udo"), this.udoPanel);
        this.tabs.add("Comments", (Component)this.commentsText);
        this.commentsText.getDocument().addUndoableEditListener(this.undo);
        this.commentsText.setUndoManager(this.undo);
        new TabWatchingUndoableEditGenerator(this.tabs, this.undo);
        this.setEffect(null);
        this.code1.getDocument().addUndoableEditListener(this.undo);
        this.code1.setUndoManager(this.undo);
        this.code1.getJEditorPane().putClientProperty("bsb-completion-provider", this.completionProvider);
        this.code1.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (EffectEditor.this.effect != null) {
                    EffectEditor.this.effect.setCode(EffectEditor.this.code1.getText());
                }
            }
        });
    }

    public void setEffect(Effect effect) {
        if (this.effect != null) {
            this.effect.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.effect == effect && this.effect != null) {
            return;
        }
        this.effect = null;
        if (effect == null) {
            this.interfaceEditor.editInterface(null, null);
            this.completionProvider.setBSBGraphicInterface(null);
            this.code1.setText(null);
            this.commentsText.setText("");
            this.inSpinner.setValue(new Integer(1));
            this.outSpinner.setValue(new Integer(1));
            this.code1.getJEditorPane().setEnabled(false);
            this.commentsText.getJEditorPane().setEnabled(false);
            this.inSpinner.setEnabled(false);
            this.outSpinner.setEnabled(false);
            this.udoPanel.editOpcodeList(null);
        } else {
            this.interfaceEditor.editInterface(effect.getGraphicInterface(), null);
            this.completionProvider.setBSBGraphicInterface(effect.getGraphicInterface());
            this.code1.getJEditorPane().setText(effect.getCode());
            this.commentsText.setText(effect.getComments());
            this.inSpinner.setValue(new Integer(effect.getNumIns()));
            this.outSpinner.setValue(new Integer(effect.getNumOuts()));
            this.code1.getJEditorPane().setEnabled(true);
            this.commentsText.getJEditorPane().setEnabled(true);
            this.inSpinner.setEnabled(true);
            this.outSpinner.setEnabled(true);
            this.udoPanel.editOpcodeList(effect.getOpcodeList());
            effect.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.code1.getJEditorPane().setCaretPosition(0);
        this.commentsText.getJEditorPane().setCaretPosition(0);
        this.effect = effect;
        this.updateXLabels();
        this.undo.discardAllEdits();
    }

    private void updateXLabels() {
        int i;
        if (this.effect == null) {
            this.xInLabel.setText(" ");
            this.xOutLabel.setText(" ");
            return;
        }
        int numIns = this.effect.getNumIns();
        int numOuts = this.effect.getNumOuts();
        StringBuffer inText = new StringBuffer();
        StringBuffer outText = new StringBuffer();
        inText.append("<html>");
        for (i = 0; i < numIns; ++i) {
            if (i > 0) {
                inText.append(",");
            }
            inText.append("ain").append(i + 1);
        }
        inText.append(" <b>xin</b></html>");
        outText.append("<html><b>xout</b> ");
        for (i = 0; i < numOuts; ++i) {
            if (i > 0) {
                outText.append(",");
            }
            outText.append("aout").append(i + 1);
        }
        outText.append("</html>");
        this.xInLabel.setText(inText.toString());
        this.xOutLabel.setText(outText.toString());
    }

    private void initComponents() {
        this.inputLabel = new JLabel();
        this.outputLabel = new JLabel();
        this.inSpinner = new JSpinner();
        this.outSpinner = new JSpinner();
        this.tabs = new JTabbedPane();
        this.inputLabel.setText("Inputs:");
        this.outputLabel.setText("Outputs:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabs, -1, 479, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.inputLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inSpinner, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outSpinner, -2, 42, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputLabel).addComponent(this.inSpinner, -2, -1, -2).addComponent(this.outputLabel).addComponent(this.outSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabs, -1, 390, Short.MAX_VALUE).addContainerGap()));
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        EffectEditor editor = new EffectEditor();
        editor.setEffect(new Effect());
        GUI.showComponentAsStandalone((Component)editor, (String)"Effect Editor", (boolean)true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this.effect && ((prop = evt.getPropertyName()).equals("numIns") || prop.equals("numOuts"))) {
            this.updateXLabels();
        }
    }
}

