/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.soundFont;

import blue.settings.UtilitySettings;
import blue.tools.soundFont.SoundFontInfo;
import blue.ui.core.render.DiskRenderManager;
import blue.utility.FileUtilities;
import blue.utility.TextUtilities;
import java.io.File;
import java.util.StringTokenizer;

public class SoundFontUtility {
    private static String templateCSD = null;

    private static String getTemplateCSD() {
        return templateCSD;
    }

    private static String getInstrumentList(String csoundOutput) {
        StringTokenizer st = new StringTokenizer(csoundOutput, "\n");
        StringBuffer buffer = new StringBuffer();
        int mode = 0;
        while (st.hasMoreTokens() && mode != 2) {
            String line = st.nextToken();
            switch (mode) {
                case 0: {
                    if (!line.startsWith("Instrument list")) break;
                    mode = 1;
                    break;
                }
                case 1: {
                    if (line.indexOf(41) == -1 || line.startsWith("Preset list")) {
                        mode = 2;
                        break;
                    }
                    buffer.append(line).append("\n");
                }
            }
        }
        return buffer.toString();
    }

    private static String getPresetList(String csoundOutput) {
        StringTokenizer st = new StringTokenizer(csoundOutput, "\n");
        StringBuffer buffer = new StringBuffer();
        int mode = 0;
        while (st.hasMoreTokens() && mode != 2) {
            String line = st.nextToken();
            switch (mode) {
                case 0: {
                    if (!line.startsWith("Preset list")) break;
                    mode = 1;
                    break;
                }
                case 1: {
                    if (line.indexOf(41) == -1) {
                        mode = 2;
                        break;
                    }
                    buffer.append(line).append("\n");
                }
            }
        }
        return buffer.toString();
    }

    public static SoundFontInfo getSoundFontInfo(String fileName) {
        String cleanName = fileName.replace('\\', '/');
        String tempCSD = SoundFontUtility.getTemplateCSD();
        tempCSD = TextUtilities.replace((String)tempCSD, (String)"$filename", (String)cleanName);
        File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", null, (String)tempCSD);
        String osName = System.getProperty("os.name");
        String command = UtilitySettings.getInstance().csoundExecutable;
        String[] args = new String[]{command, temp.getAbsolutePath()};
        String csoundOutput = DiskRenderManager.getInstance().execWaitAndCollect(args, null);
        String instrumentList = SoundFontUtility.getInstrumentList(csoundOutput);
        String presetList = SoundFontUtility.getPresetList(csoundOutput);
        SoundFontInfo info = new SoundFontInfo(instrumentList, presetList);
        return info;
    }

    public static void main(String[] args) {
        SoundFontInfo info = SoundFontUtility.getSoundFontInfo("c:\\csound\\samples\\sf2\\Chinese Flute Zhudi Analog (906KB).sf2");
        System.out.println(info.instrumentList);
        System.out.println(info.presetList);
    }

    static {
        templateCSD = "<CsoundSynthesizer>\n";
        templateCSD = templateCSD + "<CsInstruments>\n";
        templateCSD = templateCSD + "sr = 44100\n";
        templateCSD = templateCSD + "kr = 441\n";
        templateCSD = templateCSD + "ksmps = 100\n";
        templateCSD = templateCSD + "nchnls = 2\n";
        templateCSD = templateCSD + "gi_sf\tsfload\t\"$filename\"\n";
        templateCSD = templateCSD + "sfilist gi_sf\n";
        templateCSD = templateCSD + "sfplist gi_sf\n";
        templateCSD = templateCSD + "instr 1\n";
        templateCSD = templateCSD + "endin\n";
        templateCSD = templateCSD + "</CsInstruments>\n";
        templateCSD = templateCSD + "<CsScore>\n";
        templateCSD = templateCSD + "e\n";
        templateCSD = templateCSD + "</CsScore>\n";
        templateCSD = templateCSD + "</CsoundSynthesizer>";
    }
}

