/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.soundObject.PianoRoll;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public final class TimeBar
extends JComponent
implements PropertyChangeListener {
    private static final Font LABEL_FONT = new Font("dialog", 0, 11);
    private PianoRoll pianoRoll;

    public TimeBar() {
        this.setDoubleBuffered(true);
        this.setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        int start;
        super.paintComponent(g);
        if (this.pianoRoll == null || this.getHeight() == 0 || this.getWidth() == 0) {
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int h = 19;
        int startX = bounds.x;
        int endX = startX + bounds.width;
        int pixelTime = this.pianoRoll.getPixelSecond();
        int timeUnit = this.pianoRoll.getTimeUnit();
        int timeDisplay = this.pianoRoll.getTimeDisplay();
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = timeDisplay == 0 ? fontMetrics.stringWidth("00:00") : fontMetrics.stringWidth("000");
        int lastVal = 0;
        g.setColor(this.getForeground());
        g.drawLine(startX, h, endX, h);
        int longHeight = h - 6;
        int shortHeight = h - 3;
        int i = start = startX / pixelTime;
        while (i * pixelTime < endX) {
            int lineX = i * pixelTime;
            if (i % timeUnit == 0) {
                if (lineX == 0 || lineX - lastVal > textWidth) {
                    g.drawLine(lineX, h, lineX, longHeight);
                    lastVal = lineX;
                } else {
                    g.drawLine(lineX, h, lineX, shortHeight);
                }
            } else {
                g.drawLine(lineX, h, lineX, shortHeight);
            }
            ++i;
        }
        g.setFont(LABEL_FONT);
        lastVal = 0;
        i = start;
        while (i * pixelTime < endX) {
            if (i % timeUnit == 0) {
                String time = "";
                if (timeDisplay == 0) {
                    int min = i / 60;
                    int sec = i % 60;
                    String seconds = sec < 10 ? "0" + sec : String.valueOf(sec);
                    time = min + ":" + seconds;
                } else if (timeDisplay == 1) {
                    time = Integer.toString(i);
                }
                int labelX = i * pixelTime;
                if (labelX == 0 || labelX - lastVal > textWidth) {
                    g.drawString(time, labelX + 3, 14);
                    lastVal = labelX;
                }
            }
            ++i;
        }
    }

    public void editPianoRoll(PianoRoll pianoRoll) {
        if (this.pianoRoll != null) {
            this.pianoRoll.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.pianoRoll = pianoRoll;
        pianoRoll.addPropertyChangeListener((PropertyChangeListener)this);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (evt.getSource() == this.pianoRoll && (prop.equals("timeDisplay") || prop.equals("timeUnit") || prop.equals("pixelSecond"))) {
            this.repaint();
        }
    }
}

