/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.soundObject.PianoRoll;
import blue.soundObject.pianoRoll.PianoNote;
import blue.soundObject.pianoRoll.Scale;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PianoNoteView
extends JPanel
implements PropertyChangeListener,
Comparable<PianoNoteView> {
    private static final int OCTAVES = 16;
    private static Border NORMAL_BORDER = BorderFactory.createBevelBorder(0);
    private static Color NORMAL_COLOR = Color.GRAY;
    private static Color SELECTED_COLOR = Color.WHITE;
    private PianoNote note;
    private PianoRoll p;

    public PianoNoteView(PianoNote note, PianoRoll p) {
        this.note = note;
        this.p = p;
        this.setBackground(NORMAL_COLOR);
        this.setBorder(NORMAL_BORDER);
        this.setOpaque(true);
        this.updatePropertiesFromNote();
        note.addPropertyChangeListener((PropertyChangeListener)this);
        this.addHierarchyListener(e -> {
            if (this.getParent() == null) {
                this.removeAsListener();
            }
        });
    }

    public void removeAsListener() {
        this.note.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public PianoNote getPianoNote() {
        return this.note;
    }

    public void updateNoteStartFromLocation() {
        int pixelSecond = this.p.getPixelSecond();
        float start = (float)this.getX() / (float)pixelSecond;
        this.updateNotePitchFromY();
        this.note.setStart((double)start);
    }

    public void updateNotePitchFromY() {
        int yVal;
        int scaleDegrees;
        if (this.p.getPchGenerationMethod() == 2) {
            scaleDegrees = 12;
            int total = 128 * this.p.getNoteHeight();
            yVal = total - this.getY();
        } else {
            scaleDegrees = this.p.getScale().getNumScaleDegrees();
            int total = scaleDegrees * this.p.getNoteHeight() * 16;
            yVal = total - this.getY();
        }
        int layerIndex = yVal / this.p.getNoteHeight() - 1;
        int oct = layerIndex / scaleDegrees;
        int pch = layerIndex % scaleDegrees;
        this.note.setOctave(oct);
        this.note.setScaleDegree(pch);
    }

    private void updatePropertiesFromNote() {
        int pixelSecond = this.p.getPixelSecond();
        int x = (int)(this.note.getStart() * (double)pixelSecond);
        int y = this.p.getPchGenerationMethod() == 2 ? this.getMIDIY(this.note.getOctave(), this.note.getScaleDegree()) : this.getScaleY(this.p.getScale(), this.note.getOctave(), this.note.getScaleDegree());
        int w = (int)(this.note.getDuration() * (double)pixelSecond);
        this.setLocation(x, y);
        this.setSize(w, this.p.getNoteHeight());
    }

    private int getMIDIY(int octave, int scaleDegree) {
        int scaleDegrees = 12;
        int noteHeight = this.p.getNoteHeight();
        int totalHeight = noteHeight * 128;
        int yVal = (octave * scaleDegrees + scaleDegree + 1) * noteHeight;
        return totalHeight - yVal;
    }

    private int getScaleY(Scale scale, int octave, int scaleDegree) {
        int scaleDegrees = scale.getNumScaleDegrees();
        int noteHeight = this.p.getNoteHeight();
        int totalHeight = noteHeight * scaleDegrees * 16;
        int yVal = (octave * scaleDegrees + scaleDegree + 1) * noteHeight;
        return totalHeight - yVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.note) {
            this.updatePropertiesFromNote();
        }
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBackground(SELECTED_COLOR);
        } else {
            this.setBackground(NORMAL_COLOR);
        }
    }

    public void updateNoteDurFromWidth() {
        int pixelSecond = this.p.getPixelSecond();
        this.note.setDuration((double)((float)this.getWidth() / (float)pixelSecond));
    }

    @Override
    public int compareTo(PianoNoteView a) {
        int x2;
        int x1 = this.getX();
        if (x1 > (x2 = a.getX())) {
            return 1;
        }
        if (x1 < x2) {
            return -1;
        }
        return 0;
    }
}

