/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.soundObject.PianoRoll;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import java.util.ArrayList;
import java.util.Collections;

public class NoteBuffer
extends ArrayList<PianoNoteView>
implements SelectionListener<PianoNoteView> {
    private static final int EDGE = 5;
    private PianoRoll pianoRoll = null;
    int[] startX;
    int[] startLayer;
    public int leftBoundary;
    int startWidth;
    double[] initialStartTimes = null;

    public void startMove() {
        this.startX = new int[this.size()];
        this.startLayer = new int[this.size()];
        this.initialStartTimes = new double[this.size()];
        Collections.sort(this);
        this.leftBoundary = Integer.MAX_VALUE;
        int noteHeight = this.pianoRoll.getNoteHeight();
        for (int i = 0; i < this.size(); ++i) {
            PianoNoteView noteView = (PianoNoteView)this.get(i);
            this.startX[i] = noteView.getX();
            this.startLayer[i] = noteView.getY() / noteHeight;
            this.initialStartTimes[i] = noteView.getPianoNote().getStart();
            if (this.startX[i] >= this.leftBoundary) continue;
            this.leftBoundary = this.startX[i];
        }
        this.leftBoundary = -this.leftBoundary;
    }

    public void moveByTime(double diffTime, int layerDiff) {
        int noteHeight = this.pianoRoll.getNoteHeight();
        for (int i = 0; i < this.size(); ++i) {
            PianoNoteView noteView = (PianoNoteView)this.get(i);
            int newY = (this.startLayer[i] + layerDiff) * noteHeight;
            noteView.setLocation(noteView.getX(), newY);
            noteView.updateNotePitchFromY();
            noteView.getPianoNote().setStart(this.initialStartTimes[i] + diffTime);
        }
    }

    public void move(int diffX, int layerDiff) {
        if (diffX < this.leftBoundary) {
            diffX = this.leftBoundary;
        }
        int noteHeight = this.pianoRoll.getNoteHeight();
        for (int i = 0; i < this.size(); ++i) {
            PianoNoteView noteView = (PianoNoteView)this.get(i);
            int newY = (this.startLayer[i] + layerDiff) * noteHeight;
            noteView.setLocation(this.startX[i] + diffX, newY);
        }
    }

    public void endMove() {
        this.startX = null;
        this.startLayer = null;
        for (PianoNoteView noteView : this) {
            noteView.updateNoteStartFromLocation();
        }
    }

    public void selectionPerformed(SelectionEvent<PianoNoteView> e) {
        Object selectedItem = e.getSelectedItem();
        switch (e.getSelectionType()) {
            case -1: {
                this.clearBuffer();
                break;
            }
            case 0: {
                if (this.contains(selectedItem) && this.size() == 1) {
                    return;
                }
                this.clearBuffer();
                this.addBufferedObject((PianoNoteView)selectedItem);
                break;
            }
            case 1: {
                this.addBufferedObject((PianoNoteView)selectedItem);
                break;
            }
            case 2: {
                ((PianoNoteView)selectedItem).setSelected(false);
                this.remove(selectedItem);
            }
        }
    }

    private void addBufferedObject(PianoNoteView sObj) {
        if (!this.contains(sObj)) {
            this.add(sObj);
            sObj.setSelected(true);
        }
    }

    private void clearBuffer() {
        for (PianoNoteView temp : this) {
            temp.setSelected(false);
        }
        this.clear();
    }

    public void startResize() {
        if (this.size() != 1) {
            System.out.println("Error: Size of NoteBuffer != 1");
            return;
        }
        PianoNoteView temp = (PianoNoteView)this.get(0);
        this.initialStartTimes = new double[1];
        this.initialStartTimes[0] = temp.getPianoNote().getStart();
        this.startWidth = temp.getWidth();
    }

    public void setDuration(double duration) {
        if (this.size() != 1) {
            System.out.println("Error: Size of NoteBuffer != 1");
            return;
        }
        PianoNoteView temp = (PianoNoteView)this.get(0);
        temp.getPianoNote().setDuration(duration);
    }

    public void resize(int diffX) {
        if (this.size() != 1) {
            System.out.println("Error: Size of NoteBuffer != 1");
            return;
        }
        int newWidth = this.startWidth + diffX;
        if (newWidth < 5) {
            newWidth = 5;
        }
        PianoNoteView temp = (PianoNoteView)this.get(0);
        temp.setSize(newWidth, temp.getHeight());
    }

    public void endResize() {
        PianoNoteView temp = (PianoNoteView)this.get(0);
        temp.updateNoteDurFromWidth();
    }

    public PianoRoll getPianoRoll() {
        return this.pianoRoll;
    }

    public void setPianoRoll(PianoRoll pianoRoll) {
        this.pianoRoll = pianoRoll;
    }
}

