/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pattern;

import blue.soundObject.PatternObject;
import blue.soundObject.editor.pattern.PatternsConstants;
import blue.soundObject.pattern.Pattern;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class PatternLayerEditPanel
extends JComponent
implements AdjustmentListener {
    static Point posSync = new Point();
    JPanel topPanel = new JPanel();
    JPanel bottomPanel = new JPanel();
    JViewport lView = new JViewport();
    JTable layerTable;
    JButton buttonUp = new JButton("^");
    JButton buttonDown = new JButton("V");
    JButton buttonAdd = new JButton("+");
    JButton buttonRemove = new JButton("-");
    private PatternObject pattern;

    public PatternLayerEditPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Dimension d = new Dimension(20, 17);
        this.buttonUp.setPreferredSize(d);
        this.buttonDown.setPreferredSize(d);
        this.buttonAdd.setPreferredSize(d);
        this.buttonRemove.setPreferredSize(d);
        this.bottomPanel.setLayout(new GridLayout());
        this.buttonUp.addActionListener(e -> this.pushUpLayer());
        this.buttonDown.addActionListener(e -> this.pushDownLayer());
        this.buttonAdd.addActionListener(e -> this.addLayer());
        this.buttonRemove.addActionListener(e -> this.removeLayer());
        this.bottomPanel.add(this.buttonUp);
        this.bottomPanel.add(this.buttonDown);
        this.bottomPanel.add(this.buttonAdd);
        this.bottomPanel.add(this.buttonRemove);
        this.layerTable = new JTable();
        this.layerTable.setSelectionMode(1);
        this.lView.add(this.layerTable);
        this.add((Component)this.layerTable.getTableHeader(), "North");
        this.add((Component)this.bottomPanel, "South");
        this.add((Component)this.lView, "Center");
        this.layerTable.setRowHeight(PatternsConstants.patternViewHeight);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.layerTable.getSelectionModel().addListSelectionListener(listener);
    }

    private void setTableColumnSizes() {
        this.layerTable.getTableHeader().setReorderingAllowed(false);
        this.layerTable.getTableHeader().setPreferredSize(new Dimension(17, 21));
        this.layerTable.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(40);
        this.layerTable.getTableHeader().getColumnModel().getColumn(1).setMaxWidth(40);
        this.layerTable.getTableHeader().getColumnModel().getColumn(1).setMinWidth(40);
    }

    public void setPatternObject(PatternObject pattern) {
        this.layerTable.setRowHeight(PatternsConstants.patternViewHeight);
        this.pattern = pattern;
        this.layerTable.setModel((TableModel)pattern);
        this.setTableColumnSizes();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        posSync.setLocation(0, ae.getValue());
        this.lView.setViewPosition(posSync);
    }

    public void addLayer() {
        int selected = this.layerTable.getSelectedRow();
        this.pattern.addPattern(selected + 1);
        if (selected != -1) {
            this.layerTable.setRowSelectionInterval(selected, selected);
        }
    }

    public void removeLayer() {
        int selected = this.layerTable.getSelectedRow();
        if (selected == -1 || this.pattern == null) {
            return;
        }
        String message = "Please confirm deleting this pattern.";
        if (JOptionPane.showConfirmDialog(null, message) == 0) {
            this.pattern.removePattern(selected);
        }
    }

    public void pushUpLayer() {
        int[] selected = this.layerTable.getSelectedRows();
        if (selected.length == 0 || selected[0] == 0) {
            return;
        }
        this.pattern.pushUpPatternLayers(selected);
        this.layerTable.setRowSelectionInterval(selected[0] - 1, selected[selected.length - 1] - 1);
    }

    public void pushDownLayer() {
        int[] selected = this.layerTable.getSelectedRows();
        if (selected.length == 0 || selected[selected.length - 1] == this.pattern.size() - 1) {
            return;
        }
        this.pattern.pushDownPatternLayers(selected);
        this.layerTable.setRowSelectionInterval(selected[0] + 1, selected[selected.length - 1] + 1);
    }

    public Pattern getSelectedPattern() {
        int selected = this.layerTable.getSelectedRow();
        if (selected < 0) {
            return null;
        }
        return this.pattern.getPattern(selected);
    }

    public JViewport getViewPort() {
        return this.lView;
    }
}

