/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.probability.ProbabilityEditorFactory;
import blue.soundObject.jmask.Probability;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class ProbabilityEditor
extends JPanel
implements DurationSettable {
    Probability probability = null;
    double duration = 1.0;
    private DurationSettable currentProbabilityGeneratorEditor;
    private JPanel editorPanel;
    private JLabel jLabel1;
    private JComboBox probabilityTypeComboBox;

    public ProbabilityEditor(Probability probability) {
        this.initComponents();
        ProbabilityGenerator[] generators = probability.getGenerators();
        Object[] values = new Object[generators.length];
        for (int i = 0; i < generators.length; ++i) {
            values[i] = generators[i].getName();
        }
        this.probabilityTypeComboBox.setModel(new DefaultComboBoxModel<Object>(values));
        this.probabilityTypeComboBox.setSelectedIndex(probability.getSelectedIndex());
        this.probability = probability;
        this.probabilityTypeComboBox.setSelectedIndex(probability.getSelectedIndex());
        this.updateSelectedProbabilityEditor();
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
        if (this.currentProbabilityGeneratorEditor != null) {
            this.currentProbabilityGeneratorEditor.setDuration(duration);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.probabilityTypeComboBox = new JComboBox();
        this.editorPanel = new JPanel();
        this.jLabel1.setText("Probability");
        this.probabilityTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.probabilityTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProbabilityEditor.this.probabilityTypeComboBoxActionPerformed(evt);
            }
        });
        this.editorPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probabilityTypeComboBox, 0, 326, Short.MAX_VALUE).addContainerGap()).addComponent(this.editorPanel, -1, 435, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.probabilityTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void probabilityTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.probability != null) {
            this.probability.setSelectedIndex(this.probabilityTypeComboBox.getSelectedIndex());
            this.updateSelectedProbabilityEditor();
        }
    }

    private void updateSelectedProbabilityEditor() {
        this.editorPanel.removeAll();
        JComponent selectedProbabilityGeneratorEditor = ProbabilityEditorFactory.getView(this.probability.getSelectedProbabilityGenerator());
        if (selectedProbabilityGeneratorEditor != null) {
            this.editorPanel.add((Component)selectedProbabilityGeneratorEditor, "Center");
            this.currentProbabilityGeneratorEditor = (DurationSettable)((Object)selectedProbabilityGeneratorEditor);
            this.currentProbabilityGeneratorEditor.setDuration(this.duration);
        }
        this.revalidate();
    }
}

