/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.BlueSystem;
import blue.components.EditEnabledCheckBox;
import blue.orchestra.BlueSynthBuilder;
import blue.orchestra.editor.blueSynthBuilder.BSBCompletionProvider;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.undo.TabWatchingUndoableEditGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class BSBCodeEditor
extends JComponent {
    BSBCompletionProvider completionProvider = new BSBCompletionProvider();
    MimeTypeEditorComponent codePane = new MimeTypeEditorComponent("text/x-blue-synth-builder");
    MimeTypeEditorComponent alwaysOnCodePane = new MimeTypeEditorComponent("text/x-blue-synth-builder");
    MimeTypeEditorComponent globalOrcEditPane = new MimeTypeEditorComponent("text/x-blue-synth-builder");
    MimeTypeEditorComponent globalScoEditPane = new MimeTypeEditorComponent("text/x-csound-sco");
    BlueSynthBuilder bsb = new BlueSynthBuilder();
    EditEnabledCheckBox editBox = new EditEnabledCheckBox();
    UndoManager undo = new UndoRedo.Manager();

    public BSBCodeEditor() {
        this.editBox.addEditModeListener(isEditing -> {
            this.codePane.getJEditorPane().setEnabled(isEditing);
            this.alwaysOnCodePane.getJEditorPane().setEnabled(isEditing);
            this.globalOrcEditPane.getJEditorPane().setEnabled(isEditing);
            this.globalScoEditPane.getJEditorPane().setEnabled(isEditing);
            if (this.bsb != null) {
                this.bsb.setEditEnabled(isEditing);
            }
        });
        this.codePane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (BSBCodeEditor.this.bsb != null) {
                    BSBCodeEditor.this.bsb.setInstrumentText(BSBCodeEditor.this.codePane.getText());
                }
            }
        });
        this.alwaysOnCodePane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (BSBCodeEditor.this.bsb != null) {
                    BSBCodeEditor.this.bsb.setAlwaysOnInstrumentText(BSBCodeEditor.this.alwaysOnCodePane.getText());
                }
            }
        });
        this.globalOrcEditPane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (BSBCodeEditor.this.bsb != null) {
                    BSBCodeEditor.this.bsb.setGlobalOrc(BSBCodeEditor.this.globalOrcEditPane.getText());
                }
            }
        });
        this.globalScoEditPane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (BSBCodeEditor.this.bsb != null) {
                    BSBCodeEditor.this.bsb.setGlobalSco(BSBCodeEditor.this.globalScoEditPane.getText());
                }
            }
        });
        JPanel topBar = new JPanel(new BorderLayout());
        topBar.add((Component)this.editBox, "East");
        JTabbedPane tabs = new JTabbedPane(3);
        tabs.add(BlueSystem.getString((String)"instrument.instrumentText"), (Component)this.codePane);
        tabs.add("Always-On Instrument Text", (Component)this.alwaysOnCodePane);
        tabs.add(BlueSystem.getString((String)"global.orchestra"), (Component)this.globalOrcEditPane);
        tabs.add(BlueSystem.getString((String)"global.score"), (Component)this.globalScoEditPane);
        this.setLayout(new BorderLayout());
        this.add((Component)topBar, "North");
        this.add((Component)tabs, "Center");
        new TabWatchingUndoableEditGenerator(tabs, this.undo);
        this.codePane.getDocument().addUndoableEditListener(this.undo);
        this.alwaysOnCodePane.getDocument().addUndoableEditListener(this.undo);
        this.globalOrcEditPane.getDocument().addUndoableEditListener(this.undo);
        this.globalScoEditPane.getDocument().addUndoableEditListener(this.undo);
        this.codePane.setUndoManager(this.undo);
        this.alwaysOnCodePane.setUndoManager(this.undo);
        this.globalOrcEditPane.setUndoManager(this.undo);
        this.globalScoEditPane.setUndoManager(this.undo);
        this.undo.setLimit(1000);
        this.codePane.getJEditorPane().putClientProperty("bsb-completion-provider", this.completionProvider);
        this.alwaysOnCodePane.getJEditorPane().putClientProperty("bsb-completion-provider", this.completionProvider);
        this.globalOrcEditPane.getJEditorPane().putClientProperty("bsb-completion-provider", this.completionProvider);
        this.initActions();
        this.codePane.getJEditorPane().setEnabled(false);
        this.alwaysOnCodePane.getJEditorPane().setEnabled(false);
        this.globalOrcEditPane.getJEditorPane().setEnabled(false);
        this.globalScoEditPane.getJEditorPane().setEnabled(false);
    }

    private void initActions() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(69, BlueSystem.getMenuShortcutKey()), "switchEditMode");
        this.getActionMap().put("switchEditMode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BSBCodeEditor.this.editBox.doClick();
            }
        });
    }

    private void setupCodeCompleteAction(JComponent component, KeyStroke codeCompleteKeyStroke, Action codeCompleteAction) {
        InputMap inputMap = component.getInputMap(0);
        ActionMap actionMap = component.getActionMap();
        inputMap.put(codeCompleteKeyStroke, "bsbCodeComplete");
        actionMap.put("bsbCodeComplete", codeCompleteAction);
    }

    public void editBlueSynthBuilder(BlueSynthBuilder bsb) {
        this.bsb = null;
        this.codePane.setText(bsb.getInstrumentText());
        this.codePane.getJEditorPane().setCaretPosition(0);
        this.alwaysOnCodePane.setText(bsb.getAlwaysOnInstrumentText());
        this.alwaysOnCodePane.getJEditorPane().setCaretPosition(0);
        this.globalOrcEditPane.setText(bsb.getGlobalOrc());
        this.globalOrcEditPane.getJEditorPane().setCaretPosition(0);
        this.globalScoEditPane.setText(bsb.getGlobalSco());
        this.globalScoEditPane.getJEditorPane().setCaretPosition(0);
        if (bsb != null) {
            if (this.editBox.isSelected() != bsb.isEditEnabled()) {
                this.editBox.doClick();
            }
            this.completionProvider.setBSBGraphicInterface(bsb.getGraphicInterface());
        } else {
            this.editBox.setSelected(false);
            this.completionProvider.setBSBGraphicInterface(null);
        }
        this.bsb = bsb;
        this.undo.discardAllEdits();
    }
}

