/*
 * Decompiled with CFR 0.152.
 */
package blue.projects.actions;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.settings.GeneralSettings;
import blue.ui.utilities.FileChooserManager;
import blue.utility.CSDUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class ImportOrcScoAction
implements ActionListener {
    FileChooser.ExtensionFilter orcFilter = new FileChooser.ExtensionFilter("Csound ORC File (*.orc)", new String[]{"*.orc"});
    FileChooser.ExtensionFilter scoFilter = new FileChooser.ExtensionFilter("Csound SCO File (*.sco)", new String[]{"*.sco"});

    public ImportOrcScoAction() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled((Object)this.orcFilter, false);
        fcm.addFilter((Object)this.orcFilter, this.orcFilter);
        fcm.setSelectedFile((Object)this.orcFilter, GeneralSettings.getInstance().getDefaultDirectory());
        fcm.setDialogTitle((Object)this.scoFilter, "Select ORC File");
        fcm.setMultiSelectionEnabled((Object)this.scoFilter, false);
        fcm.addFilter((Object)this.scoFilter, this.scoFilter);
        fcm.setSelectedFile((Object)this.scoFilter, GeneralSettings.getInstance().getDefaultDirectory());
        fcm.setDialogTitle((Object)this.scoFilter, "Select SCO File");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(this::importOrcSco);
    }

    public void importOrcSco() {
        BlueData tempData;
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        List rValue = FileChooserManager.getDefault().showOpenDialog((Object)this.orcFilter, (Component)mainWindow);
        if (rValue.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.actionCancelled"));
            return;
        }
        File orcFile = (File)rValue.get(0);
        rValue = FileChooserManager.getDefault().showOpenDialog((Object)this.scoFilter, (Component)mainWindow);
        if (rValue.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.actionCancelled"));
            return;
        }
        File scoFile = (File)rValue.get(0);
        Object[] values = new Object[]{BlueSystem.getString((String)"csd.import1"), BlueSystem.getString((String)"csd.import2"), BlueSystem.getString((String)"csd.import3")};
        Object selectedValue = JOptionPane.showInputDialog(mainWindow, BlueSystem.getString((String)"csd.importMethod.message"), BlueSystem.getString((String)"csd.importMethod.title"), 1, null, values, values[0]);
        if (selectedValue == null) {
            return;
        }
        int modeType = 0;
        for (int i = 0; i < values.length; ++i) {
            if (selectedValue != values[i]) continue;
            modeType = i;
            break;
        }
        if ((tempData = CSDUtility.convertOrcScoToBlue((File)orcFile, (File)scoFile, (int)modeType)) != null) {
            BlueProject project = new BlueProject(tempData, null);
            BlueProjectManager.getInstance().setCurrentProject(project);
        } else {
            JOptionPane.showMessageDialog(mainWindow, BlueSystem.getString((String)"message.file.couldNotImport"), BlueSystem.getString((String)"message.error"), 0);
        }
    }
}

