/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.jfx.BlueFX;
import blue.jfx.binding.ChoiceBinder;
import blue.jfx.binding.DoubleBinder;
import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.FadeType;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;

public class AudioClipEditorController
implements Initializable {
    @FXML
    private TextField audioFileText;
    @FXML
    private TextField startTimeText;
    @FXML
    private TextField durationText;
    @FXML
    private TextField fileStartText;
    @FXML
    private TextField audioDurationText;
    @FXML
    private TextField fadeInText;
    @FXML
    private TextField fadeOutText;
    @FXML
    private ChoiceBox<FadeType> fadeInChoiceBox;
    @FXML
    private ChoiceBox<FadeType> fadeOutChoiceBox;
    private AudioClip audioClip;
    DoubleBinder<AudioClip> startTimeBinder;
    DoubleBinder<AudioClip> durationBinder;
    DoubleBinder<AudioClip> fileStartBinder;
    DoubleBinder<AudioClip> fadeInBinder;
    DoubleBinder<AudioClip> fadeOutBinder;
    ChoiceBinder<FadeType> fadeInTypeBinder;
    ChoiceBinder<FadeType> fadeOutTypeBinder;

    public void initialize(URL url, ResourceBundle rb) {
        this.startTimeBinder = new DoubleBinder(this.startTimeText, (ac, val) -> {
            if (val < 0.0) {
                return null;
            }
            return val;
        });
        this.durationBinder = new DoubleBinder(this.durationText, (ac, val) -> {
            if (val <= 0.0 || val > ac.getAudioDuration()) {
                return null;
            }
            return val;
        });
        this.fileStartBinder = new DoubleBinder(this.fileStartText, (ac, val) -> {
            if (val < 0.0 || val >= ac.getAudioDuration()) {
                return null;
            }
            return val;
        });
        this.fadeInBinder = new DoubleBinder(this.fadeInText, (ac, val) -> {
            if (val < 0.0 || val >= ac.getDuration() - ac.getFadeOut()) {
                return null;
            }
            return val;
        });
        this.fadeOutBinder = new DoubleBinder(this.fadeOutText, (ac, val) -> {
            if (val < 0.0 || val >= ac.getDuration() - ac.getFadeIn()) {
                return null;
            }
            return val;
        });
        this.fadeInChoiceBox.getItems().addAll((Object[])FadeType.values());
        this.fadeOutChoiceBox.getItems().addAll((Object[])FadeType.values());
        this.fadeInTypeBinder = new ChoiceBinder(this.fadeInChoiceBox);
        this.fadeOutTypeBinder = new ChoiceBinder(this.fadeOutChoiceBox);
    }

    public void setAudioClip(AudioClip audioClip) {
        BlueFX.runOnFXThread(() -> {
            this.audioDurationText.setText(Double.toString(audioClip.getAudioDuration()));
            this.audioFileText.setText(audioClip.getAudioFile().getAbsolutePath());
            this.startTimeBinder.setDoubleProperty((Object)audioClip, audioClip.startProperty());
            this.durationBinder.setDoubleProperty((Object)audioClip, audioClip.durationProperty());
            this.fileStartBinder.setDoubleProperty((Object)audioClip, audioClip.fileStartTimeProperty());
            this.fadeInBinder.setDoubleProperty((Object)audioClip, audioClip.fadeInProperty());
            this.fadeOutBinder.setDoubleProperty((Object)audioClip, audioClip.fadeOutProperty());
            this.fadeInTypeBinder.setObjectProperty(audioClip.fadeInTypeProperty());
            this.fadeOutTypeBinder.setObjectProperty(audioClip.fadeOutTypeProperty());
        });
    }
}

