/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import sunlabs.brazil.util.regexp.Regexp;
import tcl.lang.BackSlashResult;
import tcl.lang.FindElemResult;
import tcl.lang.FormatCmd;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', 'd', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    static final int DEFAULT_PRECISION = 12;
    static int precision = 12;

    private Util() {
    }

    static StrtoulResult strtoul(String s, int start, int base) {
        int digit;
        int i;
        long result = 0L;
        boolean anyDigits = false;
        int len = s.length();
        for (i = start; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i >= len) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (base == 0) {
            char c = s.charAt(i);
            if (c == '0') {
                if (i < len - 1 && ((c = s.charAt(++i)) == 'x' || c == 'X')) {
                    ++i;
                    base = 16;
                }
                if (base == 0) {
                    anyDigits = true;
                    base = 8;
                }
            } else {
                base = 10;
            }
        } else if (base == 16 && i < len - 2 && s.charAt(i) == '0' && s.charAt(i + 1) == 'x') {
            i += 2;
        }
        long max = 0x100000000L / (long)base;
        boolean overflowed = false;
        while (i < len && (digit = s.charAt(i) - 48) >= 0 && digit <= 74 && (digit = cvtIn[digit]) < base) {
            if (result > max) {
                overflowed = true;
            }
            result = result * (long)base + (long)digit;
            anyDigits = true;
            ++i;
        }
        if (!anyDigits) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (overflowed) {
            return new StrtoulResult(0L, i, -2);
        }
        return new StrtoulResult(result, i, 0);
    }

    static int getInt(Interp interp, String s) throws TclException {
        boolean sign;
        int i;
        int len = s.length();
        for (i = 0; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i >= len) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        StrtoulResult res = Util.strtoul(s, i, 0);
        if (res.errno < 0) {
            if (res.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
        }
        if (res.index < len) {
            for (i = res.index; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
            }
        }
        if (sign) {
            return (int)(-res.value);
        }
        return (int)res.value;
    }

    static final int getIntForIndex(Interp interp, TclObject tobj, int endValue) throws TclException {
        if (tobj.getInternalRep() instanceof TclInteger) {
            return TclInteger.get((Interp)interp, (TclObject)tobj);
        }
        String bytes = tobj.toString();
        int length = bytes.length();
        String intforindex_error = "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes);
        if (!"end".regionMatches(0, bytes, 0, length > 3 ? 3 : length)) {
            int offset;
            try {
                offset = TclInteger.get(null, (TclObject)tobj);
            }
            catch (TclException e) {
                throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes));
            }
            return offset;
        }
        if (length <= 3) {
            return endValue;
        }
        if (bytes.charAt(3) == '-') {
            int offset = Util.getInt(interp, bytes.substring(3));
            return endValue + offset;
        }
        throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes.substring(3)));
    }

    static final String checkBadOctal(Interp interp, String value) {
        int p;
        int len = value.length();
        for (p = 0; p < len && Character.isWhitespace(value.charAt(p)); ++p) {
        }
        if (p < len && (value.charAt(p) == '+' || value.charAt(p) == '-')) {
            ++p;
        }
        if (p < len && value.charAt(p) == '0') {
            while (p < len && Character.isDigit(value.charAt(p))) {
                ++p;
            }
            while (p < len && Character.isWhitespace(value.charAt(p))) {
                ++p;
            }
            if (p >= len && interp != null) {
                return " (looks like invalid octal number)";
            }
        }
        return "";
    }

    static StrtodResult strtod(String s, int start) {
        int i;
        boolean sign = false;
        int len = s.length();
        for (i = start; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i >= len) {
            return new StrtodResult(0.0, 0, -3);
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        boolean maybeZero = true;
        int decPt = -1;
        int mantSize = 0;
        while (true) {
            if (!Character.isDigit(c = Util.CharAt(s, i, len))) {
                if (c != '.' || decPt >= 0) break;
                decPt = mantSize;
            }
            if (c != '0' && c != '.') {
                maybeZero = false;
            }
            ++i;
            ++mantSize;
        }
        if (Util.CharAt(s, i, len) == 'E' || Util.CharAt(s, i, len) == 'e') {
            if (Util.CharAt(s, ++i, len) == '-') {
                ++i;
            } else if (Util.CharAt(s, i, len) == '+') {
                ++i;
            }
            while (Character.isDigit(Util.CharAt(s, i, len))) {
                ++i;
            }
        }
        s = s.substring(start, i);
        double result = 0.0;
        try {
            result = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return new StrtodResult(0.0, 0, -3);
        }
        if (result == Double.NEGATIVE_INFINITY || result == Double.POSITIVE_INFINITY || result == 0.0 && !maybeZero) {
            return new StrtodResult(result, i, -4);
        }
        if (result == Double.NaN) {
            return new StrtodResult(0.0, 0, -3);
        }
        return new StrtodResult(result, i, 0);
    }

    static final char CharAt(String s, int index, int len) {
        if (index >= 0 && index < len) {
            return s.charAt(index);
        }
        return '\u0000';
    }

    static double getDouble(Interp interp, String s) throws TclException {
        boolean sign;
        int i;
        int len = s.length();
        for (i = 0; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i >= len) {
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        StrtodResult res = Util.strtod(s, i);
        if (res.errno != 0) {
            if (res.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        if (res.index < len) {
            for (i = res.index; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
            }
        }
        if (sign) {
            return -res.value;
        }
        return res.value;
    }

    static String concat(int from, int to, TclObject[] argv) {
        if (from > argv.length) {
            return "";
        }
        if (to <= argv.length) {
            to = argv.length - 1;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = from; i <= to; ++i) {
            String str = Util.TrimLeft(argv[i].toString());
            if ((str = Util.TrimRight(str)).length() == 0) continue;
            sbuf.append(str);
            if (i >= to) continue;
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    public static final boolean stringMatch(String str, String pat) {
        char[] strArr = str.toCharArray();
        char[] patArr = pat.toCharArray();
        int strLen = str.length();
        int patLen = pat.length();
        int pIndex = 0;
        int sIndex = 0;
        boolean incrIndex = false;
        while (true) {
            if (incrIndex) {
                ++pIndex;
                ++sIndex;
                incrIndex = false;
            }
            if (pIndex == patLen) {
                return sIndex == strLen;
            }
            if (sIndex == strLen && patArr[pIndex] != '*') {
                return false;
            }
            if (patArr[pIndex] == '*') {
                if (++pIndex == patLen) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(str.substring(sIndex), pat.substring(pIndex))) {
                        return true;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            if (patArr[pIndex] == '?') {
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '[') {
                ++pIndex;
                while (true) {
                    if (pIndex == patLen || patArr[pIndex] == ']') {
                        return false;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    char ch1 = patArr[pIndex];
                    char strch = strArr[sIndex];
                    if (pIndex + 1 != patLen && patArr[pIndex + 1] == '-') {
                        if ((pIndex += 2) == patLen) {
                            return false;
                        }
                        char ch2 = patArr[pIndex];
                        if (ch1 <= strch && ch2 >= strch || ch1 >= strch && ch2 <= strch) {
                            break;
                        }
                    } else if (ch1 == strch) break;
                    ++pIndex;
                }
                ++pIndex;
                while (pIndex != patLen && patArr[pIndex] != ']') {
                    ++pIndex;
                }
                if (pIndex == patLen) {
                    --pIndex;
                }
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '\\' && ++pIndex == patLen) {
                return false;
            }
            if (sIndex == strLen || patArr[pIndex] != strArr[sIndex]) {
                return false;
            }
            incrIndex = true;
        }
    }

    static String toTitle(String str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(Character.toTitleCase(str.charAt(0)));
        buf.append(str.substring(1).toLowerCase());
        return buf.toString();
    }

    static final boolean regExpMatch(Interp interp, String string, TclObject pattern) throws TclException {
        Regexp r = TclRegexp.compile(interp, pattern, false);
        return r.match(string, (String[])null);
    }

    static final void appendElement(Interp interp, StringBuffer sbuf, String s) throws TclException {
        if (sbuf.length() > 0) {
            sbuf.append(' ');
        }
        int flags = Util.scanElement(interp, s);
        sbuf.append(Util.convertElement(s, flags));
    }

    static final FindElemResult findElement(Interp interp, String s, int i, int len) throws TclException {
        int openBraces = 0;
        boolean inQuotes = false;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char c = s.charAt(i);
        if (c == '{') {
            openBraces = 1;
            ++i;
        } else if (c == '\"') {
            inQuotes = true;
            ++i;
        }
        StringBuffer sbuf = new StringBuffer();
        block8: while (true) {
            if (i >= len) {
                if (openBraces != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (inQuotes) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                return new FindElemResult(i, sbuf.toString());
            }
            c = s.charAt(i);
            switch (c) {
                case '{': {
                    if (openBraces != 0) {
                        ++openBraces;
                    }
                    sbuf.append(c);
                    ++i;
                    continue block8;
                }
                case '}': {
                    if (openBraces == 1) {
                        int errEnd;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            return new FindElemResult(i + 1, sbuf.toString());
                        }
                        for (errEnd = i + 1; errEnd < len && !Character.isWhitespace(s.charAt(errEnd)); ++errEnd) {
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    if (openBraces != 0) {
                        --openBraces;
                    }
                    sbuf.append(c);
                    ++i;
                    continue block8;
                }
                case '\\': {
                    BackSlashResult bs = Interp.backslash(s, i, len);
                    if (openBraces > 0) {
                        sbuf.append(s.substring(i, bs.nextIndex));
                    } else {
                        sbuf.append(bs.c);
                    }
                    i = bs.nextIndex;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (openBraces == 0 && !inQuotes) {
                        return new FindElemResult(i + 1, sbuf.toString());
                    }
                    sbuf.append(c);
                    ++i;
                    continue block8;
                }
                case '\"': {
                    if (inQuotes) {
                        int errEnd;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            return new FindElemResult(i + 1, sbuf.toString());
                        }
                        for (errEnd = i + 1; errEnd < len && !Character.isWhitespace(s.charAt(errEnd)); ++errEnd) {
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    sbuf.append(c);
                    ++i;
                    continue block8;
                }
            }
            sbuf.append(c);
            ++i;
        }
    }

    static int scanElement(Interp interp, String string) throws TclException {
        char c;
        boolean debug = false;
        int nestingLevel = 0;
        int flags = 0;
        int i = 0;
        int len = string.length();
        if (len == 0) {
            string = String.valueOf('\u0000');
        }
        if ((c = string.charAt(i)) == '{' || c == '\"' || c == '\u0000') {
            flags |= 2;
        }
        while (i < len) {
            c = string.charAt(i);
            switch (c) {
                case '{': {
                    ++nestingLevel;
                    break;
                }
                case '}': {
                    if (--nestingLevel >= 0) break;
                    flags |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 2;
                    break;
                }
                case '\\': {
                    if (i >= len - 1 || string.charAt(i + 1) == '\n') {
                        flags = 5;
                        break;
                    }
                    BackSlashResult bs = Interp.backslash(string, i, len);
                    i = bs.nextIndex - 1;
                    flags |= 2;
                }
            }
            ++i;
        }
        if (nestingLevel != 0) {
            flags = 5;
        }
        return flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String convertElement(String s, int flags) {
        int i = 0;
        int len = s.length();
        if (s == null) return "{}";
        if (s.length() == 0) return "{}";
        if (s.charAt(0) == '\u0000') {
            return "{}";
        }
        StringBuffer sbuf = new StringBuffer();
        if ((flags & 2) != 0 && (flags & 1) == 0) {
            sbuf.append('{');
            i = 0;
            while (true) {
                if (i >= len) {
                    sbuf.append('}');
                    return sbuf.toString();
                }
                sbuf.append(s.charAt(i));
                ++i;
            }
        }
        char c = s.charAt(0);
        if (c == '{') {
            sbuf.append('\\');
            sbuf.append('{');
            ++i;
            flags |= 4;
        }
        while (i < len) {
            block15: {
                c = s.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        sbuf.append('\\');
                        break;
                    }
                    case '{': 
                    case '}': {
                        if ((flags & 4) == 0) break;
                        sbuf.append('\\');
                        break;
                    }
                    case '\f': {
                        sbuf.append('\\');
                        sbuf.append('f');
                        break block15;
                    }
                    case '\n': {
                        sbuf.append('\\');
                        sbuf.append('n');
                        break block15;
                    }
                    case '\r': {
                        sbuf.append('\\');
                        sbuf.append('r');
                        break block15;
                    }
                    case '\t': {
                        sbuf.append('\\');
                        sbuf.append('t');
                        break block15;
                    }
                    case '\u000b': {
                        sbuf.append('\\');
                        sbuf.append('v');
                        break block15;
                    }
                }
                sbuf.append(c);
            }
            ++i;
        }
        return sbuf.toString();
    }

    static String TrimLeft(String str, String pattern) {
        int i;
        int strLen = str.length();
        int patLen = pattern.length();
        boolean done = false;
        for (i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            done = true;
            for (int j = 0; j < patLen; ++j) {
                if (c != pattern.charAt(j)) continue;
                done = false;
                break;
            }
            if (done) break;
        }
        return str.substring(i, strLen);
    }

    static String TrimLeft(String str) {
        return Util.TrimLeft(str, " \n\t\r");
    }

    static String TrimRight(String str, String pattern) {
        char c;
        int last;
        char[] strArray = str.toCharArray();
        for (last = str.length() - 1; last >= 0 && pattern.indexOf(c = strArray[last]) != -1; --last) {
        }
        return str.substring(0, last + 1);
    }

    static String TrimRight(String str) {
        return Util.TrimRight(str, " \n\t\r");
    }

    static boolean getBoolean(Interp interp, String string) throws TclException {
        String s = string.toLowerCase();
        if (s.length() > 0) {
            if ("yes".startsWith(s)) {
                return true;
            }
            if ("no".startsWith(s)) {
                return false;
            }
            if ("true".startsWith(s)) {
                return true;
            }
            if ("false".startsWith(s)) {
                return false;
            }
            if ("on".startsWith(s) && s.length() > 1) {
                return true;
            }
            if ("off".startsWith(s) && s.length() > 1) {
                return false;
            }
            if (s.equals("0")) {
                return false;
            }
            if (s.equals("1")) {
                return true;
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    static final boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac") && !os.endsWith("x");
    }

    static final boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    static String printDouble(double number) {
        String s = FormatCmd.toString(number, precision, 10);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) != '.' && !Character.isLetter(s.charAt(i))) continue;
            return s;
        }
        return s.concat(".0");
    }

    static String tryGetSystemProperty(String propName, String defautlValue) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return defautlValue;
        }
    }
}

