/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import sunlabs.brazil.util.regexp.Regexp;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.RegsubCmd;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclString;

class RegexpCmd
implements Command {
    private static final String[] validOpts = new String[]{"-indices", "-nocase", "--"};
    private static final int OPT_INDICES = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    RegexpCmd() {
    }

    static void init(Interp interp) {
        interp.createCommand("regexp", new RegexpCmd());
        interp.createCommand("regsub", new RegsubCmd());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean nocase = false;
        boolean indices = false;
        try {
            int[] args;
            int i = 1;
            block9: while (argv[i].toString().startsWith("-")) {
                int index = TclIndex.get((Interp)interp, (TclObject)argv[i], (String[])validOpts, (String)"switch", (int)0);
                ++i;
                switch (index) {
                    case 0: {
                        indices = true;
                        break;
                    }
                    case 1: {
                        nocase = true;
                        break;
                    }
                    case 2: {
                        break block9;
                    }
                }
            }
            TclObject exp = argv[i++];
            String string = argv[i++].toString();
            int matches = argv.length - i;
            Regexp r = TclRegexp.compile(interp, exp, nocase);
            boolean matched = r.match(string, args = new int[matches * 2]);
            if (matched) {
                int match = 0;
                while (i < argv.length) {
                    TclObject obj;
                    int start = args[match++];
                    int end = args[match++];
                    if (indices) {
                        if (end >= 0) {
                            --end;
                        }
                        obj = TclList.newInstance();
                        TclList.append(interp, obj, TclInteger.newInstance((int)start));
                        TclList.append(interp, obj, TclInteger.newInstance((int)end));
                    } else {
                        String range = start >= 0 ? string.substring(start, end) : "";
                        obj = TclString.newInstance((String)range);
                    }
                    try {
                        interp.setVar(argv[i].toString(), obj, 0);
                    }
                    catch (TclException e) {
                        throw new TclException(interp, "couldn't set variable \"" + argv[i] + "\"");
                    }
                    ++i;
                }
            }
            interp.setResult(matched);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
    }
}

