/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.services.render.DiskRenderServiceFactory;
import blue.settings.GeneralSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DiskRenderSettings {
    public static final String[] FILE_FORMATS = new String[]{"WAV", "AIFF", "AU", "RAW", "IRCAM", "W64", "WAVEX", "SD2", "FLAC"};
    public static final String[] SAMPLE_FORMATS = new String[]{"ALAW", "ULAW", "SCHAR", "UCHAR", "FLOAT", "SHORT", "LONG", "24BIT"};
    private static final String PREFIX = "diskRender.";
    private static final String ADVANCED_SETTINGS = "advancedSettings";
    private static final String BENCHMARK_ENABLED = "benchmarkEnabled";
    private static final String CSOUND_EXECUTABLE = "csoundExecutable";
    private static final String DEFAULT_KSMPS = "defaultKsmps";
    private static final String DEFAULT_NCHNLS = "defaultNchnls";
    private static final String DEFAULT_SR = "defaultSr";
    private static final String DITHER_OUTPUT = "ditherOutput";
    private static final String EXTERNAL_PLAY_COMMAND = "externalPlayCommand";
    private static final String EXTERNAL_PLAY_COMMAND_ENABLED = "externalPlayCommandEnabled";
    private static final String EXTERNAL_OPEN_COMMAND = "externalOpenCommand";
    private static final String FILE_FORMAT = "fileFormat";
    private static final String FILE_FORMAT_ENABLED = "fileFormatEnabled";
    private static final String NOTE_AMPS_ENABLED = "noteAmpsEnabled";
    private static final String OUT_OF_RANGE_ENABLED = "outOfRangeEnabled";
    private static final String REWRITE_HEADER = "rewriteHeader";
    private static final String SAMPLE_FORMAT = "sampleFormat";
    private static final String SAMPLE_FORMAT_ENABLED = "sampleFormatEnabled";
    private static final String SAVE_PEAK_INFORMATION = "savePeakInformation";
    private static final String WARNINGS_ENABLED = "warningsEnabled";
    private static final String DISPLAYS_DISABLED = "displaysDisabled";
    private static final String USE_ZERO_DBFS = "useZeroDbFS";
    private static final String ZERO_DB_FS = "zeroDbFS";
    private static final String DISK_RENDER_SERVICE_FACTORY = "diskRenderServiceFactory";
    public String csoundExecutable = "csound";
    public String fileFormat = "WAV";
    public String sampleFormat = "SHORT";
    public String defaultSr = "44100";
    public String defaultKsmps = "1";
    public String defaultNchnls = "2";
    public boolean noteAmpsEnabled = true;
    public boolean outOfRangeEnabled = true;
    public boolean warningsEnabled = true;
    public boolean benchmarkEnabled = true;
    public boolean fileFormatEnabled = true;
    public boolean sampleFormatEnabled = true;
    public boolean savePeakInformation = true;
    public boolean ditherOutput = false;
    public boolean rewriteHeader = false;
    public boolean externalPlayCommandEnabled = false;
    public String externalPlayCommand = "command $outfile";
    public String externalOpenCommand = "command $outfile";
    public boolean displaysDisabled = true;
    public String advancedSettings = "";
    public boolean useZeroDbFS = true;
    public String zeroDbFS = "1";
    public DiskRenderServiceFactory renderServiceFactory = null;
    private static DiskRenderSettings instance = null;

    private DiskRenderSettings() {
    }

    private static DiskRenderServiceFactory findDiskRenderService(String renderServiceName) {
        DiskRenderServiceFactory[] services = DiskRenderSettings.getAvailableDiskRenderServices();
        DiskRenderServiceFactory foundService = null;
        if (renderServiceName == null || renderServiceName.isEmpty()) {
            foundService = services[0];
        } else {
            for (DiskRenderServiceFactory service : services) {
                if (!service.toString().equals(renderServiceName)) continue;
                foundService = service;
                break;
            }
            if (foundService == null) {
                foundService = services[0];
            }
        }
        return foundService;
    }

    public static DiskRenderSettings getInstance() {
        if (instance == null) {
            instance = new DiskRenderSettings();
            Preferences prefs = NbPreferences.forModule(DiskRenderSettings.class);
            String osName = System.getProperty("os.name");
            String csoundExecutableDefault = osName.toLowerCase().contains("mac") ? "/usr/local/bin/csound" : "csound";
            DiskRenderSettings.instance.csoundExecutable = prefs.get("diskRender.csoundExecutable", csoundExecutableDefault);
            DiskRenderSettings.instance.defaultSr = prefs.get("diskRender.defaultSr", "44100");
            DiskRenderSettings.instance.defaultKsmps = prefs.get("diskRender.defaultKsmps", "1");
            DiskRenderSettings.instance.defaultNchnls = prefs.get("diskRender.defaultNchnls", "2");
            DiskRenderSettings.instance.externalPlayCommandEnabled = prefs.getBoolean("diskRender.externalPlayCommandEnabled", false);
            DiskRenderSettings.instance.externalPlayCommand = prefs.get("diskRender.externalPlayCommand", "command $outfile");
            DiskRenderSettings.instance.externalOpenCommand = prefs.get("diskRender.externalOpenCommand", "command $outfile");
            DiskRenderSettings.instance.fileFormatEnabled = prefs.getBoolean("diskRender.fileFormatEnabled", true);
            DiskRenderSettings.instance.fileFormat = prefs.get("diskRender.fileFormat", "WAV");
            DiskRenderSettings.instance.sampleFormatEnabled = prefs.getBoolean("diskRender.sampleFormatEnabled", true);
            DiskRenderSettings.instance.sampleFormat = prefs.get("diskRender.sampleFormat", "SHORT");
            DiskRenderSettings.instance.savePeakInformation = prefs.getBoolean("diskRender.savePeakInformation", true);
            DiskRenderSettings.instance.ditherOutput = prefs.getBoolean("diskRender.ditherOutput", false);
            DiskRenderSettings.instance.rewriteHeader = prefs.getBoolean("diskRender.rewriteHeader", true);
            DiskRenderSettings.instance.noteAmpsEnabled = prefs.getBoolean("diskRender.noteAmpsEnabled", true);
            DiskRenderSettings.instance.outOfRangeEnabled = prefs.getBoolean("diskRender.outOfRangeEnabled", true);
            DiskRenderSettings.instance.warningsEnabled = prefs.getBoolean("diskRender.warningsEnabled", true);
            DiskRenderSettings.instance.benchmarkEnabled = prefs.getBoolean("diskRender.benchmarkEnabled", true);
            DiskRenderSettings.instance.displaysDisabled = prefs.getBoolean("diskRender.displaysDisabled", true);
            DiskRenderSettings.instance.advancedSettings = prefs.get("diskRender.advancedSettings", "");
            DiskRenderSettings.instance.useZeroDbFS = prefs.getBoolean("diskRender.useZeroDbFS", true);
            DiskRenderSettings.instance.zeroDbFS = prefs.get("diskRender.zeroDbFS", "1");
            String renderServiceName = prefs.get("diskRender.diskRenderServiceFactory", null);
            DiskRenderSettings.instance.renderServiceFactory = DiskRenderSettings.findDiskRenderService(renderServiceName);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(DiskRenderSettings.class);
        prefs.put("diskRender.csoundExecutable", this.csoundExecutable);
        prefs.put("diskRender.defaultSr", this.defaultSr);
        prefs.put("diskRender.defaultKsmps", this.defaultKsmps);
        prefs.put("diskRender.defaultNchnls", this.defaultNchnls);
        prefs.putBoolean("diskRender.externalPlayCommandEnabled", this.externalPlayCommandEnabled);
        prefs.put("diskRender.externalPlayCommand", this.externalPlayCommand);
        prefs.put("diskRender.externalOpenCommand", this.externalOpenCommand);
        prefs.putBoolean("diskRender.fileFormatEnabled", this.fileFormatEnabled);
        prefs.put("diskRender.fileFormat", this.fileFormat);
        prefs.putBoolean("diskRender.sampleFormatEnabled", this.sampleFormatEnabled);
        prefs.put("diskRender.sampleFormat", this.sampleFormat);
        prefs.putBoolean("diskRender.savePeakInformation", this.savePeakInformation);
        prefs.putBoolean("diskRender.ditherOutput", this.ditherOutput);
        prefs.putBoolean("diskRender.rewriteHeader", this.rewriteHeader);
        prefs.putBoolean("diskRender.noteAmpsEnabled", this.noteAmpsEnabled);
        prefs.putBoolean("diskRender.warningsEnabled", this.warningsEnabled);
        prefs.putBoolean("diskRender.outOfRangeEnabled", this.outOfRangeEnabled);
        prefs.putBoolean("diskRender.benchmarkEnabled", this.benchmarkEnabled);
        prefs.putBoolean("diskRender.displaysDisabled", this.displaysDisabled);
        prefs.put("diskRender.advancedSettings", this.advancedSettings);
        prefs.putBoolean("diskRender.useZeroDbFS", this.useZeroDbFS);
        prefs.put("diskRender.zeroDbFS", this.zeroDbFS);
        prefs.put("diskRender.diskRenderServiceFactory", this.renderServiceFactory.toString());
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getCommandLine() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.csoundExecutable).append(" ");
        if (!GeneralSettings.getInstance().isMessageColorsEnabled()) {
            buffer.append("-+msg_color=false ");
        }
        if (this.fileFormatEnabled) {
            buffer.append("--format=").append(this.fileFormat.toLowerCase());
            if (this.sampleFormatEnabled) {
                buffer.append(":").append(this.sampleFormat.toLowerCase());
            }
            buffer.append(" ");
        }
        if (!this.savePeakInformation) {
            buffer.append("-K ");
        }
        if (this.ditherOutput) {
            buffer.append("-Z ");
        }
        if (this.rewriteHeader) {
            buffer.append("-R ");
        }
        if (this.displaysDisabled) {
            buffer.append("-d ");
        }
        return buffer.toString();
    }

    public static DiskRenderServiceFactory[] getAvailableDiskRenderServices() {
        Collection services = Lookup.getDefault().lookupAll(DiskRenderServiceFactory.class);
        ArrayList<DiskRenderServiceFactory> results = new ArrayList<DiskRenderServiceFactory>();
        for (DiskRenderServiceFactory factory : services) {
            if (!factory.isAvailable()) continue;
            results.add(factory);
        }
        return results.toArray(new DiskRenderServiceFactory[0]);
    }
}

