/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure;

import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import com.kunstmusik.clojureengine.ClojureEngine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptException;

public class BlueClojureEngine
implements PropertyChangeListener {
    private static AtomicInteger NS_COUNTER = new AtomicInteger(0);
    private BlueProject currentProject = null;
    private HashMap<BlueProject, ClojureEngine> engines = new HashMap();

    public static BlueClojureEngine getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void reinitialize() {
        if (this.currentProject == null) {
            return;
        }
        File f = BlueSystem.getCurrentProjectDirectory();
        File projScriptDir = null;
        File userScriptDir = new File(BlueSystem.getUserScriptDir() + File.separator + "clojure");
        if (f != null) {
            projScriptDir = new File(f.getAbsolutePath() + File.separator + "script" + File.separator + "clojure");
        }
        ClojureEngine engine = new ClojureEngine("user" + NS_COUNTER.getAndIncrement(), userScriptDir, projScriptDir);
        this.engines.put(this.currentProject, engine);
    }

    public String getCurrentNameSpace() {
        if (this.currentProject == null) {
            return "ERROR - No Engine Available";
        }
        if (this.engines.get(this.currentProject) == null) {
            this.reinitialize();
        }
        return this.engines.get(this.currentProject).getNamespace();
    }

    public String processScript(String code, Map<String, ? extends Object> values, String returnVariableName) throws ScriptException {
        Object retObj;
        String retVal;
        if (this.engines.get(this.currentProject) == null) {
            this.reinitialize();
        }
        ClojureEngine engine = this.engines.get(this.currentProject);
        if (values != null) {
            engine.intern(values);
        }
        String string = retVal = (retObj = engine.eval(code)) != null ? retObj.toString() : "";
        if (returnVariableName != null) {
            try {
                Object obj = engine.eval("(str " + returnVariableName + ")");
                if (obj != null) {
                    retVal = obj.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return retVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentProject".equals(evt.getPropertyName())) {
            if (this.currentProject != null && !BlueProjectManager.getInstance().isProjectStillOpen(this.currentProject) && this.engines.containsKey(this.currentProject)) {
                this.engines.remove(this.currentProject);
            }
            this.currentProject = (BlueProject)evt.getNewValue();
        }
    }

    private static class LazyHolder {
        private static final BlueClojureEngine INSTANCE = new BlueClojureEngine();

        private LazyHolder() {
        }

        static {
            BlueProjectManager.getInstance().addPropertyChangeListener((PropertyChangeListener)INSTANCE);
            INSTANCE.currentProject = BlueProjectManager.getInstance().getCurrentProject();
        }
    }
}

