/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.soundObject.tracker.TrackList;
import blue.utility.ScoreUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TrackerObject
extends AbstractSoundObject {
    private TrackList tracks = new TrackList();
    private double duration = 4.0;
    private int timeBehavior = 0;
    double repeatPoint = -1.0;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private transient Vector listeners = null;

    public TrackerObject() {
        this.setName("Tracker");
    }

    public TrackerObject(TrackerObject to) {
        super(to);
        this.tracks = new TrackList(to.tracks);
        this.duration = to.duration;
        this.timeBehavior = to.timeBehavior;
        this.repeatPoint = to.repeatPoint;
        this.npc = new NoteProcessorChain(to.npc);
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl;
        try {
            nl = this.tracks.generateNotes();
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint(), this.getSteps());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    @Override
    public double getObjectiveDuration() {
        return this.duration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement(XMLUtilities.writeDouble("duration", this.getDuration()));
        retVal.addElement(this.tracks.saveAsXML());
        return retVal;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        TrackerObject retVal = new TrackerObject();
        SoundObjectUtilities.initBasicFromXML(data, retVal);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "duration": {
                    retVal.setDuration(XMLUtilities.readDouble(node));
                    break;
                }
                case "trackList": {
                    retVal.setTracks(TrackList.loadFromXML(node));
                }
            }
        }
        return retVal;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public int getSteps() {
        return this.tracks.getSteps();
    }

    public void setSteps(int steps) {
        int oldSteps = this.tracks.getSteps();
        this.tracks.setSteps(steps);
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "steps", new Integer(oldSteps), new Integer(steps));
        this.firePropertyChangeEvent(pce);
    }

    public TrackList getTracks() {
        return this.tracks;
    }

    public void setTracks(TrackList tracks) {
        this.tracks = tracks;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    @Override
    public TrackerObject deepCopy() {
        return new TrackerObject(this);
    }
}

