/*
 * Decompiled with CFR 0.152.
 */
package blue.score;

import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class TimeState {
    public static final int DISPLAY_TIME = 0;
    public static final int DISPLAY_NUMBER = 1;
    private transient Vector<PropertyChangeListener> listeners = null;
    private int pixelSecond = 64;
    private boolean snapEnabled = false;
    private double snapValue = 1.0;
    private int timeDisplay = 0;
    private int timeUnit = 5;

    public TimeState() {
    }

    public TimeState(TimeState timeState) {
        this.pixelSecond = timeState.pixelSecond;
        this.snapEnabled = timeState.snapEnabled;
        this.snapValue = timeState.snapValue;
        this.timeDisplay = timeState.timeDisplay;
        this.timeUnit = timeState.timeUnit;
    }

    public int getPixelSecond() {
        return this.pixelSecond;
    }

    public void setPixelSecond(int pixelSecond) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "pixelSecond", new Integer(this.pixelSecond), new Integer(pixelSecond));
        this.pixelSecond = pixelSecond;
        this.firePropertyChangeEvent(pce);
    }

    public void lowerPixelSecond() {
        int temp = this.getPixelSecond();
        if (temp <= 2) {
            return;
        }
        this.setPixelSecond(temp -= 2);
    }

    public void raisePixelSecond() {
        int temp = this.getPixelSecond() + 2;
        this.setPixelSecond(temp);
    }

    public boolean isSnapEnabled() {
        return this.snapEnabled;
    }

    public void setSnapEnabled(boolean snapEnabled) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "snapEnabled", this.snapEnabled, snapEnabled);
        this.snapEnabled = snapEnabled;
        this.firePropertyChangeEvent(pce);
    }

    public double getSnapValue() {
        return this.snapValue;
    }

    public void setSnapValue(double snapValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "snapValue", new Double(this.snapValue), new Double(snapValue));
        this.snapValue = snapValue;
        this.firePropertyChangeEvent(pce);
    }

    public int getTimeDisplay() {
        return this.timeDisplay;
    }

    public void setTimeDisplay(int timeDisplay) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "timeDisplay", new Integer(this.timeDisplay), new Integer(timeDisplay));
        this.timeDisplay = timeDisplay;
        this.firePropertyChangeEvent(pce);
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int timeUnit) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "timeUnit", new Integer(this.timeUnit), new Integer(timeUnit));
        this.timeUnit = timeUnit;
        this.firePropertyChangeEvent(pce);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    public static TimeState loadFromXML(Element data) {
        TimeState timeState = new TimeState();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element e = nodes.next();
            String nodeName = e.getName();
            String nodeText = e.getTextString();
            switch (nodeName) {
                case "pixelSecond": {
                    timeState.pixelSecond = Integer.parseInt(nodeText);
                    break;
                }
                case "snapEnabled": {
                    timeState.snapEnabled = Boolean.valueOf(nodeText);
                    break;
                }
                case "snapValue": {
                    timeState.snapValue = Double.parseDouble(nodeText);
                    break;
                }
                case "timeDisplay": {
                    timeState.timeDisplay = Integer.parseInt(nodeText);
                    break;
                }
                case "timeUnit": {
                    timeState.timeUnit = Integer.parseInt(nodeText);
                }
            }
        }
        return timeState;
    }

    public Element saveAsXML() {
        Element retVal = new Element("timeState");
        retVal.addElement(XMLUtilities.writeInt("pixelSecond", this.pixelSecond));
        retVal.addElement(XMLUtilities.writeBoolean("snapEnabled", this.snapEnabled));
        retVal.addElement(XMLUtilities.writeDouble("snapValue", this.snapValue));
        retVal.addElement(XMLUtilities.writeInt("timeDisplay", this.timeDisplay));
        retVal.addElement(XMLUtilities.writeInt("timeUnit", this.timeUnit));
        return retVal;
    }
}

