/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import electric.xml.Element;
import electric.xml.Elements;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BSBTextField
extends BSBObject {
    private StringProperty value = new SimpleStringProperty("");
    private IntegerProperty textFieldWidth = new SimpleIntegerProperty(100){

        protected void invalidated() {
            if (this.get() < 5) {
                this.set(5);
            }
        }
    };

    public BSBTextField() {
    }

    public BSBTextField(BSBTextField tf) {
        super(tf);
        this.setValue(tf.getValue());
        this.setTextFieldWidth(tf.getTextFieldWidth());
    }

    public final void setValue(String val) {
        this.value.set((Object)val);
    }

    public final String getValue() {
        return (String)this.value.get();
    }

    public final StringProperty valueProperty() {
        return this.value;
    }

    public final void setTextFieldWidth(int value) {
        this.textFieldWidth.set(value);
    }

    public final int getTextFieldWidth() {
        return this.textFieldWidth.get();
    }

    public final IntegerProperty textFieldWidthProperty() {
        return this.textFieldWidth;
    }

    @Override
    public String getPresetValue() {
        return this.getValue();
    }

    public static BSBObject loadFromXML(Element data) {
        BSBTextField bsbText = new BSBTextField();
        BSBTextField.initBasicFromXML(data, bsbText);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "value": {
                    bsbText.setValue(node.getTextString());
                    if (bsbText.getValue() != null) break;
                    bsbText.setValue("");
                    break;
                }
                case "textFieldWidth": {
                    bsbText.setTextFieldWidth(Integer.parseInt(node.getTextString()));
                }
            }
        }
        return bsbText;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBTextField.getBasicXML(this);
        retVal.addElement("value").setText(this.getValue());
        retVal.addElement("textFieldWidth").setText(Integer.toString(this.getTextFieldWidth()));
        return retVal;
    }

    @Override
    public void setPresetValue(String val) {
        this.setValue(val);
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        compilationUnit.addReplacementValue(this.getObjectName(), this.getValue());
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBTextField(this);
    }
}

