/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBDropdownItem;
import blue.orchestra.blueSynthBuilder.BSBDropdownItemList;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.orchestra.blueSynthBuilder.SwingHTMLFontParser;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.text.Font;

public class BSBDropdown
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    private BSBDropdownItemList dropdownItems;
    private IntegerProperty selectedIndex = new SimpleIntegerProperty(0);
    private BooleanProperty randomizable = new SimpleBooleanProperty(true);
    IntegerProperty fontSize = new SimpleIntegerProperty(12){

        protected void invalidated() {
            if (this.get() < 8) {
                this.set(8);
            } else if (this.get() > 36) {
                this.set(36);
            }
        }
    };
    private ListChangeListener<BSBDropdownItem> lcl = c -> {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null) {
            param.setMax(Math.max(0, this.dropdownItems.size() - 1), true);
        }
    };
    private ChangeListener<Number> indexListener = (obs, old, newVal) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName())) != null && !p.isAutomationEnabled()) {
            p.setValue(newVal.intValue());
        }
    };

    public BSBDropdown() {
        this.dropdownItems = new BSBDropdownItemList();
        this.dropdownItems.addListener(this.lcl);
        this.selectedIndex.addListener(this.indexListener);
    }

    public BSBDropdown(BSBDropdown dropdown) {
        super(dropdown);
        this.dropdownItems = new BSBDropdownItemList(dropdown.dropdownItems);
        this.dropdownItems.addListener(this.lcl);
        this.setSelectedIndex(dropdown.getSelectedIndex());
        this.setRandomizable(dropdown.isRandomizable());
        this.selectedIndex.addListener(this.indexListener);
    }

    public static BSBObject loadFromXML(Element data) {
        BSBDropdown dropDown = new BSBDropdown();
        BSBDropdown.initBasicFromXML(data, dropDown);
        int version = 1;
        String versionStr = data.getAttributeValue("version");
        if (versionStr != null) {
            version = Integer.parseInt(versionStr);
        }
        Elements nodes = data.getElements();
        int selectedIndex = 0;
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "bsbDropdownItemList": {
                    dropDown.dropdownItems = BSBDropdownItemList.loadFromXML(node);
                    break;
                }
                case "selectedIndex": {
                    selectedIndex = Integer.parseInt(node.getTextString());
                    break;
                }
                case "randomizable": {
                    dropDown.setRandomizable(XMLUtilities.readBoolean(node));
                    break;
                }
                case "fontSize": {
                    dropDown.setFontSize(XMLUtilities.readInt(node));
                }
            }
        }
        dropDown.setSelectedIndex(selectedIndex);
        if (version < 2) {
            int fontSize = 12;
            Iterator iterator = dropDown.dropdownItems.iterator();
            while (iterator.hasNext()) {
                BSBDropdownItem dropdownItem = (BSBDropdownItem)iterator.next();
                String str = dropdownItem.getName();
                Font f = SwingHTMLFontParser.parseFont(str);
                if (f.getSize() != 12.0) {
                    fontSize = (int)f.getSize();
                }
                dropdownItem.setName(SwingHTMLFontParser.stripHTML(str));
            }
            if (fontSize != 12) {
                dropDown.setFontSize(fontSize);
            }
        }
        return dropDown;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBDropdown.getBasicXML(this);
        retVal.setAttribute("version", "2");
        retVal.addElement("selectedIndex").setText(Integer.toString(this.getSelectedIndex()));
        retVal.addElement("fontSize").setText(Integer.toString(this.getFontSize()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        Element items = retVal.addElement("bsbDropdownItemList");
        Iterator iterator = this.dropdownItems.iterator();
        while (iterator.hasNext()) {
            BSBDropdownItem item = (BSBDropdownItem)iterator.next();
            items.addElement(item.saveAsXML());
        }
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null && param.getCompilationVarName() != null) {
            compilationUnit.addReplacementValue(this.getObjectName(), param.getCompilationVarName());
            return;
        }
        if (this.dropdownItems.size() == 0) {
            compilationUnit.addReplacementValue(this.getObjectName(), "0");
        } else {
            String replaceVal;
            if (this.isAutomationAllowed()) {
                replaceVal = "" + this.getSelectedIndex();
            } else {
                BSBDropdownItem item = (BSBDropdownItem)this.dropdownItems.get(this.getSelectedIndex());
                replaceVal = item.getValue();
            }
            compilationUnit.addReplacementValue(this.getObjectName(), replaceVal);
        }
    }

    public BSBDropdownItemList getBSBDropdownItemList() {
        return this.dropdownItems;
    }

    public void setBSBDropdownItemList(BSBDropdownItemList list) {
        this.dropdownItems = list;
    }

    public ObservableList<BSBDropdownItem> dropdownItemsProperty() {
        return this.dropdownItems;
    }

    public final int getSelectedIndex() {
        return this.selectedIndex.get();
    }

    public final void setSelectedIndex(int selectedIndex) {
        int tempIndex = selectedIndex;
        if (tempIndex >= this.dropdownItems.size()) {
            tempIndex = this.dropdownItems.size() - 1;
        }
        if (tempIndex < 0) {
            tempIndex = 0;
        }
        this.selectedIndex.set(tempIndex);
    }

    public final IntegerProperty selectedIndexProperty() {
        return this.selectedIndex;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
        this.fireBSBObjectChanged();
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    public final void setFontSize(int size) {
        this.fontSize.set(size);
    }

    public final int getFontSize() {
        return this.fontSize.get();
    }

    public final IntegerProperty fontSizeProperty() {
        return this.fontSize;
    }

    @Override
    public String getPresetValue() {
        BSBDropdownItem item = (BSBDropdownItem)this.dropdownItems.get(this.getSelectedIndex());
        return "id:" + item.getUniqueId();
    }

    @Override
    public void setPresetValue(String val) {
        if (val.startsWith("id:")) {
            String uniqueId = val.substring(3);
            int index = this.getIndexOfItemByUniqueId(uniqueId);
            if (index >= 0) {
                this.setSelectedIndex(index);
            }
        } else {
            this.setSelectedIndex(Integer.parseInt(val));
        }
    }

    protected int getIndexOfItemByUniqueId(String uniqueId) {
        if (uniqueId == null) {
            return -1;
        }
        for (int i = 0; i < this.dropdownItems.size(); ++i) {
            BSBDropdownItem item = (BSBDropdownItem)this.dropdownItems.get(i);
            if (!uniqueId.equals(item.getUniqueId())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void randomize() {
        int randomIndex;
        if (this.isRandomizable() && (randomIndex = (int)(Math.random() * (double)this.dropdownItems.size())) != this.getSelectedIndex()) {
            int oldIndex = this.getSelectedIndex();
            this.setSelectedIndex(randomIndex);
        }
    }

    @Override
    protected void initializeParameters() {
        if (this.parameters == null) {
            return;
        }
        if (!this.automationAllowed && this.getObjectName() != null && this.getObjectName().length() != 0) {
            Parameter param = this.parameters.getParameter(this.getObjectName());
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(this.getObjectName());
                return;
            }
        }
        if (this.getObjectName() == null || this.getObjectName().trim().length() == 0) {
            return;
        }
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            parameter.setMax(this.dropdownItems.size() - 1, true);
            parameter.addParameterListener(this);
            if (!parameter.isAutomationEnabled()) {
                parameter.setValue(this.getSelectedIndex());
            }
            return;
        }
        Parameter param = new Parameter();
        param.setValue(this.getSelectedIndex());
        param.setMax(this.dropdownItems.size() - 1, true);
        param.setMin(0.0, true);
        param.setName(this.getObjectName());
        param.setResolution(new BigDecimal(1));
        param.addParameterListener(this);
        this.parameters.add(param);
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (this.getObjectName() != null && this.getObjectName().length() != 0) {
                this.parameters.removeParameter(this.getObjectName());
            }
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void lineDataChanged(Parameter param) {
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double val = parameter.getLine().getValue(time);
            this.setSelectedIndex((int)Math.round(val));
        }
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBDropdown(this);
    }
}

