/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.Collections;

public class RotateProcessor
implements NoteProcessor {
    int noteIndex = 1;

    public RotateProcessor() {
    }

    public RotateProcessor(RotateProcessor rp) {
        this.noteIndex = rp.noteIndex;
    }

    public String toString() {
        return "[rotate]";
    }

    public String getNoteIndex() {
        return Integer.toString(this.noteIndex);
    }

    public void setNoteIndex(String noteIndex) {
        this.noteIndex = Integer.parseInt(noteIndex);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        if (in.size() < 2 || this.noteIndex == 1) {
            return;
        }
        in.sort();
        Note lastNote = (Note)in.get(in.size() - 1);
        double startTime = lastNote.getStartTime() + lastNote.getSubjectiveDuration();
        int index = this.noteIndex;
        index = index > 0 ? --index : in.size() + index;
        if (index > in.size()) {
            throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.rotateIndex"));
        }
        Collections.rotate(in, -index);
        for (index = in.size() - index; index < in.size(); ++index) {
            Note n = (Note)in.get(index);
            n.setStartTime(n.getStartTime() + startTime);
        }
        ScoreUtilities.normalizeNoteList(in);
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 5 " + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        RotateProcessor rlp = new RotateProcessor();
        rlp.setNoteIndex("-3");
        try {
            rlp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        RotateProcessor rlp = new RotateProcessor();
        rlp.setNoteIndex(data.getElement("noteIndex").getTextString());
        return rlp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("noteIndex").setText(this.getNoteIndex());
        return retVal;
    }

    @Override
    public RotateProcessor deepCopy() {
        return new RotateProcessor(this);
    }
}

