/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.mixer.Channel;
import blue.util.ObservableArrayList;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ChannelList
extends ObservableArrayList<Channel> {
    private String association = null;
    private String listName = "";
    private boolean listNameEditSupported = true;
    private transient PropertyChangeSupport propSupport = null;

    public ChannelList() {
    }

    public ChannelList(ChannelList chanList) {
        this.association = chanList.association;
        this.listName = chanList.listName;
        this.listNameEditSupported = chanList.listNameEditSupported;
        for (Channel chan : chanList) {
            this.add(new Channel(chan));
        }
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        if (!this.listNameEditSupported) {
            throw new RuntimeException("Error: Attempted to edit Channel List name for group that does not support it.");
        }
        String oldListName = this.listName;
        this.listName = listName;
        if (this.propSupport != null) {
            this.propSupport.firePropertyChange("listName", oldListName, listName);
        }
    }

    public boolean isListNameEditSupported() {
        return this.listNameEditSupported;
    }

    public void setListNameEditSupported(boolean listNameEditSupported) {
        this.listNameEditSupported = listNameEditSupported;
    }

    public static ChannelList loadFromXML(Element data) throws Exception {
        String listName;
        ChannelList channels = new ChannelList();
        Elements nodes = data.getElements();
        String associationVal = data.getAttributeValue("association");
        if (associationVal != null && !"null".equals(associationVal)) {
            channels.setAssociation(data.getAttributeValue("association"));
        }
        if ((listName = data.getAttributeValue("listName")) != null && !"null".equals(listName)) {
            channels.setListName(listName);
        }
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("channel")) continue;
            channels.add(Channel.loadFromXML(node));
        }
        return channels;
    }

    public Element saveAsXML() {
        Element retVal = new Element("channelList");
        if (this.association != null) {
            retVal.setAttribute("association", this.association);
        }
        if (this.listName != null) {
            retVal.setAttribute("listName", this.listName);
        }
        for (Channel channel : this) {
            retVal.addElement(channel.saveAsXML());
        }
        return retVal;
    }

    public String getAssociation() {
        return this.association;
    }

    public void setAssociation(String association) {
        this.association = association;
    }

    public void checkOrCreate(String channelName) {
        for (Channel channel : this) {
            if (!channel.getName().equals(channelName)) continue;
            return;
        }
        Channel channel = new Channel();
        channel.setName(channelName);
        this.add(channel);
    }

    public void sort() {
        Collections.sort(this);
    }

    public int indexByName(Object anItem) {
        for (int i = 0; i < this.size(); ++i) {
            Channel channel = (Channel)this.get(i);
            if (!channel.getName().equals(anItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isChannelNameInUse(String channelName) {
        for (Channel c : this) {
            if (!c.getName().equals(channelName)) continue;
            return true;
        }
        return false;
    }

    public int indexOfChannel(String channelName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Channel)this.get(i)).getName().equals(channelName)) continue;
            return i;
        }
        return -1;
    }

    public void clearChannelsNotInList(ArrayList ids) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Channel channel = (Channel)iter.next();
            if (ids.contains(channel.getName())) continue;
            iter.remove();
        }
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((int)11, (int)41, (Object)this, (boolean)false);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(pcl);
        }
    }

    public static Channel findChannelByAssociation(ChannelList list, String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        for (Channel channel : list) {
            if (!uniqueId.equals(channel.getAssociation())) continue;
            return channel;
        }
        return null;
    }
}

