/*
 * Decompiled with CFR 0.152.
 */
package blue.automation;

import blue.automation.Parameter;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Comparator;
import java.util.Iterator;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.transformation.SortedList;
import org.apache.commons.lang3.text.StrBuilder;

public class ParameterList
extends SimpleListProperty<Parameter> {
    private static final Comparator<Parameter> COMPARATOR = new Comparator<Parameter>(){

        @Override
        public int compare(Parameter o1, Parameter o2) {
            Parameter para1 = o1;
            Parameter para2 = o2;
            return para1.getName().compareToIgnoreCase(para2.getName());
        }
    };

    public ParameterList() {
        super(FXCollections.observableArrayList());
    }

    public ParameterList(ParameterList pl) {
        super(FXCollections.observableArrayList());
        Iterator iterator = pl.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            this.add(new Parameter(param));
        }
    }

    public SortedList<Parameter> sorted() {
        return super.sorted(COMPARATOR);
    }

    public Parameter getParameter(String objectName) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            if (!param.getName().equals(objectName)) continue;
            return param;
        }
        return null;
    }

    public void removeParameter(String parameterName) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            if (!param.getName().equals(parameterName)) continue;
            this.remove(param);
            break;
        }
    }

    public void clearCompilationVarNames() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            param.setCompilationVarName(null);
        }
    }

    public Element saveAsXML() {
        Element retVal = new Element("parameterList");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            retVal.addElement(param.saveAsXML());
        }
        return retVal;
    }

    public static ParameterList loadFromXML(Element data) {
        ParameterList retVal = new ParameterList();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("parameter")) continue;
            retVal.add(Parameter.loadFromXML(node));
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StrBuilder buffer = new StrBuilder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            buffer.append(param.toString()).append("\n");
        }
        return buffer.toString();
    }
}

