/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.BlueSystem;
import blue.orchestra.Instrument;
import blue.orchestra.InstrumentCategory;
import blue.utility.ListUtil;
import electric.xml.Element;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class InstrumentLibrary
implements TreeModel {
    InstrumentCategory rootInstrumentCategory = new InstrumentCategory();
    transient Vector<TreeModelListener> listeners = new Vector();

    public InstrumentLibrary() {
        this.rootInstrumentCategory.setRoot(true);
        this.rootInstrumentCategory.setCategoryName(BlueSystem.getString("instrument.instrumentLibrary"));
    }

    public InstrumentCategory getRootInstrumentCategory() {
        return this.rootInstrumentCategory;
    }

    public void setRootInstrumentCategory(InstrumentCategory rootInstrumentCategory) {
        this.rootInstrumentCategory = rootInstrumentCategory;
    }

    public void addInstrument(InstrumentCategory parent, Instrument instr) {
        this.addInstrument(parent, -1, instr);
    }

    public void addInstrument(InstrumentCategory parent, int insertIndex, Instrument instr) {
        if (insertIndex < 0 || insertIndex >= parent.getInstruments().size()) {
            parent.addInstrument(instr);
        } else {
            parent.addInstrument(insertIndex, instr);
        }
        int index = this.getIndexOfChild(parent, instr);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{instr};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(instr), childIndices, children);
        this.fireNodesInserted(e);
    }

    private Object[] getPathForObject(Object obj) {
        Vector v = new Vector();
        this.getPathForObject(this.getRootInstrumentCategory(), obj, v);
        Collections.reverse(v);
        return v.toArray();
    }

    private Object getPathForObject(InstrumentCategory current, Object obj, Vector v) {
        if (current == obj) {
            return v;
        }
        if (ListUtil.containsByRef(current.getInstruments(), obj)) {
            v.add(current);
            return v;
        }
        for (InstrumentCategory cat : current.getSubCategories()) {
            Object pathObj = this.getPathForObject(cat, obj, v);
            if (pathObj == null) continue;
            v.add(current);
            return v;
        }
        return null;
    }

    public void addCategory(InstrumentCategory parent, InstrumentCategory cat) {
        parent.addInstrumentCategory(cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void removeInstrument(Instrument instr) {
        InstrumentCategory parent = this.findParent(this.rootInstrumentCategory, instr);
        int index = this.getIndexOfChild(parent, instr);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{instr};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(instr), childIndices, children);
        this.rootInstrumentCategory.removeInstrument(instr);
        this.fireNodesRemoved(e);
    }

    public void removeCategory(InstrumentCategory cat) {
        InstrumentCategory parent = this.findParent(this.rootInstrumentCategory, cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.rootInstrumentCategory.removeInstrumentCategory(cat);
        this.fireNodesRemoved(e);
    }

    public static InstrumentLibrary loadFromXML(Element data) throws Exception {
        InstrumentLibrary iLibrary = new InstrumentLibrary();
        iLibrary.setRootInstrumentCategory(InstrumentCategory.loadFromXML(data.getElement("instrumentCategory")));
        return iLibrary;
    }

    public Element saveAsXML() {
        Element retVal = new Element("instrumentLibrary");
        retVal.addElement(this.rootInstrumentCategory.saveAsXML());
        return retVal;
    }

    public String getInstrumentId(Instrument instr) {
        return this.rootInstrumentCategory.getInstrumentId(instr);
    }

    public Instrument getInstrumentById(String instrId) {
        StringTokenizer st = new StringTokenizer(instrId, ":");
        int[] idArray = new int[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            idArray[count] = Integer.parseInt(st.nextToken());
            ++count;
        }
        return this.getRootInstrumentCategory().getInstrumentById(idArray, 0);
    }

    @Override
    public Object getRoot() {
        return this.getRootInstrumentCategory();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Instrument) {
            return 0;
        }
        if (parent instanceof InstrumentCategory) {
            InstrumentCategory cat = (InstrumentCategory)parent;
            return cat.getSubCategories().size() + cat.getInstruments().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Instrument;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof InstrumentCategory) {
            ((InstrumentCategory)obj).setCategoryName(newValue.toString());
        } else if (obj instanceof Instrument) {
            ((Instrument)obj).setName(newValue.toString());
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.fireNodesChanged(e);
    }

    private void fireNodesChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).treeNodesChanged(e);
        }
    }

    private void fireNodesInserted(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).treeNodesInserted(e);
        }
    }

    private void fireNodesRemoved(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        InstrumentCategory category = (InstrumentCategory)parent;
        if (category == null) {
            return null;
        }
        if (index >= category.getSubCategories().size()) {
            return category.getInstruments().get(index - category.getSubCategories().size());
        }
        return category.getSubCategories().get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        InstrumentCategory category = (InstrumentCategory)parent;
        if (category == null || child == null) {
            return -1;
        }
        int retVal = ListUtil.indexOfByRef(category.getSubCategories(), child);
        if (retVal >= 0) {
            return retVal;
        }
        retVal = ListUtil.indexOfByRef(category.getInstruments(), child);
        if (retVal >= 0) {
            return retVal + category.getSubCategories().size();
        }
        return -1;
    }

    private InstrumentCategory findParent(InstrumentCategory cat, Object obj) {
        if (ListUtil.containsByRef(cat.getInstruments(), obj) || ListUtil.containsByRef(cat.getSubCategories(), obj)) {
            return cat;
        }
        for (InstrumentCategory c : cat.getSubCategories()) {
            InstrumentCategory temp = this.findParent(c, obj);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public void importLibrary(InstrumentLibrary library) {
        InstrumentCategory category = library.getRootInstrumentCategory();
        category.setCategoryName("Imported from Project");
        this.addCategory(this.getRootInstrumentCategory(), category);
    }

    public void importInstrument(Instrument instr) {
        List categories = this.rootInstrumentCategory.getSubCategories();
        for (InstrumentCategory cat : categories) {
            if (!cat.getCategoryName().equals("Imported Instruments")) continue;
            this.addInstrument(cat, instr);
            return;
        }
        InstrumentCategory cat = new InstrumentCategory();
        cat.setCategoryName("Imported Instruments");
        cat.addInstrument(instr);
        this.addCategory(this.rootInstrumentCategory, cat);
    }
}

