/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.Arrangement;
import blue.BlueConstants;
import blue.BlueDataObject;
import blue.GlobalOrcSco;
import blue.InstrumentLibrary;
import blue.LiveData;
import blue.MarkersList;
import blue.ProjectProperties;
import blue.ScratchPadData;
import blue.SoundObjectLibrary;
import blue.Tables;
import blue.data.BlueDataObjectManager;
import blue.midi.MidiInputProcessor;
import blue.mixer.Mixer;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.score.Score;
import blue.udo.OpcodeList;
import blue.upgrades.UpgradeManager;
import blue.utility.TextUtilities;
import blue.utility.UDOUtilities;
import electric.xml.Attribute;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.openide.util.Lookup;

public class BlueData
implements BlueDataObject {
    private final transient Vector listeners = new Vector();
    private String version;
    private Arrangement arrangement;
    private Mixer mixer;
    private ProjectProperties projectProperties;
    private SoundObjectLibrary sObjLib;
    private GlobalOrcSco globalOrcSco;
    private NoteProcessorChainMap noteProcessorChainMap;
    private Tables tableSet;
    private OpcodeList opcodeList;
    private LiveData liveData;
    private Score score;
    private ScratchPadData scratchData;
    private double renderStartTime;
    private double renderEndTime;
    private MarkersList markersList;
    private boolean loopRendering;
    private MidiInputProcessor midiInputProcessor;
    private List<BlueDataObject> pluginData;

    public BlueData() {
        this.arrangement = new Arrangement();
        this.mixer = new Mixer();
        this.projectProperties = new ProjectProperties();
        this.sObjLib = new SoundObjectLibrary();
        this.globalOrcSco = new GlobalOrcSco();
        this.tableSet = new Tables();
        this.opcodeList = new OpcodeList();
        this.noteProcessorChainMap = new NoteProcessorChainMap();
        this.scratchData = new ScratchPadData();
        this.renderStartTime = 0.0;
        this.renderEndTime = -1.0;
        this.markersList = new MarkersList();
        this.loopRendering = false;
        this.score = new Score();
        this.liveData = new LiveData();
        this.midiInputProcessor = new MidiInputProcessor();
        this.pluginData = new ArrayList<BlueDataObject>();
    }

    public BlueData(BlueData data) {
        this.arrangement = new Arrangement(data.getArrangement());
        this.mixer = new Mixer(data.getMixer());
        this.projectProperties = new ProjectProperties(data.getProjectProperties());
        this.sObjLib = new SoundObjectLibrary(data.getSoundObjectLibrary());
        this.globalOrcSco = new GlobalOrcSco(data.getGlobalOrcSco());
        this.tableSet = new Tables(data.getTableSet());
        this.opcodeList = new OpcodeList(data.getOpcodeList());
        this.noteProcessorChainMap = new NoteProcessorChainMap(data.getNoteProcessorChainMap());
        this.scratchData = new ScratchPadData(data.getScratchPadData());
        this.renderStartTime = data.getRenderStartTime();
        this.renderEndTime = data.getRenderEndTime();
        this.markersList = new MarkersList(data.getMarkersList());
        this.loopRendering = data.isLoopRendering();
        this.score = new Score(data.getScore());
        this.liveData = new LiveData(data.getLiveData());
        this.midiInputProcessor = new MidiInputProcessor(data.getMidiInputProcessor());
        this.pluginData = new ArrayList<BlueDataObject>();
        for (BlueDataObject pData : data.getPluginData()) {
            this.pluginData.add((BlueDataObject)pData.deepCopy());
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Score getScore() {
        return this.score;
    }

    public ScratchPadData getScratchPadData() {
        return this.scratchData;
    }

    public void setScratchPadData(ScratchPadData scratchData) {
        this.scratchData = scratchData;
    }

    public LiveData getLiveData() {
        return this.liveData;
    }

    public SoundObjectLibrary getSoundObjectLibrary() {
        return this.sObjLib;
    }

    public void setSoundObjectLibrary(SoundObjectLibrary sObjLib) {
        this.sObjLib = sObjLib;
    }

    public ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(ProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    public GlobalOrcSco getGlobalOrcSco() {
        return this.globalOrcSco;
    }

    public void setGlobalOrcSco(GlobalOrcSco globalOrcSco) {
        this.globalOrcSco = globalOrcSco;
    }

    public Tables getTableSet() {
        return this.tableSet;
    }

    public void setTableSet(Tables tableSet) {
        this.tableSet = tableSet;
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(Arrangement arrangement) {
        this.arrangement = arrangement;
    }

    public List<BlueDataObject> getPluginData() {
        return this.pluginData;
    }

    public static BlueData load(File f) throws Exception {
        String text = TextUtilities.getTextFromFile(f);
        BlueData tempData = null;
        if (text.startsWith("<blueData")) {
            Document d = new Document(text);
            tempData = BlueData.loadFromXML(d.getElement("blueData"));
        }
        return tempData;
    }

    public static BlueData loadFromXML(Element data) throws Exception {
        UpgradeManager.getInstance().performUpgrades(data);
        BlueData blueData = new BlueData();
        HashMap<String, Object> objRefMap = new HashMap<String, Object>();
        Elements nodes = data.getElements();
        Element instrumentLibraryNode = null;
        Element arrangementNode = null;
        Mixer m = null;
        Attribute versionAttribute = data.getAttribute("version");
        if (versionAttribute != null) {
            blueData.setVersion(versionAttribute.getValue());
        }
        BlueDataObjectManager bdoManager = (BlueDataObjectManager)Lookup.getDefault().lookup(BlueDataObjectManager.class);
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "projectProperties": {
                    blueData.projectProperties = ProjectProperties.loadFromXML(node);
                    break;
                }
                case "instrumentLibrary": {
                    instrumentLibraryNode = node;
                    break;
                }
                case "arrangement": {
                    arrangementNode = node;
                    break;
                }
                case "mixer": {
                    m = Mixer.loadFromXML(node);
                    break;
                }
                case "tables": {
                    blueData.tableSet = Tables.loadFromXML(node);
                    break;
                }
                case "soundObjectLibrary": {
                    blueData.sObjLib = SoundObjectLibrary.loadFromXML(node, objRefMap);
                    break;
                }
                case "globalOrcSco": {
                    blueData.globalOrcSco = GlobalOrcSco.loadFromXML(node);
                    break;
                }
                case "udo": {
                    String udoText = node.getTextString();
                    if (udoText == null) {
                        udoText = "";
                    }
                    OpcodeList results = UDOUtilities.parseUDOText(udoText);
                    blueData.setOpcodeList(results);
                    break;
                }
                case "opcodeList": {
                    OpcodeList results = OpcodeList.loadFromXML(node);
                    blueData.setOpcodeList(results);
                    break;
                }
                case "liveData": {
                    blueData.liveData = LiveData.loadFromXML(node, objRefMap);
                    break;
                }
                case "score": {
                    blueData.score = Score.loadFromXML(node, objRefMap);
                    break;
                }
                case "scratchPadData": {
                    blueData.scratchData = ScratchPadData.loadFromXML(node);
                    break;
                }
                case "noteProcessorChainMap": {
                    blueData.noteProcessorChainMap = NoteProcessorChainMap.loadFromXML(node);
                    break;
                }
                case "renderStartTime": {
                    blueData.setRenderStartTime(Double.parseDouble(node.getTextString()));
                    break;
                }
                case "renderEndTime": {
                    blueData.setRenderEndTime(Double.parseDouble(node.getTextString()));
                    break;
                }
                case "markersList": {
                    blueData.setMarkersList(MarkersList.loadFromXML(node));
                    break;
                }
                case "loopRendering": {
                    blueData.setLoopRendering(node.getTextString().equalsIgnoreCase("true"));
                    break;
                }
                case "midiInputProcessor": {
                    blueData.midiInputProcessor = MidiInputProcessor.loadFromXML(node);
                    break;
                }
                case "pluginData": {
                    Elements pluginElems = node.getElements();
                    while (pluginElems.hasMoreElements()) {
                        blueData.pluginData.add(bdoManager.loadFromXML(pluginElems.next()));
                    }
                    break;
                }
            }
        }
        if (instrumentLibraryNode != null) {
            InstrumentLibrary instrumentLibrary = InstrumentLibrary.loadFromXML(instrumentLibraryNode);
            blueData.arrangement = Arrangement.loadFromXML(arrangementNode, instrumentLibrary);
        } else {
            blueData.arrangement = Arrangement.loadFromXML(arrangementNode);
        }
        if (m != null) {
            blueData.mixer = m;
        } else {
            blueData.mixer.setEnabled(false);
        }
        return blueData;
    }

    @Override
    public Element saveAsXML() {
        this.version = BlueConstants.getVersion();
        HashMap<Object, String> objRefMap = new HashMap<Object, String>();
        Element retVal = new Element("blueData");
        retVal.setAttribute("version", BlueConstants.getVersion());
        retVal.addElement(this.projectProperties.saveAsXML());
        retVal.addElement(this.arrangement.saveAsXML());
        retVal.addElement(this.mixer.saveAsXML());
        retVal.addElement(this.tableSet.saveAsXML());
        retVal.addElement(this.sObjLib.saveAsXML(objRefMap));
        retVal.addElement(this.globalOrcSco.saveAsXML());
        retVal.addElement(this.opcodeList.saveAsXML());
        retVal.addElement(this.liveData.saveAsXML(objRefMap));
        retVal.addElement(this.score.saveAsXML(objRefMap));
        retVal.addElement(this.scratchData.saveAsXML());
        retVal.addElement(this.noteProcessorChainMap.saveAsXML());
        retVal.addElement("renderStartTime").setText(Double.toString(this.renderStartTime));
        retVal.addElement("renderEndTime").setText(Double.toString(this.renderEndTime));
        retVal.addElement(this.markersList.saveAsXML());
        retVal.addElement("loopRendering").setText(Boolean.toString(this.loopRendering));
        retVal.addElement(this.midiInputProcessor.saveAsXML());
        Element pluginElems = retVal.addElement("pluginData");
        for (BlueDataObject bdoObj : this.pluginData) {
            pluginElems.addElement(bdoObj.saveAsXML());
        }
        return retVal;
    }

    public NoteProcessorChainMap getNoteProcessorChainMap() {
        return this.noteProcessorChainMap;
    }

    public void setNoteProcessorChainMap(NoteProcessorChainMap noteProcessorChainMap) {
        this.noteProcessorChainMap = noteProcessorChainMap;
    }

    public double getRenderStartTime() {
        return this.renderStartTime;
    }

    public void setRenderStartTime(double renderStartTime) {
        if (renderStartTime == this.renderStartTime) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "renderStartTime", new Double(this.renderStartTime), new Double(renderStartTime));
        this.renderStartTime = renderStartTime;
        this.firePropertyChangeEvent(pce);
        if (renderStartTime >= this.renderEndTime) {
            PropertyChangeEvent pce2 = new PropertyChangeEvent(this, "renderLoopTime", new Double(this.renderEndTime), new Double(-1.0));
            this.renderEndTime = -1.0;
            this.firePropertyChangeEvent(pce2);
        }
    }

    public double getRenderEndTime() {
        return this.renderEndTime;
    }

    public void setRenderEndTime(double renderLoopTime) {
        double newRenderLoopTime = renderLoopTime;
        if (renderLoopTime <= this.renderStartTime) {
            newRenderLoopTime = -1.0;
        }
        if (newRenderLoopTime == this.renderEndTime) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "renderLoopTime", new Double(this.renderEndTime), new Double(newRenderLoopTime));
        this.renderEndTime = newRenderLoopTime;
        this.firePropertyChangeEvent(pce);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public boolean isLoopRendering() {
        return this.loopRendering;
    }

    public void setLoopRendering(boolean loopRendering) {
        boolean oldVal = this.loopRendering;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "loopRendering", oldVal, loopRendering);
        this.loopRendering = loopRendering;
        this.firePropertyChangeEvent(pce);
    }

    public OpcodeList getOpcodeList() {
        return this.opcodeList;
    }

    public void setOpcodeList(OpcodeList opcodeList) {
        this.opcodeList = opcodeList;
    }

    public MarkersList getMarkersList() {
        return this.markersList;
    }

    public void setMarkersList(MarkersList markersList) {
        this.markersList = markersList;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    public void setMixer(Mixer mixer) {
        this.mixer = mixer;
    }

    public MidiInputProcessor getMidiInputProcessor() {
        return this.midiInputProcessor;
    }

    @Override
    public BlueDataObject deepCopy() {
        return new BlueData(this);
    }
}

