/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.core;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.score.ScoreGenerationException;
import blue.score.ScoreObject;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.ScoreObjectLayerGroup;
import blue.score.layers.audio.core.AudioLayer;
import blue.soundObject.NoteList;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AudioLayerGroup
extends ArrayList<AudioLayer>
implements ScoreObjectLayerGroup<AudioLayer> {
    private transient List<LayerGroupListener> layerGroupListeners = null;
    private transient List<PropertyChangeListener> propListeners = null;
    private String name = "Audio Layer Group";
    private String uniqueId;
    private int defaultHeightIndex = 0;

    public AudioLayerGroup() {
        this.uniqueId = new VMID().toString();
    }

    public AudioLayerGroup(AudioLayerGroup alg) {
        this.uniqueId = alg.uniqueId;
        this.name = alg.name;
        this.defaultHeightIndex = alg.defaultHeightIndex;
        for (AudioLayer al : alg) {
            this.add(al.deepCopy());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        String string = this.name = name == null ? "" : name;
        if (!this.name.equals(oldName)) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    public int getDefaultHeightIndex() {
        return this.defaultHeightIndex;
    }

    public void setDefaultHeightIndex(int defaultHeightIndex) {
        this.defaultHeightIndex = defaultHeightIndex;
    }

    public boolean hasSoloLayers() {
        for (AudioLayer layer : this) {
            if (!layer.isSolo()) continue;
            return true;
        }
        return false;
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime, boolean processWithSolo) throws ScoreGenerationException {
        NoteList noteList = new NoteList();
        for (AudioLayer layer : this) {
            if (processWithSolo && !layer.isSolo() || layer.isMuted()) continue;
            noteList.merge(layer.generateForCSD(compileData, startTime, endTime));
        }
        return noteList;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public static AudioLayerGroup loadFromXML(Element data) throws Exception {
        AudioLayerGroup layerGroup = new AudioLayerGroup();
        if (data.getAttribute("name") != null) {
            layerGroup.setName(data.getAttributeValue("name"));
        }
        if (data.getAttribute("uniqueId") != null) {
            layerGroup.uniqueId = data.getAttributeValue("uniqueId");
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "audioLayers": {
                    Elements aLayerNodes = node.getElements();
                    while (aLayerNodes.hasMoreElements()) {
                        layerGroup.add(AudioLayer.loadFromXML(aLayerNodes.next()));
                    }
                    break;
                }
                case "defaultHeightIndex": {
                    int index = Integer.parseInt(node.getTextString());
                    layerGroup.setDefaultHeightIndex(index);
                    break;
                }
            }
        }
        return layerGroup;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element root = new Element("audioLayerGroup");
        root.setAttribute("name", this.name);
        root.setAttribute("uniqueId", this.uniqueId);
        root.addElement(XMLUtilities.writeInt((String)"defaultHeightIndex", (int)this.defaultHeightIndex));
        Element audioLayersNode = root.addElement("audioLayers");
        for (AudioLayer layer : this) {
            audioLayersNode.addElement(layer.saveAsXML());
        }
        return root;
    }

    public AudioLayer newLayerAt(int index) {
        AudioLayer audioLayer = new AudioLayer();
        audioLayer.setHeightIndex(this.defaultHeightIndex);
        int insertIndex = index;
        if (index < 0 || index >= this.size()) {
            insertIndex = this.size();
            this.add(audioLayer);
        } else {
            this.add(index, audioLayer);
        }
        ArrayList<AudioLayer> layers = new ArrayList<AudioLayer>();
        layers.add(audioLayer);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 0, insertIndex, insertIndex, layers);
        this.fireLayerGroupDataEvent(lde);
        return audioLayer;
    }

    public void removeLayers(int startIndex, int endIndex) {
        ArrayList<AudioLayer> layers = new ArrayList<AudioLayer>();
        for (int i = endIndex; i >= startIndex; --i) {
            AudioLayer audioLayer = (AudioLayer)this.get(i);
            audioLayer.clearListeners();
            this.remove(i);
            layers.add(audioLayer);
        }
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 1, startIndex, endIndex, layers);
        this.fireLayerGroupDataEvent(lde);
    }

    public void pushUpLayers(int startIndex, int endIndex) {
        AudioLayer a = (AudioLayer)this.remove(startIndex - 1);
        this.add(endIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 2, startIndex - 1, endIndex);
        this.fireLayerGroupDataEvent(lde);
    }

    public void pushDownLayers(int startIndex, int endIndex) {
        AudioLayer a = (AudioLayer)this.remove(endIndex + 1);
        this.add(startIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 2, -startIndex, -(endIndex + 1));
        this.fireLayerGroupDataEvent(lde);
    }

    public void onLoadComplete() {
    }

    public void addLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners == null) {
            this.layerGroupListeners = new Vector<LayerGroupListener>();
        }
        this.layerGroupListeners.add(l);
    }

    public void removeLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners != null) {
            this.layerGroupListeners.remove(l);
        }
    }

    private void fireLayerGroupDataEvent(LayerGroupDataEvent lde) {
        if (this.layerGroupListeners == null) {
            return;
        }
        for (LayerGroupListener listener : this.layerGroupListeners) {
            listener.layerGroupChanged(lde);
        }
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    public int getTotalHeight() {
        int runningHeight = 0;
        for (AudioLayer layer : this) {
            runningHeight += layer.getHeightIndex() + 1;
        }
        return runningHeight * 22;
    }

    public final double getMaxTime() {
        double max = 0.0;
        for (AudioLayer tempLayer : this) {
            double temp = tempLayer.getMaxTime();
            if (!(temp > max)) continue;
            max = temp;
        }
        return max;
    }

    public int getLayerNumForY(int y) {
        int runningY = 0;
        for (int i = 0; i < this.size(); ++i) {
            AudioLayer layer = (AudioLayer)this.get(i);
            if ((runningY += layer.getAudioLayerHeight()) <= y) continue;
            return i;
        }
        return this.size() - 1;
    }

    public int getLayerNumForScoreObject(ScoreObject scoreObj) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((AudioLayer)this.get(i)).contains(scoreObj)) continue;
            return i;
        }
        return -1;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.propListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.propListeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            this.propListeners = new Vector<PropertyChangeListener>();
        }
        if (this.propListeners.contains(pcl)) {
            return;
        }
        this.propListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            return;
        }
        this.propListeners.remove(pcl);
    }

    public AudioLayerGroup deepCopyLG() {
        return new AudioLayerGroup(this);
    }
}

