/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.openide.awt.HtmlRenderer;

public class BlueViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int BUMP_X_PAD = 3;
    private static final int BUMP_WIDTH = 3;
    private static final int TXT_X_PAD = 11;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private final Dimension prefSize = new Dimension(100, 19);

    public BlueViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BlueViewTabDisplayerUI((TabDisplayer)c);
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 19 : fm.getAscent() + 2 * fm.getDescent() + 2;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        --height;
        y -= 2;
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int txtWidth = width;
        if (this.isSelected(index)) {
            Component buttons = this.getControlButtons();
            if (null != buttons) {
                Dimension buttonsSize = buttons.getPreferredSize();
                txtWidth = width - (buttonsSize.width + 2 + 22);
                buttons.setLocation(x + txtWidth + 22, y + (height - buttonsSize.height) / 2 + 1);
            }
        } else {
            txtWidth = width - 22;
        }
        this.drawBump(g, index, x + 4, y + 6, 3, height - 8);
        Color txtC = Color.WHITE;
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 11), (int)(y + fm.getAscent() + 3), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
        boolean isSelected = this.isSelected(index);
        g.translate(x, y);
        g.setColor(isSelected ? UIManager.getColor("InternalFrame.borderHighlight") : UIManager.getColor("InternalFrame.borderLight"));
        g.drawLine(0, height - 1, width - 2, height - 1);
        g.drawLine(width - 1, height - 1, width - 1, 0);
        g.setColor(UIManager.getColor("InternalFrame.borderShadow"));
        g.drawLine(0, 0, 0, height - 1);
        g.drawLine(1, 0, width - 2, 0);
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        ((Graphics2D)g).setPaint(this.getBackgroundPaint(g, index, x, y, width, --height));
        g.fillRect(x, y, width, height);
    }

    private Paint getBackgroundPaint(Graphics g, int index, int x, int y, int width, int height) {
        boolean selected = this.isSelected(index);
        boolean focused = this.isFocused(index);
        boolean attention = this.isAttention(index);
        Color result = null;
        if (focused && !attention) {
            result = BlueLookAndFeel.getControl();
        } else if (selected && !attention) {
            result = BlueLookAndFeel.getControl();
        } else if (attention) {
            Color ATTENTION_COLOR = new Color(255, 238, 120);
            result = ATTENTION_COLOR;
        } else {
            result = BlueLookAndFeel.getControl().darker();
        }
        return result;
    }

    private void drawBump(Graphics g, int index, int x, int y, int width, int height) {
        Color shadowC;
        Color highlightC;
        Color bodyC;
        if (this.isFocused(index)) {
            bodyC = new Color(210, 220, 243);
            highlightC = bodyC.brighter();
            shadowC = bodyC.darker();
        } else {
            highlightC = UIManager.getColor("InternalFrame.borderLight");
            bodyC = UIManager.getColor("tab_unsel_fill");
            shadowC = UIManager.getColor("InternalFrame.borderShadow");
        }
        int i = 0;
        while (i < width / 3) {
            g.setColor(highlightC);
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x, y, x + 1, y);
            g.setColor(bodyC);
            g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
            g.setColor(shadowC);
            g.drawLine(x + 2, y, x + 2, y + height - 1);
            g.drawLine(x, y + height - 1, x + 1, y + height - 1);
            ++i;
            x += 3;
        }
    }
}

