/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueBorderUtilities;
import blue.plaf.BlueLookAndFeel;
import java.awt.Graphics;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

public class BlueScrollButton
extends MetalScrollButton {
    private boolean isFreeStanding;

    public BlueScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        this.isFreeStanding = freeStanding;
        this.setBackground(BlueLookAndFeel.getControl());
    }

    @Override
    public void paint(Graphics g) {
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        boolean isEnabled = this.getParent().isEnabled();
        ColorUIResource arrowColor = isEnabled ? BlueLookAndFeel.getControlInfo() : BlueLookAndFeel.getControlDisabled();
        boolean isPressed = this.getModel().isPressed();
        int width = this.getWidth();
        int height = this.getHeight();
        int w = width;
        int h = height;
        int arrowHeight = (height + 1) / 4;
        if (isPressed) {
            g.setColor(BlueLookAndFeel.getControlShadow());
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, width, height);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                ++height;
                g.translate(0, -1);
                if (!leftToRight) {
                    ++width;
                    g.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2;
            int startX = w / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
            }
            if (isEnabled) {
                if (isPressed) {
                    BlueBorderUtilities.drawPressed3DBorder(g, 0, 0, w, h);
                } else {
                    BlueBorderUtilities.drawSimple3DBorder(g, 0, 0, w, h);
                }
            } else {
                BlueBorderUtilities.drawDisabledBorder(g, 0, 0, width, height + 1);
            }
            if (!this.isFreeStanding) {
                --height;
                g.translate(0, 1);
                if (!leftToRight) {
                    --width;
                    g.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                ++height;
                if (!leftToRight) {
                    ++width;
                    g.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2 + arrowHeight - 1;
            int startX = w / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
            }
            if (isEnabled) {
                if (isPressed) {
                    BlueBorderUtilities.drawPressed3DBorder(g, 0, 0, w, h);
                } else {
                    BlueBorderUtilities.drawSimple3DBorder(g, 0, 0, w, h);
                }
            } else {
                BlueBorderUtilities.drawDisabledBorder(g, 0, -1, width, height + 1);
            }
            if (!this.isFreeStanding) {
                --height;
                if (!leftToRight) {
                    --width;
                    g.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1;
            int startY = h / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
            }
            if (isEnabled) {
                if (isPressed) {
                    BlueBorderUtilities.drawPressed3DBorder(g, 0, 0, w, h);
                } else {
                    BlueBorderUtilities.drawSimple3DBorder(g, 0, 0, w, h);
                }
            } else {
                BlueBorderUtilities.drawDisabledBorder(g, -1, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
                g.translate(-1, 0);
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2;
            int startY = h / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
            }
            if (isEnabled) {
                if (isPressed) {
                    BlueBorderUtilities.drawPressed3DBorder(g, 0, 0, w, h);
                } else {
                    BlueBorderUtilities.drawSimple3DBorder(g, 0, 0, w, h);
                }
            } else {
                BlueBorderUtilities.drawDisabledBorder(g, 0, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
                g.translate(1, 0);
            }
        }
    }
}

