/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.ceciliaModule;

import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.utility.SoundFileUtilities;
import electric.xml.Element;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class CFileIn
extends CeciliaObject {
    private String fileName = "";
    private int offset = 0;

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getFileName() {
        return this.fileName.replace('\\', '/');
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String processText(String ceciliaText) {
        return null;
    }

    @Override
    public void initialize(String[] tokens) {
        this.setObjectName(tokens[1]);
        for (int i = 2; i < tokens.length; i += 2) {
            if (!tokens[i].equals("-label")) continue;
        }
    }

    public static CeciliaObject loadFromXML(Element data) {
        CFileIn cObj = new CFileIn();
        CeciliaObject.initBasicFromXML(data, cObj);
        cObj.setFileName(data.getTextString("fileName"));
        try {
            cObj.setOffset(Integer.parseInt(data.getTextString("offset")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cObj;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = CeciliaObject.getBasicXML(this);
        retVal.addElement("fileName").setText(this.getFileName());
        retVal.addElement("offset").setText(Integer.toString(this.offset));
        return retVal;
    }

    public boolean isAudioFile() {
        if (this.fileName == null || this.fileName.equals("")) {
            return false;
        }
        File f = new File(this.fileName);
        if (!f.exists()) {
            return false;
        }
        try {
            SoundFileUtilities.getDurationInSeconds((String)this.fileName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnsupportedAudioFileException e) {
            return false;
        }
    }

    public int getMaxTicks() {
        try {
            float dur = SoundFileUtilities.getDurationInSeconds((String)this.fileName);
            return (int)(dur * 10.0f);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public float getDuration() {
        try {
            return SoundFileUtilities.getDurationInSeconds((String)this.getFileName());
        }
        catch (IOException e) {
            return -1.0f;
        }
        catch (UnsupportedAudioFileException e) {
            return -1.0f;
        }
    }

    public int getChannels() {
        try {
            return SoundFileUtilities.getNumberOfChannels((String)this.getFileName());
        }
        catch (IOException e) {
            return -1;
        }
        catch (UnsupportedAudioFileException e) {
            return -1;
        }
    }

    public int getFrames() {
        try {
            return SoundFileUtilities.getNumberOfFrames((String)this.getFileName());
        }
        catch (IOException e) {
            return -1;
        }
        catch (UnsupportedAudioFileException e) {
            return -1;
        }
    }

    public float getSampleRate() {
        try {
            return SoundFileUtilities.getSampleRate((String)this.getFileName());
        }
        catch (IOException e) {
            return -1.0f;
        }
        catch (UnsupportedAudioFileException e) {
            return -1.0f;
        }
    }
}

