/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.GenericViewable;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectUtilities;
import blue.soundObject.ceciliaModule.CeciliaModuleCompilationUnit;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.ceciliaModule.ModuleDefinition;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashMap;
import java.util.Map;

public class CeciliaModule
extends AbstractSoundObject
implements GenericViewable {
    public static final int ORCHESTRA_MONO = 0;
    public static final int ORCHESTRA_STEREO = 1;
    public static final int ORCHESTRA_QUAD = 2;
    private int orchestraVersion;
    private String genSize;
    private ModuleDefinition moduleDefinition;
    private HashMap<String, CeciliaObject> stateData;

    public CeciliaModule() {
        this.setName("CeciliaModule");
        this.stateData = new HashMap();
        this.moduleDefinition = new ModuleDefinition();
        this.orchestraVersion = 1;
        this.genSize = "8192";
    }

    public CeciliaModule(CeciliaModule cm) {
        super((AbstractSoundObject)cm);
        this.orchestraVersion = cm.orchestraVersion;
        this.moduleDefinition = new ModuleDefinition(cm.moduleDefinition);
        this.orchestraVersion = cm.orchestraVersion;
        this.genSize = cm.genSize;
    }

    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    public void setNoteProcessorChain(NoteProcessorChain chain) {
    }

    public int getTimeBehavior() {
        return -1;
    }

    public double getRepeatPoint() {
        return -1.0;
    }

    public void setRepeatPoint(double repeatPoint) {
    }

    public void setTimeBehavior(int timeBehavior) {
    }

    public static void main(String[] args) {
    }

    public ModuleDefinition getModuleDefinition() {
        return this.moduleDefinition;
    }

    public void setModuleDefinition(ModuleDefinition definition) {
        this.moduleDefinition = definition;
    }

    public HashMap getStateData() {
        return this.stateData;
    }

    public void setStateData(HashMap map) {
        this.stateData = map;
    }

    public int getOrchestraVersion() {
        return this.orchestraVersion;
    }

    public void setOrchestraVersion(int i) {
        this.orchestraVersion = i;
    }

    public String getGenSize() {
        return this.genSize;
    }

    public void setGenSize(String string) {
        this.genSize = string;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        CeciliaModule ceciliaModule = new CeciliaModule();
        SoundObjectUtilities.initBasicFromXML((Element)data, (SoundObject)ceciliaModule);
        ceciliaModule.setOrchestraVersion(Integer.parseInt(data.getTextString("orchestraVersion")));
        ceciliaModule.setGenSize(data.getTextString("genSize"));
        ceciliaModule.setModuleDefinition(ModuleDefinition.loadFromXML(data.getElement("moduleDefinition")));
        Elements stateNodes = data.getElements("ceciliaObject");
        while (stateNodes.hasMoreElements()) {
            Element elem = stateNodes.next();
            String key = elem.getAttributeValue("nameKey");
            CeciliaObject cObj = (CeciliaObject)ObjectUtilities.loadFromXML((Element)elem);
            ceciliaModule.stateData.put(key, cObj);
        }
        return ceciliaModule;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML((SoundObject)this);
        retVal.addElement("orchestraVersion").setText(Integer.toString(this.getOrchestraVersion()));
        retVal.addElement("genSize").setText(this.getGenSize());
        retVal.addElement(this.moduleDefinition.saveAsXML());
        for (String key : this.stateData.keySet()) {
            CeciliaObject cObj = this.stateData.get(key);
            Element elem = cObj.saveAsXML();
            elem.setAttribute("nameKey", key);
            retVal.addElement(elem);
        }
        return retVal;
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) {
        CeciliaModuleCompilationUnit compileUnit = new CeciliaModuleCompilationUnit(this);
        return null;
    }

    public CeciliaModule deepCopy() {
        return new CeciliaModule(this);
    }
}

