/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "resize_options.h"

ResizeOptions::ResizeOptions (bool init /* = true */) :
    mOptions (ResizeOptions::OptionNum),
    mNotify (ResizeOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ResizeOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];
    CompOption::Value::Vector list;
    CompOption::Value value;

    // initiate_button
    mOptions[ResizeOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt>Button2");
    mOptions[ResizeOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ResizeOptions::InitiateButton].value ().action ());

    // initiate_key
    mOptions[ResizeOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F8");
    mOptions[ResizeOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ResizeOptions::InitiateKey].value ().action ());

    // mode
    mOptions[ResizeOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[ResizeOptions::Mode].rest ().set (0, 3);
    mOptions[ResizeOptions::Mode].value().set((int) 0);

    // resize_from_center
    mOptions[ResizeOptions::ResizeFromCenter].setName ("resize_from_center", CompOption::TypeBool);
    mOptions[ResizeOptions::ResizeFromCenter].value().set(false);

    // maximize_vertically
    mOptions[ResizeOptions::MaximizeVertically].setName ("maximize_vertically", CompOption::TypeBool);
    mOptions[ResizeOptions::MaximizeVertically].value().set(false);

    // increase_border_contrast
    mOptions[ResizeOptions::IncreaseBorderContrast].setName ("increase_border_contrast", CompOption::TypeBool);
    mOptions[ResizeOptions::IncreaseBorderContrast].value().set(true);

    // use_desktop_average_color
    mOptions[ResizeOptions::UseDesktopAverageColor].setName ("use_desktop_average_color", CompOption::TypeBool);
    mOptions[ResizeOptions::UseDesktopAverageColor].value().set(true);

    // border_color
    mOptions[ResizeOptions::BorderColor].setName ("border_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x2f2f));
    color[1] = MAX (0, MIN (0xffff, 0x2f2f));
    color[2] = MAX (0, MIN (0xffff, 0x4f4f));
    color[3] = MAX (0, MIN (0xffff, 0x9f9f));
    mOptions[ResizeOptions::BorderColor].value().set(color);

    // fill_color
    mOptions[ResizeOptions::FillColor].setName ("fill_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x2f2f));
    color[1] = MAX (0, MIN (0xffff, 0x2f2f));
    color[2] = MAX (0, MIN (0xffff, 0x4f4f));
    color[3] = MAX (0, MIN (0xffff, 0x4f4f));
    mOptions[ResizeOptions::FillColor].value().set(color);

    // disable_blend
    mOptions[ResizeOptions::DisableBlend].setName ("disable_blend", CompOption::TypeBool);
    mOptions[ResizeOptions::DisableBlend].value().set(false);

    // normal_match
    mOptions[ResizeOptions::NormalMatch].setName ("normal_match", CompOption::TypeMatch);
    mOptions[ResizeOptions::NormalMatch].value().set(CompMatch (""));
    mOptions[ResizeOptions::NormalMatch].value().match ().update ();

    // outline_match
    mOptions[ResizeOptions::OutlineMatch].setName ("outline_match", CompOption::TypeMatch);
    mOptions[ResizeOptions::OutlineMatch].value().set(CompMatch (""));
    mOptions[ResizeOptions::OutlineMatch].value().match ().update ();

    // rectangle_match
    mOptions[ResizeOptions::RectangleMatch].setName ("rectangle_match", CompOption::TypeMatch);
    mOptions[ResizeOptions::RectangleMatch].value().set(CompMatch (""));
    mOptions[ResizeOptions::RectangleMatch].value().match ().update ();

    // stretch_match
    mOptions[ResizeOptions::StretchMatch].setName ("stretch_match", CompOption::TypeMatch);
    mOptions[ResizeOptions::StretchMatch].value().set(CompMatch (""));
    mOptions[ResizeOptions::StretchMatch].value().match ().update ();

    // resize_from_center_match
    mOptions[ResizeOptions::ResizeFromCenterMatch].setName ("resize_from_center_match", CompOption::TypeMatch);
    mOptions[ResizeOptions::ResizeFromCenterMatch].value().set(CompMatch (""));
    mOptions[ResizeOptions::ResizeFromCenterMatch].value().match ().update ();

    // outline_modifier
    mOptions[ResizeOptions::OutlineModifier].setName ("outline_modifier", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[ResizeOptions::OutlineModifier].set (value);
    mOptions[ResizeOptions::OutlineModifier].rest ().set (0, 3);

    // rectangle_modifier
    mOptions[ResizeOptions::RectangleModifier].setName ("rectangle_modifier", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[ResizeOptions::RectangleModifier].set (value);
    mOptions[ResizeOptions::RectangleModifier].rest ().set (0, 3);

    // stretch_modifier
    mOptions[ResizeOptions::StretchModifier].setName ("stretch_modifier", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[ResizeOptions::StretchModifier].set (value);
    mOptions[ResizeOptions::StretchModifier].rest ().set (0, 3);

    // centered_modifier
    mOptions[ResizeOptions::CenteredModifier].setName ("centered_modifier", CompOption::TypeList);
    mOptions[ResizeOptions::CenteredModifier].rest ().set (0, 3);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[ResizeOptions::CenteredModifier].value().set (CompOption::TypeInt, list);

    mOutlineModifierMask = 0;
    foreach (CompOption::Value &val, mOptions[ResizeOptions::OutlineModifier].value ().list ())
        mOutlineModifierMask |= (1 << val.i ());

    mRectangleModifierMask = 0;
    foreach (CompOption::Value &val, mOptions[ResizeOptions::RectangleModifier].value ().list ())
        mRectangleModifierMask |= (1 << val.i ());

    mStretchModifierMask = 0;
    foreach (CompOption::Value &val, mOptions[ResizeOptions::StretchModifier].value ().list ())
        mStretchModifierMask |= (1 << val.i ());

    mCenteredModifierMask = 0;
    foreach (CompOption::Value &val, mOptions[ResizeOptions::CenteredModifier].value ().list ())
        mCenteredModifierMask |= (1 << val.i ());

}

ResizeOptions::~ResizeOptions ()
{
}


CompOption::Vector &
ResizeOptions::getOptions ()
{
    return mOptions;
}

bool
ResizeOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ResizeOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::InitiateButton].empty ())
                    mNotify[ResizeOptions::InitiateButton] (o, ResizeOptions::InitiateButton);
                return true;
            }
            break;
        case ResizeOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::InitiateKey].empty ())
                    mNotify[ResizeOptions::InitiateKey] (o, ResizeOptions::InitiateKey);
                return true;
            }
            break;
        case ResizeOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::Mode].empty ())
                    mNotify[ResizeOptions::Mode] (o, ResizeOptions::Mode);
                return true;
            }
            break;
        case ResizeOptions::ResizeFromCenter:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::ResizeFromCenter].empty ())
                    mNotify[ResizeOptions::ResizeFromCenter] (o, ResizeOptions::ResizeFromCenter);
                return true;
            }
            break;
        case ResizeOptions::MaximizeVertically:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::MaximizeVertically].empty ())
                    mNotify[ResizeOptions::MaximizeVertically] (o, ResizeOptions::MaximizeVertically);
                return true;
            }
            break;
        case ResizeOptions::IncreaseBorderContrast:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::IncreaseBorderContrast].empty ())
                    mNotify[ResizeOptions::IncreaseBorderContrast] (o, ResizeOptions::IncreaseBorderContrast);
                return true;
            }
            break;
        case ResizeOptions::UseDesktopAverageColor:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::UseDesktopAverageColor].empty ())
                    mNotify[ResizeOptions::UseDesktopAverageColor] (o, ResizeOptions::UseDesktopAverageColor);
                return true;
            }
            break;
        case ResizeOptions::BorderColor:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::BorderColor].empty ())
                    mNotify[ResizeOptions::BorderColor] (o, ResizeOptions::BorderColor);
                return true;
            }
            break;
        case ResizeOptions::FillColor:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::FillColor].empty ())
                    mNotify[ResizeOptions::FillColor] (o, ResizeOptions::FillColor);
                return true;
            }
            break;
        case ResizeOptions::DisableBlend:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::DisableBlend].empty ())
                    mNotify[ResizeOptions::DisableBlend] (o, ResizeOptions::DisableBlend);
                return true;
            }
            break;
        case ResizeOptions::NormalMatch:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::NormalMatch].empty ())
                    mNotify[ResizeOptions::NormalMatch] (o, ResizeOptions::NormalMatch);
                return true;
            }
            break;
        case ResizeOptions::OutlineMatch:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::OutlineMatch].empty ())
                    mNotify[ResizeOptions::OutlineMatch] (o, ResizeOptions::OutlineMatch);
                return true;
            }
            break;
        case ResizeOptions::RectangleMatch:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::RectangleMatch].empty ())
                    mNotify[ResizeOptions::RectangleMatch] (o, ResizeOptions::RectangleMatch);
                return true;
            }
            break;
        case ResizeOptions::StretchMatch:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::StretchMatch].empty ())
                    mNotify[ResizeOptions::StretchMatch] (o, ResizeOptions::StretchMatch);
                return true;
            }
            break;
        case ResizeOptions::ResizeFromCenterMatch:
            if (o->set (value))
            {
                if (!mNotify[ResizeOptions::ResizeFromCenterMatch].empty ())
                    mNotify[ResizeOptions::ResizeFromCenterMatch] (o, ResizeOptions::ResizeFromCenterMatch);
                return true;
            }
            break;
        case ResizeOptions::OutlineModifier:
            if (o->set (value))
            {
                mOutlineModifierMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mOutlineModifierMask |= (1 << val.i ());
                if (!mNotify[ResizeOptions::OutlineModifier].empty ())
                    mNotify[ResizeOptions::OutlineModifier] (o, ResizeOptions::OutlineModifier);
                return true;
            }
            break;
        case ResizeOptions::RectangleModifier:
            if (o->set (value))
            {
                mRectangleModifierMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mRectangleModifierMask |= (1 << val.i ());
                if (!mNotify[ResizeOptions::RectangleModifier].empty ())
                    mNotify[ResizeOptions::RectangleModifier] (o, ResizeOptions::RectangleModifier);
                return true;
            }
            break;
        case ResizeOptions::StretchModifier:
            if (o->set (value))
            {
                mStretchModifierMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mStretchModifierMask |= (1 << val.i ());
                if (!mNotify[ResizeOptions::StretchModifier].empty ())
                    mNotify[ResizeOptions::StretchModifier] (o, ResizeOptions::StretchModifier);
                return true;
            }
            break;
        case ResizeOptions::CenteredModifier:
            if (o->set (value))
            {
                mCenteredModifierMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mCenteredModifierMask |= (1 << val.i ());
                if (!mNotify[ResizeOptions::CenteredModifier].empty ())
                    mNotify[ResizeOptions::CenteredModifier] (o, ResizeOptions::CenteredModifier);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

