/*
 * Decompiled with CFR 0.152.
 */
package viz.util;

import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Util {
    public static void loadUIManager() {
        boolean lafLoaded = false;
        if (Util.isMac()) {
            String version = System.getProperty("os.version");
            int v = Integer.parseInt(version.split("\\.")[0]);
            if (v >= 5) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.antialiasing", "true");
            System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.draggableWindowBackground", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            try {
                try {
                    Class<?> qm = Class.forName("ch.randelshofer.quaqua.QuaquaManager");
                    Method method = qm.getMethod("setExcludedUIs", Set.class);
                    HashSet<String> excludes = new HashSet<String>();
                    excludes.add("Button");
                    excludes.add("ToolBar");
                    method.invoke(null, excludes);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                lafLoaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            UIManager.put("SystemFont", new Font("Lucida Grande", 0, 13));
            UIManager.put("SmallSystemFont", new Font("Lucida Grande", 0, 11));
        }
        if (!lafLoaded) {
            final UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (Util.isMac()) {
                                    UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs;
                                    int n = lafs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                                        if ("Mac OS X".equals(info.getName())) {
                                            UIManager.setLookAndFeel(info.getClassName());
                                            break block9;
                                        }
                                        ++n2;
                                    }
                                    break block9;
                                }
                                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs;
                                int n = lafs.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n3];
                                    if ("Nimbus".equals(info.getName())) {
                                        UIManager.setLookAndFeel(info.getClassName());
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                            catch (Exception e) {
                                try {
                                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                                }
                                catch (Exception e2) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static String formatToolTipAsHtml(String sToolTip) {
        String sStr = "<html>";
        int k = 0;
        int i = 0;
        while (i < sToolTip.length()) {
            char c = sToolTip.charAt(i);
            if (c == '\n') {
                sStr = String.valueOf(sStr) + "<br/>";
                k = 0;
            } else if (Character.isWhitespace(c)) {
                if (k > 60) {
                    sStr = String.valueOf(sStr) + "<br/>";
                    k = 0;
                } else {
                    sStr = String.valueOf(sStr) + " ";
                }
            } else {
                sStr = String.valueOf(sStr) + c;
            }
            ++k;
            ++i;
        }
        sStr = String.valueOf(sStr) + "</html>";
        return sStr;
    }

    public static String formatToolTipAsTeX(String sToolTip) {
        String sStr = "";
        int i = 0;
        while (i < sToolTip.length()) {
            char c = sToolTip.charAt(i);
            sStr = c == '\n' ? String.valueOf(sStr) + "\n\n" : (c == '%' ? String.valueOf(sStr) + "\\%" : (c == '_' ? String.valueOf(sStr) + "\\_" : String.valueOf(sStr) + c));
            ++i;
        }
        return sStr;
    }

    public static File[] getFile(String message, boolean bLoadNotSave, File defaultFileOrDir, boolean bAllowMultipleSelection, String description, final String ... extensions) {
        if (Util.isMac()) {
            Frame frame = new Frame();
            FileDialog chooser = new FileDialog(frame, message, bLoadNotSave ? 0 : 1);
            if (defaultFileOrDir != null) {
                if (defaultFileOrDir.isDirectory()) {
                    chooser.setDirectory(defaultFileOrDir.getAbsolutePath());
                } else {
                    chooser.setDirectory(defaultFileOrDir.getParentFile().getAbsolutePath());
                    chooser.setFile(defaultFileOrDir.getName());
                }
            }
            if (description != null) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        int i = 0;
                        while (i < extensions.length) {
                            if (name.toLowerCase().endsWith(extensions[i].toLowerCase())) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                };
                chooser.setFilenameFilter(filter);
            }
            chooser.setVisible(true);
            if (chooser.getFile() == null) {
                return null;
            }
            File file = new File(chooser.getDirectory(), chooser.getFile());
            chooser.dispose();
            frame.dispose();
            return new File[]{file};
        }
        Frame frame = new Frame();
        frame.setTitle(message);
        JFileChooser chooser = new JFileChooser(defaultFileOrDir);
        chooser.setMultiSelectionEnabled(bAllowMultipleSelection);
        if (description != null) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(description, extensions);
            chooser.setFileFilter(filter);
        }
        if (bLoadNotSave) {
            if (chooser.showOpenDialog(frame) == 0) {
                frame.dispose();
                if (bAllowMultipleSelection) {
                    return chooser.getSelectedFiles();
                }
                if (chooser.getSelectedFile() == null) {
                    return null;
                }
                return new File[]{chooser.getSelectedFile()};
            }
        } else if (chooser.showSaveDialog(frame) == 0) {
            frame.dispose();
            if (bAllowMultipleSelection) {
                return chooser.getSelectedFiles();
            }
            if (chooser.getSelectedFile() == null) {
                return null;
            }
            return new File[]{chooser.getSelectedFile()};
        }
        return null;
    }
}

