/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;

public class SecantSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public SecantSolver(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 100, 1.0E-6);
    }

    public SecantSolver() {
        super(100, 1.0E-6);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2, double d3) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2, d3);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(univariateRealFunction, d, d2);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(d, d2);
        double d3 = d;
        double d4 = d2;
        double d5 = univariateRealFunction.value(d3);
        double d6 = univariateRealFunction.value(d4);
        if (d5 * d6 >= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("function values at endpoints do not have different signs, endpoints: [{0}, {1}], values: [{2}, {3}]", d, d2, d5, d6);
        }
        double d7 = d3;
        double d8 = d5;
        double d9 = d7 - d4;
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            double d10;
            if (Math.abs(d8) < Math.abs(d6)) {
                d3 = d4;
                d4 = d7;
                d7 = d3;
                d5 = d6;
                d6 = d8;
                d8 = d5;
            }
            if (Math.abs(d6) <= this.functionValueAccuracy) {
                this.setResult(d4, i);
                return this.result;
            }
            if (Math.abs(d9) < Math.max(this.relativeAccuracy * Math.abs(d4), this.absoluteAccuracy)) {
                this.setResult(d4, i);
                return this.result;
            }
            if (Math.abs(d6) > Math.abs(d5)) {
                d10 = 0.5 * d9;
            } else {
                d10 = (d3 - d4) / (1.0 - d5 / d6);
                if (d10 / d9 > 1.0) {
                    d10 = 0.5 * d9;
                }
            }
            d3 = d4;
            d5 = d6;
            d6 = univariateRealFunction.value(d4 += d10);
            if (d6 > 0.0 == d8 > 0.0) {
                d7 = d3;
                d8 = d5;
            }
            d9 = d7 - d4;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

