/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class RombergIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public RombergIntegrator(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 32);
    }

    public RombergIntegrator() {
        super(32);
    }

    @Override
    @Deprecated
    public double integrate(double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, d, d2);
    }

    @Override
    public double integrate(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        int n = this.maximalIterationCount + 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        this.clearResult();
        this.verifyInterval(d, d2);
        this.verifyIterationCount();
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        dArray2[0] = trapezoidIntegrator.stage(univariateRealFunction, d, d2, 0);
        double d3 = dArray2[0];
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double d4;
            double d5;
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            dArray2[0] = trapezoidIntegrator.stage(univariateRealFunction, d, d2, i);
            for (int j = 1; j <= i; ++j) {
                double d6 = (1L << 2 * j) - 1L;
                double d7 = dArray2[j - 1];
                dArray2[j] = d7 + (d7 - dArray[j - 1]) / d6;
            }
            double d8 = dArray2[i];
            if (i >= this.minimalIterationCount && ((d5 = Math.abs(d8 - d3)) <= (d4 = this.relativeAccuracy * (Math.abs(d3) + Math.abs(d8)) * 0.5) || d5 <= this.absoluteAccuracy)) {
                this.setResult(d8, i);
                return this.result;
            }
            d3 = d8;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Override
    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 32) {
            throw MathRuntimeException.createIllegalArgumentException("invalid iteration limits: min={0}, max={1}", 0, 32);
        }
    }
}

