/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.framework.SingleDocMenuBarFactory;
import jam.mac.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFrame;

public class SingleDocApplication
extends Application {
    private DocumentFrame documentFrame = null;

    public SingleDocApplication(String nameString, String aboutString, Icon icon) {
        super(new SingleDocMenuBarFactory(), nameString, aboutString, icon);
    }

    public SingleDocApplication(String nameString, String aboutString, Icon icon, String websiteURLString, String helpURLString) {
        super(new SingleDocMenuBarFactory(), nameString, aboutString, icon, websiteURLString, helpURLString);
    }

    public SingleDocApplication(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon) {
        super(menuBarFactory, nameString, aboutString, icon);
    }

    public SingleDocApplication(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon, String websiteURLString, String helpURLString) {
        super(menuBarFactory, nameString, aboutString, icon, websiteURLString, helpURLString);
    }

    @Override
    public final void initialize() {
        if (Utils.isMacOSX()) {
            Utils.macOSXRegistration(this);
        }
    }

    public void setDocumentFrame(DocumentFrame documentFrame) {
        this.documentFrame = documentFrame;
        documentFrame.initialize();
        documentFrame.setVisible(true);
        documentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SingleDocApplication.this.thisWindowClosing(e);
            }
        });
    }

    @Override
    protected JFrame getDefaultFrame() {
        return this.documentFrame;
    }

    protected String getDocumentExtension() {
        return "";
    }

    @Override
    public DocumentFrame doNew() {
        throw new RuntimeException("A SingleDocApplication cannot do a New command");
    }

    @Override
    public DocumentFrame doOpenFile(File file) {
        this.documentFrame.openFile(file);
        return this.documentFrame;
    }

    public void doCloseWindow() {
        this.doQuit();
    }

    @Override
    public void doQuit() {
        if (this.documentFrame == null) {
            return;
        }
        if (this.documentFrame.requestClose()) {
            this.documentFrame.setVisible(false);
            this.documentFrame.dispose();
            System.exit(0);
        }
    }

    private void thisWindowClosing(WindowEvent e) {
        this.doQuit();
    }
}

