/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.StateNodeInitialiser;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeUtils;
import beast.util.treeparser.NewickLexer;
import beast.util.treeparser.NewickParser;
import beast.util.treeparser.NewickParserBaseVisitor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.NotNull;

@Description(value="Create beast.tree by parsing from a specification of a beast.tree in Newick format (includes parsing of any meta data in the Newick string).")
public class TreeParser
extends Tree
implements StateNodeInitialiser {
    static final double DEFAULT_LENGTH = (double)0.001f;
    List<String> labels = null;
    final boolean suppressMetadata = false;
    public final Input<Boolean> isLabelledNewickInput = new Input<Boolean>("IsLabelledNewick", "Is the newick tree labelled (alternatively contains node numbers)? Default=false.", false);
    public final Input<Alignment> dataInput = new Input("taxa", "Specifies the list of taxa represented by leaves in the beast.tree");
    public final Input<String> newickInput = new Input("newick", "initial beast.tree represented in newick format");
    public final Input<Integer> offsetInput = new Input<Integer>("offset", "offset if numbers are used for taxa (offset=the lowest taxa number) default=1", 1);
    public final Input<Double> thresholdInput = new Input<Double>("threshold", "threshold under which node heights (derived from lengths) are set to zero. Default=0.", 0.0);
    public final Input<Boolean> allowSingleChildInput = new Input<Boolean>("singlechild", "flag to indicate that single child nodes are allowed. Default=true.", true);
    public final Input<Boolean> adjustTipHeightsInput = new Input<Boolean>("adjustTipHeights", "flag to indicate if tipHeights shall be adjusted when date traits missing. Default=true.", true);
    public final Input<Double> scaleInput = new Input<Double>("scale", "scale used to multiply internal node heights during parsing. Useful for importing starting from external programs, for instance, RaxML tree rooted using Path-o-gen.", 1.0);
    public final Input<Boolean> binarizeMultifurcationsInput = new Input<Boolean>("binarizeMultifurcations", "Whether or not to turn multifurcations into sequences of bifurcations. (Default true.)", true);
    boolean createUnrecognizedTaxa = false;
    boolean integerLeafLabels = true;

    @Override
    public void initAndValidate() {
        Node[] nodeArray;
        Object object;
        boolean bl = false;
        if (this.dataInput.get() != null) {
            this.labels = this.dataInput.get().getTaxaNames();
        } else if (this.m_taxonset.get() != null) {
            if (this.labels == null) {
                this.labels = ((TaxonSet)this.m_taxonset.get()).asStringList();
            } else {
                bl = true;
            }
        } else if (this.isLabelledNewickInput.get().booleanValue()) {
            if (this.m_initial.get() != null) {
                this.labels = ((Tree)this.m_initial.get()).getTaxonset().asStringList();
            } else {
                this.labels = new ArrayList<String>();
                this.createUnrecognizedTaxa = true;
                bl = true;
            }
        } else if (this.m_initial.get() != null) {
            object = (Tree)this.m_initial.get();
            if (((Tree)object).m_taxonset.get() != null) {
                this.labels = ((Tree)object).m_taxonset.get().asStringList();
            }
        }
        object = this.newickInput.get();
        if (object == null || ((String)object).equals("")) {
            nodeArray = new Node();
            this.setRoot((Node)nodeArray);
        } else {
            this.setRoot(this.parseNewick(this.newickInput.get()));
        }
        super.initAndValidate();
        this.m_sTaxaNames = null;
        if (bl) {
            for (int i = 0; i < this.getNodeCount() && i < this.labels.size(); ++i) {
                this.m_nodes[i].setID(this.labels.get(i));
            }
            nodeArray = new Node[this.labels.size()];
            System.arraycopy(this.m_nodes, 0, nodeArray, 0, this.labels.size());
            Arrays.sort(nodeArray, (node, node2) -> node.getID().compareTo(node2.getID()));
            for (int i = 0; i < this.labels.size(); ++i) {
                this.m_nodes[i] = nodeArray[i];
                nodeArray[i].setNr(i);
            }
        }
        if (this.m_initial.get() != null) {
            this.processTraits(((Tree)this.m_initial.get()).m_traitList.get());
        } else {
            this.processTraits((List)this.m_traitList.get());
        }
        if (this.timeTraitSet != null) {
            this.adjustTreeNodeHeights(this.root);
        } else if (this.adjustTipHeightsInput.get().booleanValue()) {
            double d = TreeUtils.getTreeLength(this, this.getRoot());
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < this.getLeafNodeCount(); ++i) {
                double d4 = this.getNode(i).getHeight();
                if (d3 < d4) {
                    d3 = d4;
                }
                d2 += d4;
                this.getNode(i).setHeight(0.0);
            }
            double d5 = (d + d2) / d;
            if (d5 > 1.001) {
                DecimalFormat decimalFormat = new DecimalFormat("#.##");
                Log.info.println("WARNING: Adjust tip heights attribute set to 'true' in " + this.getClass().getSimpleName());
                Log.info.println("         has resulted in significant (>" + decimalFormat.format(0.1) + "%) change in tree length.");
                Log.info.println("         Use " + this.adjustTipHeightsInput.getName() + "='false' to override this default.");
                Log.info.printf("  original max tip age = %8.3f\n", d3);
                Log.info.printf("       new max tip age = %8.3f\n", 0.0);
                Log.info.printf("  original tree length = %8.3f\n", d);
                Log.info.printf("       new tree length = %8.3f\n", d + d2);
                Log.info.printf("       TL scale factor = %8.3f\n", d5);
            }
        }
        if (this.m_taxonset.get() == null && this.labels != null && this.isLabelledNewickInput.get().booleanValue()) {
            this.m_taxonset.setValue(new TaxonSet(Taxon.createTaxonList(this.labels)), this);
        }
        this.initStateNodes();
    }

    public TreeParser() {
    }

    public TreeParser(Alignment alignment, String string) {
        this.dataInput.setValue(alignment, this);
        this.newickInput.setValue(string, this);
        this.initAndValidate();
    }

    public TreeParser(List<String> list, String string, int n, boolean bl) {
        if (list == null) {
            this.isLabelledNewickInput.setValue(true, this);
        } else {
            this.m_taxonset.setValue(new TaxonSet(Taxon.createTaxonList(list)), this);
        }
        this.newickInput.setValue(string, this);
        this.offsetInput.setValue(n, this);
        this.adjustTipHeightsInput.setValue(bl, this);
        this.labels = list;
        this.initAndValidate();
    }

    public TreeParser(String string) {
        this(string, false, true, true, 1);
    }

    public TreeParser(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, true, 1);
    }

    public TreeParser(String string, boolean bl) {
        this(string, bl, true, true, 1);
    }

    public TreeParser(String string, boolean bl, boolean bl2, boolean bl3, int n) {
        this(string, bl, bl2, bl3, n, true);
    }

    public TreeParser(String string, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.newickInput.setValue(string, this);
        this.isLabelledNewickInput.setValue(bl3, this);
        this.adjustTipHeightsInput.setValue(bl, this);
        this.allowSingleChildInput.setValue(bl2, this);
        this.offsetInput.setValue(n, this);
        this.binarizeMultifurcationsInput.setValue(bl4, this);
        this.initAndValidate();
    }

    public Node parseNewick(String string) {
        ANTLRInputStream aNTLRInputStream = new ANTLRInputStream(string);
        BaseErrorListener baseErrorListener = new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object object, int n, int n2, String string, RecognitionException recognitionException) {
                throw new TreeParsingException(string, n2, n);
            }
        };
        NewickLexer newickLexer = new NewickLexer(aNTLRInputStream);
        newickLexer.removeErrorListeners();
        newickLexer.addErrorListener(baseErrorListener);
        CommonTokenStream commonTokenStream = new CommonTokenStream(newickLexer);
        NewickParser newickParser = new NewickParser(commonTokenStream);
        newickParser.removeErrorListeners();
        newickParser.addErrorListener(baseErrorListener);
        NewickParser.TreeContext treeContext = newickParser.tree();
        NewickASTVisitor newickASTVisitor = new NewickASTVisitor();
        return (Node)newickASTVisitor.visit(treeContext);
    }

    public void translateLeafIds(Map<String, String> map) {
        for (Node node : this.getExternalNodes()) {
            String string;
            String string2 = node.getID();
            if (string2 == null || !this.integerLeafLabels) {
                string2 = Integer.toString(node.getNr() + 1);
            }
            if ((string = map.get(string2)) == null) continue;
            node.setID(string);
        }
    }

    @Override
    public void initStateNodes() {
        if (this.m_initial.get() != null) {
            ((Tree)this.m_initial.get()).assignFromWithoutID(this);
        }
    }

    @Override
    public void getInitialisedStateNodes(List<StateNode> list) {
        if (this.m_initial.get() != null) {
            list.add((StateNode)this.m_initial.get());
        }
    }

    public class TreeParsingException
    extends RuntimeException {
        String message;
        Integer characterNum;
        Integer lineNum;

        TreeParsingException(String string, Integer n, Integer n2) {
            this.message = string;
            this.characterNum = n;
            this.lineNum = n2;
        }

        TreeParsingException(String string) {
            this(string, null, null);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public Integer getCharacterNum() {
            return this.characterNum;
        }

        public Integer getLineNum() {
            return this.lineNum;
        }
    }

    class NewickASTVisitor
    extends NewickParserBaseVisitor<Node> {
        private int numberedNodeCount = 0;

        NewickASTVisitor() {
        }

        @Override
        public Node visitTree(@NotNull NewickParser.TreeContext treeContext) {
            Node node = (Node)this.visit(treeContext.node());
            node.sort();
            this.convertLengthToHeight(node);
            this.numberUnnumberedNodes(node);
            BitSet bitSet = new BitSet();
            for (Node node2 : node.getAllLeafNodes()) {
                if (node2.getNr() < 0) continue;
                if (bitSet.get(node2.getNr())) {
                    throw new TreeParsingException("Duplicate taxon found: " + TreeParser.this.labels.get(node2.getNr()));
                }
                bitSet.set(node2.getNr());
            }
            return node;
        }

        private void processMetadata(Node node, NewickParser.MetaContext metaContext, boolean bl) {
            String string = "";
            for (int i = 0; i < metaContext.attrib().size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + metaContext.attrib().get(i).getText();
            }
            if (bl) {
                node.lengthMetaDataString = string;
            } else {
                node.metaDataString = string;
            }
            for (NewickParser.AttribContext attribContext : metaContext.attrib()) {
                Object object;
                Double[] doubleArray;
                String string2 = attribContext.attribKey.getText();
                if (attribContext.attribValue().attribNumber() != null) {
                    doubleArray = Double.parseDouble(attribContext.attribValue().attribNumber().getText());
                } else if (attribContext.attribValue().ASTRING() != null) {
                    object = attribContext.attribValue().ASTRING().getText();
                    if (((String)object).startsWith("\"") || ((String)object).startsWith("'")) {
                        object = ((String)object).substring(1, ((String)object).length() - 1);
                    }
                    doubleArray = object;
                } else if (attribContext.attribValue().vector() != null) {
                    try {
                        object = attribContext.attribValue().vector().attribValue();
                        Double[] doubleArray2 = new Double[object.size()];
                        for (int i = 0; i < object.size(); ++i) {
                            doubleArray2[i] = Double.parseDouble(((NewickParser.AttribValueContext)object.get(i)).getText());
                        }
                        doubleArray = doubleArray2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TreeParsingException("Encountered vector-valued metadata entry with one or more non-numeric elements.");
                    }
                } else {
                    throw new TreeParsingException("Encountered unknown metadata value.");
                }
                if (bl) {
                    node.setLengthMetaData(string2, doubleArray);
                    continue;
                }
                node.setMetaData(string2, doubleArray);
            }
        }

        private void binarizeMultifurcation(Node node) {
            if (node.getChildCount() > 2) {
                ArrayList<Node> arrayList = new ArrayList<Node>(node.getChildren());
                Node node2 = node;
                for (int i = 1; i < arrayList.size() - 1; ++i) {
                    Node node3 = (Node)arrayList.get(i);
                    Node node4 = TreeParser.this.newNode();
                    node4.setNr(-1);
                    node4.setHeight(0.0);
                    node2.addChild(node4);
                    node.removeChild(node3);
                    node4.addChild(node3);
                    node2 = node4;
                }
                node.removeChild((Node)arrayList.get(arrayList.size() - 1));
                node2.addChild((Node)arrayList.get(arrayList.size() - 1));
            }
        }

        @Override
        public Node visitNode(NewickParser.NodeContext nodeContext) {
            Node node = TreeParser.this.newNode();
            for (NewickParser.NodeContext nodeContext2 : nodeContext.node()) {
                node.addChild((Node)this.visit(nodeContext2));
            }
            NewickParser.PostContext postContext = nodeContext.post();
            if (postContext.nodeMeta != null) {
                this.processMetadata(node, postContext.nodeMeta, false);
            }
            if (postContext.lengthMeta != null) {
                this.processMetadata(node, postContext.lengthMeta, true);
            }
            if (postContext.length != null) {
                node.setHeight(Double.parseDouble(postContext.length.getText()));
            } else {
                node.setHeight(0.001f);
            }
            node.setNr(-1);
            if (postContext.label() != null) {
                node.setID(postContext.label().getText());
                if (postContext.label().number() == null || postContext.label().number().INT() == null) {
                    TreeParser.this.integerLeafLabels = false;
                }
                if (!TreeParser.this.isLabelledNewickInput.get().booleanValue() && postContext.label().number() != null && postContext.label().number().INT() != null) {
                    int n = Integer.parseInt(postContext.label().getText()) - TreeParser.this.offsetInput.get();
                    if (n < 0) {
                        throw new TreeParsingException("Node number given is smaller than current offset (" + TreeParser.this.offsetInput.get() + ").  Perhaps offset is " + "too high?");
                    }
                    node.setNr(n);
                    ++this.numberedNodeCount;
                } else if (node.isLeaf()) {
                    node.setNr(this.getLabelIndex(postContext.label().getText()));
                    ++this.numberedNodeCount;
                }
            }
            if (node.getChildCount() == 1 && !TreeParser.this.allowSingleChildInput.get().booleanValue()) {
                throw new TreeParsingException("Node with single child found.");
            }
            if (TreeParser.this.binarizeMultifurcationsInput.get().booleanValue()) {
                this.binarizeMultifurcation(node);
            }
            return node;
        }

        private int getLabelIndex(String string) {
            for (int i = 0; i < TreeParser.this.labels.size(); ++i) {
                if (!string.equals(TreeParser.this.labels.get(i))) continue;
                return i;
            }
            if (TreeParser.this.createUnrecognizedTaxa) {
                TreeParser.this.labels.add(string);
                return TreeParser.this.labels.size() - 1;
            }
            throw new TreeParsingException("Label '" + string + "' in Newick beast.tree could " + "not be identified. Perhaps taxa or taxonset is not specified?");
        }

        private void convertLengthToHeight(Node node) {
            double d = this.convertLengthToHeight(node, 0.0);
            this.offset(node, -d);
        }

        private double convertLengthToHeight(Node node, double d) {
            double d2 = node.getHeight();
            node.setHeight((d - d2) * TreeParser.this.scaleInput.get());
            if (node.isLeaf()) {
                return node.getHeight();
            }
            double d3 = Double.POSITIVE_INFINITY;
            for (Node node2 : node.getChildren()) {
                d3 = Math.min(d3, this.convertLengthToHeight(node2, d - d2));
            }
            return d3;
        }

        private void offset(Node node, double d) {
            node.setHeight(node.getHeight() + d);
            if (node.isLeaf() && node.getHeight() < TreeParser.this.thresholdInput.get()) {
                node.setHeight(0.0);
            }
            for (Node node2 : node.getChildren()) {
                this.offset(node2, d);
            }
        }

        private void numberUnnumberedNodes(Node node) {
            if (node.isLeaf()) {
                return;
            }
            for (Node node2 : node.getChildren()) {
                this.numberUnnumberedNodes(node2);
            }
            if (node.getNr() < 0) {
                node.setNr(this.numberedNodeCount);
            }
            ++this.numberedNodeCount;
        }
    }
}

