/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.ExponentialDistribution;
import org.apache.commons.math.distribution.ExponentialDistributionImpl;

@Description(value="Exponential distribution.  f(x;\\lambda) = 1/\\lambda e^{-x/\\lambda}, if x >= 0 If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class Exponential
extends ParametricDistribution {
    public final Input<RealParameter> lambdaInput = new Input("mean", "mean parameter, defaults to 1");
    static ExponentialDistribution m_dist = new ExponentialDistributionImpl(1.0);

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        double d;
        if (this.lambdaInput.get() == null) {
            d = 1.0;
        } else {
            d = this.lambdaInput.get().getValue();
            if (d < 0.0) {
                Log.err.println("Exponential::Lambda should be positive not " + d + ". Assigning default value.");
                d = 1.0;
            }
        }
        m_dist.setMean(d);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return m_dist;
    }

    @Override
    public double getMean() {
        return (Double)this.offsetInput.get() + m_dist.getMean();
    }
}

