/*
 * Decompiled with CFR 0.152.
 */
package beast.math;

import beast.math.GammaFunction;

public class Binomial {
    private static int maxN = 5000;
    private static double[] choose2LUT;

    public static double logChoose(int n, int n2) {
        return GammaFunction.lnGamma((double)n + 1.0) - GammaFunction.lnGamma((double)n2 + 1.0) - GammaFunction.lnGamma((double)(n - n2) + 1.0);
    }

    public static double choose(double d, double d2) {
        d = Math.floor(d + 0.5);
        d2 = Math.floor(d2 + 0.5);
        double d3 = GammaFunction.lnGamma(d + 1.0) - GammaFunction.lnGamma(d2 + 1.0) - GammaFunction.lnGamma(d - d2 + 1.0);
        return Math.floor(Math.exp(d3) + 0.5);
    }

    public static double choose2(int n) {
        try {
            return choose2LUT[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < 0) {
                return 0.0;
            }
            while (maxN < n) {
                maxN += 1000;
            }
            Binomial.initialize();
            return choose2LUT[n];
        }
    }

    private static void initialize() {
        choose2LUT = new double[maxN + 1];
        Binomial.choose2LUT[0] = 0.0;
        Binomial.choose2LUT[1] = 0.0;
        Binomial.choose2LUT[2] = 1.0;
        for (int i = 3; i <= maxN; ++i) {
            Binomial.choose2LUT[i] = (double)(i * (i - 1)) * 0.5;
        }
    }

    static {
        Binomial.initialize();
    }
}

