/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class TreeUtils {
    public static void rotateNodeByComparator(Node node, Comparator<Node> comparator) {
        if (node.getChildCount() > 2) {
            throw new RuntimeException("Not implemented yet!");
        }
        for (Node node2 : node.getChildren()) {
            TreeUtils.rotateNodeByComparator(node2, comparator);
        }
        if (node.getChildCount() > 1 && comparator.compare(node.getLeft(), node.getRight()) > 0) {
            Node node3 = node.getLeft();
            node.setLeft(node.getRight());
            node.setRight(node3);
        }
    }

    public static Comparator<Node> createNodeDensityComparator() {
        return (node, node2) -> node2.getLeafNodeCount() - node.getLeafNodeCount();
    }

    public static Comparator<Node> createNodeDensityMinNodeHeightComparator() {
        return (node, node2) -> {
            int n = node.getLeafNodeCount() - node2.getLeafNodeCount();
            if (n != 0) {
                return n;
            }
            double d = TreeUtils.getMinNodeHeight(node) - TreeUtils.getMinNodeHeight(node2);
            if (d > 0.0) {
                return -1;
            }
            if (d < 0.0) {
                return 1;
            }
            return 0;
        };
    }

    public static Comparator<Node> createReverseNodeDensityMinNodeHeightComparator() {
        return (node, node2) -> {
            int n = node2.getLeafNodeCount() - node.getLeafNodeCount();
            if (n != 0) {
                return n;
            }
            double d = TreeUtils.getMinNodeHeight(node2) - TreeUtils.getMinNodeHeight(node);
            if (d > 0.0) {
                return -1;
            }
            if (d < 0.0) {
                return 1;
            }
            return 0;
        };
    }

    public static double getMinNodeHeight(Node node) {
        if (!node.isLeaf()) {
            double d = Double.MAX_VALUE;
            for (Node node2 : node.getChildren()) {
                double d2 = TreeUtils.getMinNodeHeight(node2);
                if (!(d2 < d)) continue;
                d = d2;
            }
            return d;
        }
        return node.getHeight();
    }

    public static double getDoubleMetaData(Node node, String string) {
        Object object = node.getMetaData(string);
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return -1.0;
    }

    public static Node getCommonAncestorNode(Tree tree, Set<String> set) {
        int n = set.size();
        if (n == 0) {
            throw new IllegalArgumentException("No leaf nodes selected");
        }
        Node[] nodeArray = new Node[]{null};
        TreeUtils.getCommonAncestorNode(tree, tree.getRoot(), set, n, nodeArray);
        return nodeArray[0];
    }

    private static int getCommonAncestorNode(Tree tree, Node node, Set<String> set, int n, Node[] nodeArray) {
        if (node.isLeaf()) {
            if (set.contains(node.getID())) {
                if (n == 1) {
                    nodeArray[0] = node;
                }
                return 1;
            }
            return 0;
        }
        int n2 = 0;
        for (Node node2 : node.getChildren()) {
            n2 += TreeUtils.getCommonAncestorNode(tree, node2, set, n, nodeArray);
            if (nodeArray[0] == null) continue;
            break;
        }
        if (nodeArray[0] == null && n2 == n) {
            nodeArray[0] = node;
        }
        return n2;
    }

    public static double getTreeLength(Tree tree, Node node) {
        int n = node.getChildCount();
        if (n == 0) {
            return node.getLength();
        }
        double d = 0.0;
        for (Node node2 : node.getChildren()) {
            d += TreeUtils.getTreeLength(tree, node2);
        }
        if (node != tree.getRoot()) {
            d += node.getLength();
        }
        return d;
    }

    public static double getExternalLength(Tree tree) {
        double d = 0.0;
        for (Node node : tree.getExternalNodes()) {
            d += node.getLength();
            while (!node.isDirectAncestor() && node.getParent() != null && node.getParent().isFake()) {
                node = node.getParent();
                d += node.getLength();
            }
        }
        return d;
    }

    public static double getInternalLength(Tree tree) {
        double d = 0.0;
        block0: for (Node node : tree.getInternalNodes()) {
            d += node.getLength();
            if (!node.isFake() || !node.getNonDirectAncestorChild().isLeaf()) continue;
            while (true) {
                d -= node.getLength();
                if (node.getParent() == null || !node.getParent().isFake()) continue block0;
                node = node.getParent();
            }
        }
        return d;
    }

    public static double getTrunkLength(Tree tree, Node node) {
        int n = node.getChildCount();
        if (n == 0) {
            if (node.getHeight() == 0.0) {
                return node.getLength();
            }
            return 0.0;
        }
        double d = 0.0;
        for (Node node2 : node.getChildren()) {
            d += TreeUtils.getTrunkLength(tree, node2);
        }
        if (node != tree.getRoot() && d > 0.0) {
            d += node.getLength();
        }
        return d;
    }

    public static double[] getIntervals(Tree tree) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Node node : tree.getInternalNodes()) {
            arrayList.add(node.getHeight());
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        Object object = new double[arrayList.size()];
        for (int i = 0; i < ((Object)object).length - 1; ++i) {
            double d = (Double)arrayList.get(i);
            double d2 = (Double)arrayList.get(i + 1);
            object[i] = d - d2;
        }
        object[((Object)object).length - 1] = (Double)arrayList.get(((Object)object).length - 1);
        return object;
    }

    public static Set<String> getDescendantLeaves(Tree tree, Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        TreeUtils.getDescendantLeaves(tree, node, hashSet);
        return hashSet;
    }

    private static void getDescendantLeaves(Tree tree, Node node, Set<String> set) {
        if (node.isLeaf()) {
            set.add(tree.getTaxonId(node));
        } else {
            for (Node node2 : node.getChildren()) {
                TreeUtils.getDescendantLeaves(tree, node2, set);
            }
        }
    }

    public static boolean isUltrametric(Tree tree, double d) {
        for (Node node : tree.getExternalNodes()) {
            if (!(Math.abs(node.getHeight()) > d)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUltrametric(Tree tree) {
        for (Node node : tree.getExternalNodes()) {
            if (node.getHeight() == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isBinary(Tree tree) {
        for (Node node : tree.getInternalNodes()) {
            if (node.getChildCount() == 2) continue;
            return false;
        }
        return true;
    }

    public static String sortedNewickTopology(Node node, boolean bl) {
        int n;
        if (node.isLeaf()) {
            if (bl) {
                return String.valueOf(node.getID());
            }
            return String.valueOf(node.getNr());
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < node.getChildCount(); ++n) {
            arrayList.add(TreeUtils.sortedNewickTopology(node.getChild(n), bl));
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            stringBuilder.append((String)arrayList.get(n));
            if (n >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void preOrderTraversalList(Tree tree, int[] nArray) {
        int n = tree.getNodeCount();
        if (nArray.length != n) {
            throw new IllegalArgumentException("Illegal list length");
        }
        nArray[0] = tree.getRoot().getNr();
        TreeUtils.preOrderTraversalList(tree, 0, nArray);
    }

    public static int preOrderTraversalList(Tree tree, int n, int[] nArray) {
        Node node = tree.getNode(nArray[n]);
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChild(i);
            nArray[++n] = node2.getNr();
            if (node2.isLeaf()) continue;
            n = TreeUtils.preOrderTraversalList(tree, n, nArray);
        }
        return n;
    }
}

