/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.Description;
import beast.core.Input;
import beast.core.State;
import beast.core.parameter.RealParameter;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeDistribution;
import beast.evolution.tree.TreeInterface;
import beast.math.distributions.Gamma;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

@Description(value="Species tree prior for *BEAST analysis")
public class SpeciesTreePrior
extends TreeDistribution {
    public final Input<TreePopSizeFunction> popFunctionInput = new Input<TreePopSizeFunction>("popFunction", "Population function. This can be " + Arrays.toString((Object[])TreePopSizeFunction.values()) + " (default 'constant')", TreePopSizeFunction.constant, TreePopSizeFunction.values());
    public final Input<RealParameter> popSizesBottomInput = new Input("bottomPopSize", "population size parameter for populations at the bottom of a branch. For linear population function, this is the same at the top of the branch.", Input.Validate.REQUIRED);
    public final Input<RealParameter> popSizesTopInput = new Input("topPopSize", "population size parameter at the top of a branch. Ignored for constant population function, but required for linear population function.");
    public final Input<RealParameter> gammaParameterInput = new Input("gammaParameter", "scale parameter of the gamma distribution over population sizes. This makes this parameter half the expected population size on all branches for constant population function, but a quarter of the expected population size for tip branches only for linear population functions.", Input.Validate.REQUIRED);
    public final Input<TaxonSet> taxonSetInput = new Input("taxonset", "set of taxa mapping lineages to species", Input.Validate.REQUIRED);
    private TreePopSizeFunction popFunction;
    private RealParameter popSizesBottom;
    private RealParameter popSizesTop;
    private Gamma gamma2Prior;
    private Gamma gamma4Prior;

    @Override
    public void initAndValidate() {
        this.popFunction = this.popFunctionInput.get();
        this.popSizesBottom = this.popSizesBottomInput.get();
        this.popSizesTop = this.popSizesTopInput.get();
        int n = ((TreeInterface)this.treeInput.get()).getLeafNodeCount();
        int n2 = ((TreeInterface)this.treeInput.get()).getNodeCount();
        switch (this.popFunction) {
            case constant: {
                this.popSizesBottom.setDimension(n2);
                break;
            }
            case linear: {
                if (this.popSizesTop == null) {
                    throw new IllegalArgumentException("topPopSize must be specified");
                }
                this.popSizesBottom.setDimension(n);
                this.popSizesTop.setDimension(n2);
                break;
            }
            case linear_with_constant_root: {
                if (this.popSizesTop == null) {
                    throw new IllegalArgumentException("topPopSize must be specified");
                }
                this.popSizesBottom.setDimension(n);
                this.popSizesTop.setDimension(n2 - 1);
            }
        }
        this.gamma2Prior = new Gamma();
        this.gamma2Prior.betaInput.setValue(this.gammaParameterInput.get(), this.gamma2Prior);
        this.gamma4Prior = new Gamma();
        RealParameter realParameter = new RealParameter(new Double[]{4.0});
        this.gamma4Prior.alphaInput.setValue(realParameter, this.gamma4Prior);
        this.gamma4Prior.betaInput.setValue(this.gammaParameterInput.get(), this.gamma4Prior);
        if (this.popFunction != TreePopSizeFunction.constant && this.gamma4Prior == null) {
            throw new IllegalArgumentException("Top prior must be specified when population function is not constant");
        }
    }

    @Override
    public double calculateLogP() {
        this.logP = 0.0;
        Node[] nodeArray = ((TreeInterface)this.treeInput.get()).getNodesAsArray();
        try {
            switch (this.popFunction) {
                case constant: {
                    this.logP += this.gamma2Prior.calcLogP(this.popSizesBottom);
                    break;
                }
                case linear: {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        if (node.isLeaf()) {
                            double d = (Double)this.popSizesBottom.getValue(i);
                            this.logP += this.gamma4Prior.logDensity(d);
                        }
                        double d = (Double)this.popSizesTop.getValue(i);
                        this.logP += this.gamma2Prior.logDensity(d);
                    }
                    break;
                }
                case linear_with_constant_root: {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        if (node.isLeaf()) {
                            double d = (Double)this.popSizesBottom.getValue(i);
                            this.logP += this.gamma4Prior.logDensity(d);
                        }
                        if (node.isRoot()) continue;
                        if (i < nodeArray.length - 1) {
                            double d = this.popSizesTop.getArrayValue(i);
                            this.logP += this.gamma2Prior.logDensity(d);
                            continue;
                        }
                        int n = ((TreeInterface)this.treeInput.get()).getRoot().getNr();
                        double d = this.popSizesTop.getArrayValue(n);
                        this.logP += this.gamma2Prior.logDensity(d);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Double.NEGATIVE_INFINITY;
        }
        return this.logP;
    }

    @Override
    protected boolean requiresRecalculation() {
        return true;
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }

    @Override
    public void sample(State state, Random random) {
    }

    protected static enum TreePopSizeFunction {
        constant,
        linear,
        linear_with_constant_root;

    }
}

