/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.branchratemodel;

import beast.core.Description;
import beast.core.parameter.RealParameter;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.tree.Node;

@Description(value="Defines a mean rate for each branch in the beast.tree.")
public class StrictClockModel
extends BranchRateModel.Base {
    RealParameter muParameter;
    private double mu = 1.0;

    @Override
    public void initAndValidate() {
        this.muParameter = (RealParameter)this.meanRateInput.get();
        if (this.muParameter != null) {
            this.muParameter.setBounds(Math.max(0.0, (Double)this.muParameter.getLower()), this.muParameter.getUpper());
            this.mu = this.muParameter.getValue();
        }
    }

    @Override
    public double getRateForBranch(Node node) {
        return this.mu;
    }

    @Override
    public boolean requiresRecalculation() {
        this.mu = this.muParameter.getValue();
        return true;
    }

    @Override
    protected void restore() {
        this.mu = this.muParameter.getValue();
        super.restore();
    }

    @Override
    protected void store() {
        this.mu = this.muParameter.getValue();
        super.store();
    }
}

