/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.BEASTObject;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.StateNode;
import java.util.ArrayList;
import java.util.List;

@Description(value="Summarizes a set of valuables so that for example a rate matrix can be specified that uses a parameter in various places in the matrix.")
public class CompoundValuable
extends CalculationNode
implements Function {
    public final Input<List<BEASTObject>> m_values = new Input("var", "reference to a valuable", new ArrayList(), Input.Validate.REQUIRED, Function.class);
    boolean m_bRecompute = true;
    double[] m_fValues;

    @Override
    public void initAndValidate() {
        int n = 0;
        for (BEASTObject bEASTObject : this.m_values.get()) {
            if (!(bEASTObject instanceof Function)) {
                throw new IllegalArgumentException("Input does not implement Valuable");
            }
            n += ((Function)((Object)bEASTObject)).getDimension();
        }
        this.m_fValues = new double[n];
    }

    @Override
    public int getDimension() {
        return this.m_fValues.length;
    }

    @Override
    public double getArrayValue() {
        if (this.m_bRecompute) {
            this.recompute();
        }
        return this.m_fValues[0];
    }

    @Override
    public double getArrayValue(int n) {
        if (this.m_bRecompute) {
            this.recompute();
        }
        return this.m_fValues[n];
    }

    private void recompute() {
        int n = 0;
        for (BEASTObject bEASTObject : this.m_values.get()) {
            Function function = (Function)((Object)bEASTObject);
            if (bEASTObject instanceof StateNode) {
                function = ((StateNode)bEASTObject).getCurrent();
            }
            int n2 = function.getDimension();
            for (int i = 0; i < n2; ++i) {
                this.m_fValues[n++] = function.getArrayValue(i);
            }
        }
        this.m_bRecompute = false;
    }

    @Override
    public void store() {
        this.m_bRecompute = true;
        super.store();
    }

    @Override
    public void restore() {
        this.m_bRecompute = true;
        super.restore();
    }

    @Override
    public boolean requiresRecalculation() {
        this.m_bRecompute = true;
        return true;
    }
}

